/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.configuration;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.codehaus.mojo.dashboard.report.plugin.configuration.Configuration;
import org.codehaus.mojo.dashboard.report.plugin.configuration.ConfigurationServiceException;
import org.codehaus.mojo.dashboard.report.plugin.configuration.Graph;
import org.codehaus.mojo.dashboard.report.plugin.configuration.IConfigurationService;
import org.codehaus.mojo.dashboard.report.plugin.configuration.Section;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigurationService
implements IConfigurationService {
    private List warningsMsg = new ArrayList();
    private boolean isValid = true;
    private boolean isValidXSD = true;
    private Configuration dashConfig;
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private String configfile = "";

    public ConfigurationService(String configfile) throws ConfigurationServiceException {
        this.configfile = configfile;
        this.validateConfigFileWithXSD();
        if (!this.isValidXSD) {
            this.isValid = false;
            throw new ConfigurationServiceException("XML config validation with schema failed : " + this.configfile);
        }
        this.dashConfig = this.readConfigFile(this.configfile);
        this.validateConfigFile();
    }

    public Configuration getConfiguration() {
        return this.dashConfig;
    }

    public String getConfigFile() {
        return this.configfile;
    }

    public void setConfigFile(String configFile) {
        this.configfile = configFile;
    }

    public boolean isValidConfig() {
        return this.isValid;
    }

    private void validateConfigFileWithXSD() {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("config/maven-dashboard-config.xsd");
        try {
            InputSource xmlFile = new InputSource(new FileInputStream(this.configfile));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setNamespaceAware(true);
            dbf.setValidating(true);
            dbf.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            dbf.setAttribute(JAXP_SCHEMA_SOURCE, stream);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(new MyDefaultHandler());
            db.parse(xmlFile);
        }
        catch (SAXException e) {
            this.isValidXSD = false;
            e.printStackTrace();
        }
        catch (IOException e) {
            this.isValidXSD = false;
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            this.isValidXSD = false;
            e.printStackTrace();
        }
        System.out.println(this.isValidXSD);
    }

    private void validateConfigFile() {
        if (this.dashConfig != null) {
            List sections = this.dashConfig.getSections();
            Iterator iter = sections.iterator();
            while (iter.hasNext()) {
                Section section = (Section)iter.next();
                if (section.isValidGraphs()) continue;
                this.isValid = false;
                this.warningsMsg.addAll(section.getWarningMessages());
                break;
            }
        } else {
            this.isValid = false;
        }
    }

    public List getWarningMessages() {
        return this.warningsMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration readConfigFile(String configFile) throws ConfigurationServiceException {
        Configuration dashConfiguration = null;
        try {
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
            File fichier = new File(configFile);
            FileInputStream fis = new FileInputStream(fichier);
            try {
                xstream.setMode(1001);
                xstream.alias("configuration", Configuration.class);
                xstream.useAttributeFor("version", String.class);
                xstream.alias("section", Section.class);
                xstream.alias("graph", Graph.class);
                xstream.useAttributeFor("id", String.class);
                xstream.useAttributeFor("title", String.class);
                xstream.useAttributeFor("timeUnit", String.class);
                xstream.useAttributeFor("groupId", String.class);
                xstream.useAttributeFor("artifactId", String.class);
                xstream.useAttributeFor("startPeriod", String.class);
                xstream.useAttributeFor("endPeriod", String.class);
                dashConfiguration = (Configuration)xstream.fromXML((InputStream)fis);
            }
            finally {
                fis.close();
            }
        }
        catch (FileNotFoundException e) {
            dashConfiguration = null;
            throw new ConfigurationServiceException("readConfigFile() failed : " + this.configfile, e);
        }
        catch (IOException e) {
            dashConfiguration = null;
            throw new ConfigurationServiceException("readConfigFile() failed : " + this.configfile, e);
        }
        return dashConfiguration;
    }

    class MyDefaultHandler
    extends DefaultHandler {
        private String errMessage = "";

        MyDefaultHandler() {
        }

        public void warning(SAXParseException e) {
            System.out.println("Warning Line " + e.getLineNumber() + ": " + e.getMessage() + "\n");
        }

        public void error(SAXParseException e) {
            this.errMessage = new String("Error Line " + e.getLineNumber() + ": " + e.getMessage() + "\n");
            System.out.println(this.errMessage);
            ConfigurationService.this.isValidXSD = false;
        }

        public void fatalError(SAXParseException e) {
            this.errMessage = new String("Error Line " + e.getLineNumber() + ": " + e.getMessage() + "\n");
            System.out.println(this.errMessage);
            ConfigurationService.this.isValidXSD = false;
        }
    }
}

