/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.chart.time;

import java.awt.Paint;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.codehaus.mojo.dashboard.report.plugin.beans.PmdReportBean;
import org.codehaus.mojo.dashboard.report.plugin.chart.time.AbstractTimeChartStrategy;
import org.jfree.chart.ChartColor;
import org.jfree.data.time.TimeSeries;

public class PmdTimeChartStrategy
extends AbstractTimeChartStrategy {
    public PmdTimeChartStrategy(ResourceBundle bundle, String title, List results, String timeUnit, Date startDate, Date endDate) {
        super(bundle, title, results, timeUnit, startDate, endDate);
    }

    public void fillDataset() {
        TimeSeries s1 = new TimeSeries(this.bundle.getString("report.pmd.label.nbclasses"), this.periodClass);
        TimeSeries s2 = new TimeSeries(this.bundle.getString("report.pmd.label.nbviolations"), this.periodClass);
        Iterator iter = this.mResults.iterator();
        while (iter.hasNext()) {
            PmdReportBean pmd = (PmdReportBean)iter.next();
            Date date = pmd.getDateGeneration();
            s1.addOrUpdate(this.getChartDate(this.timePeriod.normalize(date)), (double)pmd.getNbClasses());
            s2.addOrUpdate(this.getChartDate(this.timePeriod.normalize(date)), (double)pmd.getNbViolations());
        }
        this.defaultdataset.addSeries(s1);
        this.defaultdataset.addSeries(s2);
    }

    public Paint[] getPaintColor() {
        return new Paint[]{ChartColor.GREEN, ChartColor.RED};
    }
}

