/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.chart;

import java.awt.Paint;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.codehaus.mojo.dashboard.report.plugin.beans.CheckstyleError;
import org.codehaus.mojo.dashboard.report.plugin.beans.CheckstyleReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.IDashBoardReportBean;
import org.codehaus.mojo.dashboard.report.plugin.chart.AbstractPieChartStrategy;
import org.codehaus.mojo.dashboard.report.plugin.utils.ChartUtils;
import org.jfree.chart.ChartColor;

public class CheckstyleErrorsPieChartStrategy
extends AbstractPieChartStrategy {
    public CheckstyleErrorsPieChartStrategy(ResourceBundle bundle, String title, IDashBoardReportBean dashboardReport) {
        super(bundle, title, dashboardReport);
    }

    public Paint[] getPaintColor() {
        return new Paint[]{ChartUtils.BLUE_LIGHT, ChartColor.RED, ChartUtils.YELLOW_LIGHT};
    }

    private float percent(int nbIteration, int nbTotal) {
        float percent = (float)nbIteration * 100.0f / (float)nbTotal;
        percent *= 1000.0f;
        percent = (int)((double)percent + 0.5);
        return percent /= 1000.0f;
    }

    public void fillDataset() {
        if (this.mDashboardReport instanceof CheckstyleReportBean) {
            float percentVal = 0.0f;
            int nbItInfPercent = 0;
            CheckstyleReportBean checkstyleReportBean = (CheckstyleReportBean)this.mDashboardReport;
            CheckstyleError error = new CheckstyleError();
            Iterator iterator = checkstyleReportBean.getErrors().iterator();
            while (iterator.hasNext()) {
                error = (CheckstyleError)iterator.next();
                percentVal = this.percent(error.getNbIteration(), checkstyleReportBean.getNbTotal());
                if (percentVal > 1.0f) {
                    this.defaultdataset.setValue((Comparable)((Object)(error.getMessage() + " = " + percentVal + "%")), (double)error.getNbIteration());
                    continue;
                }
                nbItInfPercent += error.getNbIteration();
            }
            if (nbItInfPercent > 0) {
                percentVal = this.percent(nbItInfPercent, checkstyleReportBean.getNbTotal());
                this.defaultdataset.setValue((Comparable)((Object)(this.bundle.getString("chart.checkstyle.violations.others.label") + " = " + percentVal + "%")), (double)nbItInfPercent);
            }
        }
    }
}

