/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.module.xhtml.XhtmlSink;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.mojo.dashboard.report.plugin.AbstractDashBoardGenerator;
import org.codehaus.mojo.dashboard.report.plugin.DashBoardHistoricReportGenerator;
import org.codehaus.mojo.dashboard.report.plugin.DashBoardMaven1ReportGenerator;
import org.codehaus.mojo.dashboard.report.plugin.DashBoardMultiReportGenerator;
import org.codehaus.mojo.dashboard.report.plugin.DashBoardReportGenerator;
import org.codehaus.mojo.dashboard.report.plugin.DashBoardUtils;
import org.codehaus.mojo.dashboard.report.plugin.beans.DashBoardMavenProject;
import org.codehaus.mojo.dashboard.report.plugin.configuration.Configuration;
import org.codehaus.mojo.dashboard.report.plugin.configuration.ConfigurationService;
import org.codehaus.mojo.dashboard.report.plugin.configuration.ConfigurationServiceException;
import org.codehaus.mojo.dashboard.report.plugin.hibernate.HibernateService;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringInputStream;
import org.codehaus.plexus.util.StringUtils;

public class DashBoardReportMojo
extends AbstractMavenReport {
    private MavenProject project;
    private File outputDirectory;
    private SiteRenderer siteRenderer;
    protected String dashboardDataFile;
    private String outputName;
    protected ArtifactRepository localRepository;
    private int nbExportedPackagesSummary;
    protected MavenProjectBuilder mavenProjectBuilder;
    protected HibernateService hibernateService;
    protected String dialect;
    protected String driverClass;
    protected String connectionUrl;
    protected String username;
    protected String password;
    private String configLocation;
    private ResourceManager locator;
    private boolean m1LikeRendering;
    private boolean keepVersionAsDiscriminantCriteria;
    private boolean generateGraphs;
    private DashBoardUtils dashBoardUtils;
    private Locale locale;
    protected boolean isPropHibernateSet = false;

    protected void executeReport(Locale arg0) throws MavenReportException {
        boolean canGenerate;
        this.locale = arg0;
        this.locator.addSearchPath("file", this.project.getFile().getParentFile().getAbsolutePath());
        this.locator.addSearchPath("url", "");
        this.locator.setOutputDirectory(new File(this.project.getBuild().getDirectory()));
        this.getLog().info((CharSequence)("MultiReportMojo project = " + this.project.getName()));
        this.getLog().info((CharSequence)("MultiReportMojo nb modules = " + this.project.getModules().size()));
        this.getLog().info((CharSequence)("MultiReportMojo base directory = " + this.project.getBasedir()));
        this.getLog().info((CharSequence)("MultiReportMojo output directory = " + this.outputDirectory));
        this.getLog().info((CharSequence)("MultiReportMojo report output directory = " + this.getReportOutputDirectory()));
        this.getLog().info((CharSequence)("MultiReportMojo project language = " + this.project.getArtifact().getArtifactHandler().getLanguage()));
        this.copyStaticResources();
        this.dashBoardUtils = DashBoardUtils.getInstance(this.getLog(), this.mavenProjectBuilder, this.localRepository, false);
        this.isPropHibernateSet = this.isDBAvailable();
        if (this.isPropHibernateSet) {
            this.configureHibernateDriver();
        }
        if (canGenerate = this.canGenerateReport()) {
            DashBoardMavenProject mavenProject = null;
            if (this.isPropHibernateSet) {
                this.configureHibernateDriver();
            }
            Date generatedDate = new Date(System.currentTimeMillis());
            mavenProject = this.dashBoardUtils.getDashBoardMavenProject(this.project, this.dashboardDataFile, generatedDate);
            this.dashBoardUtils.saveXMLDashBoardReport(this.project, mavenProject, this.dashboardDataFile);
            if (mavenProject != null) {
                boolean isSummary = false;
                if (mavenProject.getModules() != null && !mavenProject.getModules().isEmpty()) {
                    isSummary = true;
                }
                AbstractDashBoardGenerator reportGenerator = null;
                reportGenerator = this.project.getModules() != null && this.project.getModules().size() > 0 && this.m1LikeRendering ? new DashBoardMaven1ReportGenerator(mavenProject, this.isPropHibernateSet, this.getLog()) : new DashBoardReportGenerator(mavenProject, isSummary, this.isPropHibernateSet, this.generateGraphs, this.getLog());
                reportGenerator.setImagesPath(this.getReportOutputDirectory() + "/images");
                reportGenerator.setNbExportedPackagesSummary(this.nbExportedPackagesSummary);
                reportGenerator.doGenerateReport(this.getBundle(this.locale), this.getSink());
                if (this.isPropHibernateSet) {
                    ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
                    Configuration dashConfig = null;
                    try {
                        ClassLoader dashboardClassLoader = DashBoardUtils.class.getClassLoader();
                        Thread.currentThread().setContextClassLoader(dashboardClassLoader);
                        String configFile = this.getConfigFile();
                        this.getLog().info((CharSequence)("getConfigFile() = " + configFile));
                        ConfigurationService configService = new ConfigurationService(configFile);
                        dashConfig = configService.getConfiguration();
                        if (!configService.isValidConfig()) {
                            List warningMsg = configService.getWarningMessages();
                            Iterator iter = warningMsg.iterator();
                            while (iter.hasNext()) {
                                this.getLog().error((CharSequence)((String)iter.next()));
                            }
                            throw new MavenReportException("The maven-dashboard-config.xml is not valid. see error messages above or see the maven-dashboard-config.xsd file.");
                        }
                    }
                    catch (ConfigurationServiceException e) {
                        this.getLog().error((CharSequence)"DashBoardHistoricReportMojo executeReport() failed.", (Throwable)e);
                        throw new MavenReportException("The maven-dashboard-config.xml is not valid. see error messages above or see the maven-dashboard-config.xsd file.");
                    }
                    catch (Exception e) {
                        this.getLog().error((CharSequence)"DashBoardHistoricReportMojo executeReport() failed.", (Throwable)e);
                        throw new MavenReportException("The maven-dashboard-config.xml is not valid. see error messages above or see the maven-dashboard-config.xsd file.");
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(currentClassLoader);
                    }
                    try {
                        if (dashConfig != null) {
                            XhtmlSink sink = this.getSiteRenderer().createSink(this.getReportOutputDirectory(), this.getOutputName() + "-historic.html", this.getReportOutputDirectory().getPath(), this.getSiteDescriptor(), "maven");
                            DashBoardHistoricReportGenerator histoReportGenerator = new DashBoardHistoricReportGenerator(mavenProject, this.hibernateService, dashConfig, this.keepVersionAsDiscriminantCriteria, this.generateGraphs, this.getLog());
                            histoReportGenerator.setImagesPath(this.getReportOutputDirectory() + "/images");
                            histoReportGenerator.doGenerateReport(this.getBundle(this.locale), (Sink)sink);
                        }
                    }
                    catch (MojoExecutionException e) {
                        this.getLog().error((CharSequence)"DashBoardHistoricReportMojo executeReport() failed.", (Throwable)e);
                    }
                    catch (Exception e) {
                        this.getLog().error((CharSequence)"DashBoardHistoricReportMojo executeReport() failed.", (Throwable)e);
                    }
                }
                if (this.project.getModules() != null && this.project.getModules().size() > 0 && !this.m1LikeRendering) {
                    try {
                        XhtmlSink sink = this.getSiteRenderer().createSink(this.getReportOutputDirectory(), this.getOutputName() + "-details.html", this.getReportOutputDirectory().getPath(), this.getSiteDescriptor(), "maven");
                        DashBoardMultiReportGenerator detailReportGenerator = new DashBoardMultiReportGenerator(mavenProject, this.isPropHibernateSet, this.generateGraphs, this.getLog());
                        detailReportGenerator.setImagesPath(this.getReportOutputDirectory() + "/images");
                        detailReportGenerator.doGenerateReport(this.getBundle(this.locale), (Sink)sink);
                    }
                    catch (MojoExecutionException e) {
                        this.getLog().error((CharSequence)"DashBoardReportMojo executeReport() failed.", (Throwable)e);
                    }
                    catch (Exception e) {
                        this.getLog().error((CharSequence)"DashBoardReportMojo executeReport() failed.", (Throwable)e);
                    }
                }
            }
        }
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getPath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        String description = "";
        description = this.project.getModules().size() > 0 ? this.getBundle(locale).getString("dashboard.multireport.description") : this.getBundle(locale).getString("dashboard.report.description");
        return description;
    }

    public String getName(Locale locale) {
        String name = "";
        name = this.project.getModules().size() > 0 ? this.getBundle(locale).getString("dashboard.multireport.name") : this.getBundle(locale).getString("dashboard.report.name");
        return name;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("dashboard-report-plugin", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public boolean usePageLinkBar() {
        return true;
    }

    private InputStream getSiteDescriptor() throws MojoExecutionException {
        String siteDescriptorContent = "";
        try {
            siteDescriptorContent = IOUtil.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/default-report.xml"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("The site descriptor cannot be read!", (Exception)e);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("reports", this.getReportsMenu());
        if (this.getProject().getName() != null) {
            props.put("project.name", this.getProject().getName());
        } else {
            props.put("project.name", "NO_PROJECT_NAME_SET");
        }
        if (this.getProject().getUrl() != null) {
            props.put("project.url", this.getProject().getUrl());
        } else {
            props.put("project.url", "NO_PROJECT_URL_SET");
        }
        siteDescriptorContent = StringUtils.interpolate((String)siteDescriptorContent, props);
        return new StringInputStream(siteDescriptorContent);
    }

    private String getReportsMenu() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<menu name=\"Project Reports\">\n");
        buffer.append("  <item name=\"Root\" href=\"/project-reports.html\"/>\n");
        buffer.append("  <item name=\"" + this.getName(this.locale) + "\" href=\"/" + this.getOutputName() + ".html\"/>\n");
        buffer.append("</menu>\n");
        return buffer.toString();
    }

    public boolean canGenerateReport() {
        if (this.project.getCollectedProjects().size() < this.project.getModules().size()) {
            this.getLog().info((CharSequence)"DashBoardReportMojo: Not recursive into sub-projects - skipping report.");
            return false;
        }
        return true;
    }

    protected void configureHibernateDriver() {
        this.hibernateService.setDialect(this.dialect);
        this.hibernateService.setDriverClass(this.driverClass);
        this.hibernateService.setConnectionUrl(this.connectionUrl);
        this.hibernateService.setUsername(this.username);
        this.hibernateService.setPassword(this.password);
    }

    protected boolean isDBAvailable() {
        boolean isDBAvailable = false;
        if (this.dialect != null && this.dialect.length() > 0 && this.driverClass != null && this.driverClass.length() > 0 && this.connectionUrl != null && this.connectionUrl.length() > 0 && this.username != null && this.username.length() > 0 && this.password != null && this.password.length() > 0) {
            isDBAvailable = true;
        }
        return isDBAvailable;
    }

    private String getConfigFile() throws MavenReportException {
        try {
            this.getLog().info((CharSequence)("getConfigFile() = " + this.configLocation));
            File configFile = this.locator.getResourceAsFile(this.configLocation, "default-dashboard-config.xml");
            if (configFile == null) {
                throw new MavenReportException("Unable to process dashboard config location: " + this.configLocation);
            }
            return configFile.getAbsolutePath();
        }
        catch (ResourceNotFoundException e) {
            throw new MavenReportException("Unable to find dashboard configuration file at location " + this.configLocation, (Exception)((Object)e));
        }
        catch (FileResourceCreationException e) {
            throw new MavenReportException("Unable to process dashboard configuration file location " + this.configLocation, (Exception)((Object)e));
        }
    }

    private void copyStaticResources() throws MavenReportException {
        String[] resourceNames = new String[]{"images/down.gif", "images/Down-green-full.jpg", "images/Down-red-full.jpg", "images/Down-orange-full.jpg", "images/next.gif", "images/previous.gif", "images/up.gif", "images/Stable-green-full.jpg", "images/Stable-red-full.jpg", "images/Stable-orange-full.jpg", "images/Up-green-full.jpg", "images/Up-red-full.jpg", "images/Up-orange-full.jpg", "css/dashboard.css", "css/dashboard2.css", "css/dashboard2IE.css"};
        try {
            this.getLog().debug((CharSequence)"Copying static resources.");
            for (int i = 0; i < resourceNames.length; ++i) {
                URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourceNames[i]);
                FileUtils.copyURLToFile((URL)url, (File)new File(this.getReportOutputDirectory(), resourceNames[i]));
            }
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to copy static resources.");
        }
    }
}

