/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.mojo.dashboard.report.plugin.AbstractDashBoardGenerator;
import org.codehaus.mojo.dashboard.report.plugin.beans.CheckstyleReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.CloverReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.CoberturaReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.CpdReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.DashBoardMavenProject;
import org.codehaus.mojo.dashboard.report.plugin.beans.FindBugsReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.IDashBoardReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.JDependReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.PmdReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.SurefireReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.TagListReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.XRefPackageBean;
import org.codehaus.mojo.dashboard.report.plugin.chart.BarChartRenderer;
import org.codehaus.mojo.dashboard.report.plugin.chart.CheckstyleBarChartStrategy;
import org.codehaus.mojo.dashboard.report.plugin.chart.CoberturaBarChartStrategy;
import org.codehaus.mojo.dashboard.report.plugin.chart.CpdBarChartStrategy;
import org.codehaus.mojo.dashboard.report.plugin.chart.FindBugsBarChartStrategy;
import org.codehaus.mojo.dashboard.report.plugin.chart.MultiCloverBarChartStrategy;
import org.codehaus.mojo.dashboard.report.plugin.chart.PmdBarChartStrategy;
import org.codehaus.mojo.dashboard.report.plugin.chart.StackedBarChartRenderer;
import org.codehaus.mojo.dashboard.report.plugin.chart.SurefireBarChartStrategy;
import org.codehaus.mojo.dashboard.report.plugin.chart.TaglistBarChartStrategy;

public class DashBoardMultiReportGenerator
extends AbstractDashBoardGenerator {
    private String dashboardReportFile = "dashboard-report.html";
    private String coberturaAnchorLink = "/" + this.dashboardReportFile + "#cobertura";
    private String cloverAnchorLink = "/" + this.dashboardReportFile + "#clover";
    private String surefireAnchorLink = "/" + this.dashboardReportFile + "#surefire";
    private String checkstyleAnchorLink = "/" + this.dashboardReportFile + "#checkstyle";
    private String taglistAnchorLink = "/" + this.dashboardReportFile + "#taglist";
    private String pmdAnchorLink = "/" + this.dashboardReportFile + "#pmd";
    private String cpdAnchorLink = "/" + this.dashboardReportFile + "#cpd";
    private String findbugsAnchorLink = "/" + this.dashboardReportFile + "#findbugs";
    private DashBoardMavenProject mavenProject;
    private Map map = new Hashtable();
    private boolean isDBAvailable = false;
    private boolean generateGraphs = true;

    public DashBoardMultiReportGenerator(DashBoardMavenProject mavenProject, boolean isDBAvailable, boolean generateGraphs, Log log) {
        super(log);
        this.mavenProject = mavenProject;
        this.isDBAvailable = isDBAvailable;
        this.generateGraphs = generateGraphs;
        Set reports = mavenProject.getReports();
        Iterator iter = reports.iterator();
        while (iter.hasNext()) {
            IDashBoardReportBean report = (IDashBoardReportBean)iter.next();
            if (report == null) continue;
            this.map.put(report.getClass(), report);
        }
    }

    public void doGenerateReport(ResourceBundle bundle, Sink sink) {
        this.getLog().debug((CharSequence)"DashBoardMultiReportGenerator doGenerateReport(...)");
        this.createTitle(bundle, sink);
        this.addDashboardCss(sink);
        sink.body();
        sink.anchor("top");
        sink.anchor_();
        this.createHeader(bundle, sink);
        this.createBodyReport(bundle, sink);
        sink.body_();
        sink.flush();
        sink.close();
    }

    public void createTitle(ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("dashboard.multireport.name"));
        sink.title_();
        sink.head_();
    }

    public void createHeader(ResourceBundle bundle, Sink sink) {
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("dashboard.multireport.name") + " : " + this.mavenProject.getProjectName());
        sink.sectionTitle1_();
        sink.text("Date Generated: " + new SimpleDateFormat().format(new Date(System.currentTimeMillis())));
        sink.horizontalRule();
        sink.sectionTitle3();
        sink.text("[");
        sink.link("dashboard-report.html");
        sink.text("Summary Dashboard");
        sink.link_();
        sink.text("]");
        sink.sectionTitle3_();
        sink.horizontalRule();
        if (this.map.get(CoberturaReportBean.class) != null) {
            sink.text("[");
            sink.link("#cobertura");
            sink.text(bundle.getString("report.cobertura.header"));
            sink.link_();
            sink.text("]");
            sink.lineBreak();
        }
        if (this.map.get(CloverReportBean.class) != null) {
            sink.text("[");
            sink.link("#clover");
            sink.text(bundle.getString("report.clover.header"));
            sink.link_();
            sink.text("]");
            sink.lineBreak();
        }
        if (this.map.get(SurefireReportBean.class) != null) {
            sink.text("[");
            sink.link("#surefire");
            sink.text(bundle.getString("report.surefire.header"));
            sink.link_();
            sink.text("]");
            sink.lineBreak();
        }
        if (this.map.get(CheckstyleReportBean.class) != null) {
            sink.text("[");
            sink.link("#checkstyle");
            sink.text(bundle.getString("report.checkstyle.header"));
            sink.link_();
            sink.text("]");
            sink.lineBreak();
        }
        if (this.map.get(PmdReportBean.class) != null) {
            sink.text("[");
            sink.link("#pmd");
            sink.text(bundle.getString("report.pmd.header"));
            sink.link_();
            sink.text("]");
            sink.lineBreak();
        }
        if (this.map.get(CpdReportBean.class) != null) {
            sink.text("[");
            sink.link("#cpd");
            sink.text(bundle.getString("report.cpd.header"));
            sink.link_();
            sink.text("]");
            sink.lineBreak();
        }
        if (this.map.get(FindBugsReportBean.class) != null) {
            sink.text("[");
            sink.link("#findbugs");
            sink.text(bundle.getString("report.findbugs.header"));
            sink.link_();
            sink.text("]");
            sink.lineBreak();
        }
        if (this.map.get(JDependReportBean.class) != null) {
            sink.text("[");
            sink.link("#jdepend");
            sink.text(bundle.getString("report.xrefpackage.header"));
            sink.link_();
            sink.text("]");
            sink.lineBreak();
        }
        if (this.map.get(TagListReportBean.class) != null) {
            sink.text("[");
            sink.link("#taglist");
            sink.text(bundle.getString("report.taglist.header"));
            sink.link_();
            sink.text("]");
            sink.lineBreak();
        }
        sink.horizontalRule();
        sink.lineBreak();
        if (!this.generateGraphs) {
            sink.text("[" + bundle.getString("dashboard.report.generategraphs.disabled") + "]");
            sink.lineBreak();
        }
        sink.section1_();
    }

    public void createBodyReport(ResourceBundle bundle, Sink sink) {
        this.getLog().debug((CharSequence)"DashBoardMultiReportGenerator createBodyByReport(...)");
        if (this.map.get(CoberturaReportBean.class) != null) {
            this.createCoberturaSection(bundle, sink);
        }
        if (this.map.get(CloverReportBean.class) != null) {
            this.createCloverSection(bundle, sink);
        }
        if (this.map.get(SurefireReportBean.class) != null) {
            this.createSurefireSection(bundle, sink);
        }
        if (this.map.get(CheckstyleReportBean.class) != null) {
            this.createCheckStyleSection(bundle, sink);
        }
        if (this.map.get(PmdReportBean.class) != null) {
            this.createPmdSection(bundle, sink);
        }
        if (this.map.get(CpdReportBean.class) != null) {
            this.createCpdSection(bundle, sink);
        }
        if (this.map.get(FindBugsReportBean.class) != null) {
            this.createFindBugsSection(bundle, sink);
        }
        if (this.map.get(JDependReportBean.class) != null) {
            this.createJDependSection(bundle, sink);
        }
        if (this.map.get(TagListReportBean.class) != null) {
            this.createTaglistSection(bundle, sink);
        }
    }

    public void createSurefireSection(ResourceBundle bundle, Sink sink) {
        StackedBarChartRenderer chart;
        sink.section1();
        sink.sectionTitle2();
        sink.anchor("surefire");
        sink.text(bundle.getString("report.surefire.header"));
        sink.anchor_();
        sink.sectionTitle2_();
        this.linkToTopPage(sink);
        sink.lineBreak();
        if (this.isDBAvailable) {
            this.linkToHistoricPage(sink, "surefire");
        }
        sink.section1_();
        sink.table();
        sink.tableRow();
        this.sinkHeader(sink, bundle.getString("report.project.name.header"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.successrate"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.tests"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.errors"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.failures"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.skipped"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.time"));
        sink.tableRow_();
        Hashtable datas = new Hashtable();
        this.createSurefireLineByReport(bundle, sink, this.mavenProject, true, "", datas);
        SurefireReportBean fireReportBean = (SurefireReportBean)this.mavenProject.getReportsByType(SurefireReportBean.class);
        if (fireReportBean != null) {
            sink.tableRow();
            this.sinkHeader(sink, "Total");
            this.sinkHeaderCellPercentGraphic(sink, fireReportBean.getSucessRate() / 100.0, "surefire");
            this.sinkHeader(sink, Integer.toString(fireReportBean.getNbTests()));
            this.sinkHeader(sink, Integer.toString(fireReportBean.getNbErrors()));
            this.sinkHeader(sink, Integer.toString(fireReportBean.getNbFailures()));
            this.sinkHeader(sink, Integer.toString(fireReportBean.getNbSkipped()));
            this.sinkHeader(sink, Double.toString(fireReportBean.getElapsedTime()));
            sink.tableRow_();
        }
        sink.table_();
        sink.lineBreak();
        if (this.generateGraphs && !(chart = new StackedBarChartRenderer(new SurefireBarChartStrategy(bundle, this.mavenProject.getProjectName(), datas))).isEmpty()) {
            String filename = this.replaceForbiddenChar(this.mavenProject.getProjectName());
            filename = filename + "_Surefire." + chart.getFileExtension();
            filename = filename.replace(' ', '_');
            String filenamePath = this.getImagesPath() + "/" + filename;
            this.getLog().debug((CharSequence)("createSurefireGraph = " + filenamePath));
            try {
                chart.saveToFile(filenamePath);
                String link = "images/" + filename;
                link = link.replace(' ', '_');
                sink.figure();
                sink.figureGraphics(link);
                sink.figure_();
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)("createSurefireGraph exception = " + e.getMessage()));
            }
        }
    }

    public void createSurefireLineByReport(ResourceBundle bundle, Sink sink, DashBoardMavenProject mavenProject, boolean isRoot, String prefix, Map datas) {
        if (mavenProject.getModules() != null && !mavenProject.getModules().isEmpty()) {
            Iterator iter = mavenProject.getModules().iterator();
            if (!isRoot) {
                prefix = this.writeMultiProjectRow(sink, mavenProject, prefix, this.surefireAnchorLink);
            }
            while (iter.hasNext()) {
                DashBoardMavenProject subproject = (DashBoardMavenProject)iter.next();
                this.createSurefireLineByReport(bundle, sink, subproject, false, prefix, datas);
            }
        } else {
            SurefireReportBean fireReportBean = (SurefireReportBean)mavenProject.getReportsByType(SurefireReportBean.class);
            if (fireReportBean != null) {
                sink.tableRow();
                datas.put(mavenProject.getProjectName(), fireReportBean);
                this.writeProjectCell(sink, mavenProject, prefix, this.surefireAnchorLink);
                this.sinkCellPercentGraphic(sink, fireReportBean.getSucessRate() / 100.0, "surefire");
                this.sinkCell(sink, Integer.toString(fireReportBean.getNbTests()));
                this.sinkCell(sink, Integer.toString(fireReportBean.getNbErrors()));
                this.sinkCell(sink, Integer.toString(fireReportBean.getNbFailures()));
                this.sinkCell(sink, Integer.toString(fireReportBean.getNbSkipped()));
                this.sinkCell(sink, Double.toString(fireReportBean.getElapsedTime()));
                sink.tableRow_();
            }
        }
    }

    public void createCloverSection(ResourceBundle bundle, Sink sink) {
        BarChartRenderer chart;
        sink.section1();
        sink.sectionTitle2();
        sink.anchor("clover");
        sink.text(bundle.getString("report.clover.header"));
        sink.anchor_();
        sink.sectionTitle2_();
        this.linkToTopPage(sink);
        sink.lineBreak();
        if (this.isDBAvailable) {
            this.linkToHistoricPage(sink, "clover");
        }
        sink.section1_();
        sink.table();
        sink.tableRow();
        this.sinkHeader(sink, bundle.getString("report.project.name.header"));
        this.sinkHeader(sink, bundle.getString("report.clover.label.total"));
        this.sinkHeader(sink, bundle.getString("report.clover.label.conditionals"));
        this.sinkHeader(sink, bundle.getString("report.clover.label.statements"));
        this.sinkHeader(sink, bundle.getString("report.clover.label.methods"));
        sink.tableRow_();
        Hashtable datas = new Hashtable();
        this.createCloverLineByReport(bundle, sink, this.mavenProject, true, "", datas);
        CloverReportBean reportBean = (CloverReportBean)this.mavenProject.getReportsByType(CloverReportBean.class);
        if (reportBean != null) {
            sink.tableRow();
            this.sinkHeader(sink, "Total");
            if (this.generateGraphs) {
                this.sinkHeader(sink, reportBean.getElementsLabel());
                this.sinkHeader(sink, reportBean.getConditionalsLabel());
                this.sinkHeader(sink, reportBean.getStatementsLabel());
                this.sinkHeader(sink, reportBean.getMethodsLabel());
            } else {
                sink.tableHeaderCell();
                this.sinkPercentGraphic(sink, reportBean.getPercentCoveredConditionals());
                sink.text("(" + reportBean.getCoveredElements() + " / " + reportBean.getElements() + ")");
                sink.tableHeaderCell_();
                sink.tableHeaderCell();
                this.sinkPercentGraphic(sink, reportBean.getPercentCoveredConditionals());
                sink.text("(" + reportBean.getCoveredConditionals() + " / " + reportBean.getConditionals() + ")");
                sink.tableHeaderCell_();
                sink.tableHeaderCell();
                this.sinkPercentGraphic(sink, reportBean.getPercentCoveredStatements());
                sink.text("(" + reportBean.getCoveredStatements() + " / " + reportBean.getStatements() + ")");
                sink.tableHeaderCell_();
                sink.tableHeaderCell();
                this.sinkPercentGraphic(sink, reportBean.getPercentCoveredMethods());
                sink.text("(" + reportBean.getCoveredMethods() + " / " + reportBean.getMethods() + ")");
                sink.tableHeaderCell_();
            }
            sink.tableRow_();
        }
        sink.table_();
        sink.lineBreak();
        if (this.generateGraphs && !(chart = new BarChartRenderer(new MultiCloverBarChartStrategy(bundle, this.mavenProject.getProjectName(), datas))).isEmpty()) {
            String filename = this.replaceForbiddenChar(this.mavenProject.getProjectName());
            filename = filename + "_Clover." + chart.getFileExtension();
            filename = filename.replace(' ', '_');
            String filenamePath = this.getImagesPath() + "/" + filename;
            this.getLog().debug((CharSequence)("createCloverGraph = " + filenamePath));
            try {
                chart.saveToFile(filenamePath);
                String link = "images/" + filename;
                link = link.replace(' ', '_');
                sink.figure();
                sink.figureGraphics(link);
                sink.figure_();
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)("createCloverGraph exception = " + e.getMessage()));
            }
        }
    }

    public void createCloverLineByReport(ResourceBundle bundle, Sink sink, DashBoardMavenProject mavenProject, boolean isRoot, String prefix, Map datas) {
        if (mavenProject.getModules() != null && !mavenProject.getModules().isEmpty()) {
            Iterator iter = mavenProject.getModules().iterator();
            if (!isRoot) {
                prefix = this.writeMultiProjectRow(sink, mavenProject, prefix, this.cloverAnchorLink);
            }
            while (iter.hasNext()) {
                DashBoardMavenProject subproject = (DashBoardMavenProject)iter.next();
                this.createCloverLineByReport(bundle, sink, subproject, false, prefix, datas);
            }
        } else {
            CloverReportBean cloverReportBean = (CloverReportBean)mavenProject.getReportsByType(CloverReportBean.class);
            if (cloverReportBean != null) {
                sink.tableRow();
                datas.put(mavenProject.getProjectName(), cloverReportBean);
                this.writeProjectCell(sink, mavenProject, prefix, this.cloverAnchorLink);
                if (this.generateGraphs) {
                    this.sinkCell(sink, cloverReportBean.getElementsLabel());
                } else {
                    sink.tableCell();
                    this.sinkPercentGraphic(sink, cloverReportBean.getPercentCoveredConditionals());
                    sink.text("(" + cloverReportBean.getCoveredElements() + " / " + cloverReportBean.getElements() + ")");
                    sink.tableCell_();
                }
                this.sinkCell(sink, cloverReportBean.getConditionalsLabel());
                this.sinkCell(sink, cloverReportBean.getStatementsLabel());
                this.sinkCell(sink, cloverReportBean.getMethodsLabel());
                sink.tableRow_();
            }
        }
    }

    public void createCoberturaSection(ResourceBundle bundle, Sink sink) {
        BarChartRenderer chart;
        sink.section1();
        sink.sectionTitle2();
        sink.anchor("cobertura");
        sink.text(bundle.getString("report.cobertura.header"));
        sink.anchor_();
        sink.sectionTitle2_();
        this.linkToTopPage(sink);
        sink.lineBreak();
        if (this.isDBAvailable) {
            this.linkToHistoricPage(sink, "cobertura");
        }
        sink.section1_();
        sink.table();
        sink.tableRow();
        this.sinkHeader(sink, bundle.getString("report.project.name.header"));
        this.sinkHeader(sink, bundle.getString("report.cobertura.label.nbclasses"));
        this.sinkHeader(sink, bundle.getString("report.cobertura.label.linecover"));
        this.sinkHeader(sink, bundle.getString("report.cobertura.label.branchcover"));
        sink.tableRow_();
        Hashtable datas = new Hashtable();
        this.createCoberturaLineByReport(bundle, sink, this.mavenProject, true, "", datas);
        CoberturaReportBean reportBean = (CoberturaReportBean)this.mavenProject.getReportsByType(CoberturaReportBean.class);
        if (reportBean != null) {
            sink.tableRow();
            this.sinkHeader(sink, "Total");
            this.sinkHeader(sink, Integer.toString(reportBean.getNbClasses()));
            this.sinkHeaderCellPercentGraphic(sink, reportBean.getLineCoverRate(), "cobertura");
            this.sinkHeaderCellPercentGraphic(sink, reportBean.getBranchCoverRate(), "cobertura");
            sink.tableRow_();
        }
        sink.table_();
        sink.lineBreak();
        if (this.generateGraphs && !(chart = new BarChartRenderer(new CoberturaBarChartStrategy(bundle, this.mavenProject.getProjectName(), datas))).isEmpty()) {
            String filename = this.replaceForbiddenChar(this.mavenProject.getProjectName());
            filename = filename + "_Cobertura." + chart.getFileExtension();
            filename = filename.replace(' ', '_');
            String filenamePath = this.getImagesPath() + "/" + filename;
            this.getLog().debug((CharSequence)("createCoberturaGraph = " + filenamePath));
            try {
                chart.saveToFile(filenamePath);
                String link = "images/" + filename;
                link = link.replace(' ', '_');
                sink.figure();
                sink.figureGraphics(link);
                sink.figure_();
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)("createCoberturaGraph exception = " + e.getMessage()));
            }
        }
    }

    public void createCoberturaLineByReport(ResourceBundle bundle, Sink sink, DashBoardMavenProject mavenProject, boolean isRoot, String prefix, Map datas) {
        if (mavenProject.getModules() != null && !mavenProject.getModules().isEmpty()) {
            Iterator iter = mavenProject.getModules().iterator();
            if (!isRoot) {
                prefix = this.writeMultiProjectRow(sink, mavenProject, prefix, this.coberturaAnchorLink);
            }
            while (iter.hasNext()) {
                DashBoardMavenProject subproject = (DashBoardMavenProject)iter.next();
                this.createCoberturaLineByReport(bundle, sink, subproject, false, prefix, datas);
            }
        } else {
            CoberturaReportBean coberReportBean = (CoberturaReportBean)mavenProject.getReportsByType(CoberturaReportBean.class);
            if (coberReportBean != null) {
                sink.tableRow();
                datas.put(mavenProject.getProjectName(), coberReportBean);
                this.writeProjectCell(sink, mavenProject, prefix, this.coberturaAnchorLink);
                this.sinkCell(sink, Integer.toString(coberReportBean.getNbClasses()));
                if (this.generateGraphs) {
                    this.sinkCell(sink, DashBoardMultiReportGenerator.getPercentValue(coberReportBean.getLineCoverRate()));
                    this.sinkCell(sink, DashBoardMultiReportGenerator.getPercentValue(coberReportBean.getBranchCoverRate()));
                } else {
                    this.sinkCellPercentGraphic(sink, coberReportBean.getLineCoverRate(), "cobertura");
                    this.sinkCellPercentGraphic(sink, coberReportBean.getBranchCoverRate(), "cobertura");
                }
                sink.tableRow_();
            }
        }
    }

    public void createPmdSection(ResourceBundle bundle, Sink sink) {
        BarChartRenderer chart;
        sink.section1();
        sink.sectionTitle2();
        sink.anchor("pmd");
        sink.text(bundle.getString("report.pmd.header"));
        sink.anchor_();
        sink.sectionTitle2_();
        this.linkToTopPage(sink);
        sink.lineBreak();
        if (this.isDBAvailable) {
            this.linkToHistoricPage(sink, "pmd");
        }
        sink.section1_();
        sink.table();
        sink.tableRow();
        this.sinkHeader(sink, bundle.getString("report.project.name.header"));
        this.sinkHeader(sink, bundle.getString("report.pmd.label.nbclasses"));
        this.sinkHeader(sink, bundle.getString("report.pmd.label.nbviolations"));
        sink.tableRow_();
        Hashtable datas = new Hashtable();
        this.createPmdLineByReport(bundle, sink, this.mavenProject, true, "", datas);
        PmdReportBean reportBean = (PmdReportBean)this.mavenProject.getReportsByType(PmdReportBean.class);
        if (reportBean != null) {
            sink.tableRow();
            this.sinkHeader(sink, "Total");
            this.sinkHeader(sink, Integer.toString(reportBean.getNbClasses()));
            this.sinkHeader(sink, Integer.toString(reportBean.getNbViolations()));
            sink.tableRow_();
        }
        sink.table_();
        sink.lineBreak();
        if (this.generateGraphs && !(chart = new BarChartRenderer(new PmdBarChartStrategy(bundle, this.mavenProject.getProjectName(), datas))).isEmpty()) {
            String filename = this.replaceForbiddenChar(this.mavenProject.getProjectName());
            filename = filename + "_Pmd." + chart.getFileExtension();
            filename = filename.replace(' ', '_');
            String filenamePath = this.getImagesPath() + "/" + filename;
            this.getLog().debug((CharSequence)("createPmdGraph = " + filenamePath));
            try {
                chart.saveToFile(filenamePath);
                String link = "images/" + filename;
                link = link.replace(' ', '_');
                sink.figure();
                sink.figureGraphics(link);
                sink.figure_();
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)("createPmdGraph exception = " + e.getMessage()));
            }
        }
    }

    public void createPmdLineByReport(ResourceBundle bundle, Sink sink, DashBoardMavenProject mavenProject, boolean isRoot, String prefix, Map datas) {
        if (mavenProject.getModules() != null && !mavenProject.getModules().isEmpty()) {
            Iterator iter = mavenProject.getModules().iterator();
            if (!isRoot) {
                prefix = this.writeMultiProjectRow(sink, mavenProject, prefix, this.pmdAnchorLink);
            }
            while (iter.hasNext()) {
                DashBoardMavenProject subproject = (DashBoardMavenProject)iter.next();
                this.createPmdLineByReport(bundle, sink, subproject, false, prefix, datas);
            }
        } else {
            PmdReportBean pmdReportBean = (PmdReportBean)mavenProject.getReportsByType(PmdReportBean.class);
            if (pmdReportBean != null) {
                sink.tableRow();
                datas.put(mavenProject.getProjectName(), pmdReportBean);
                this.writeProjectCell(sink, mavenProject, prefix, this.pmdAnchorLink);
                this.sinkCell(sink, Integer.toString(pmdReportBean.getNbClasses()));
                this.sinkCell(sink, Integer.toString(pmdReportBean.getNbViolations()));
                sink.tableRow_();
            }
        }
    }

    public void createCpdSection(ResourceBundle bundle, Sink sink) {
        BarChartRenderer chart;
        sink.section1();
        sink.sectionTitle2();
        sink.anchor("cpd");
        sink.text(bundle.getString("report.cpd.header"));
        sink.anchor_();
        sink.sectionTitle2_();
        this.linkToTopPage(sink);
        sink.lineBreak();
        if (this.isDBAvailable) {
            this.linkToHistoricPage(sink, "cpd");
        }
        sink.section1_();
        sink.table();
        sink.tableRow();
        this.sinkHeader(sink, bundle.getString("report.project.name.header"));
        this.sinkHeader(sink, bundle.getString("report.cpd.label.nbclasses"));
        this.sinkHeader(sink, bundle.getString("report.cpd.label.nbduplicate"));
        sink.tableRow_();
        Hashtable datas = new Hashtable();
        this.createCpdLineByReport(bundle, sink, this.mavenProject, true, "", datas);
        CpdReportBean reportBean = (CpdReportBean)this.mavenProject.getReportsByType(CpdReportBean.class);
        if (reportBean != null) {
            sink.tableRow();
            this.sinkHeader(sink, "Total");
            this.sinkHeader(sink, Integer.toString(reportBean.getNbClasses()));
            this.sinkHeader(sink, Integer.toString(reportBean.getNbDuplicate()));
            sink.tableRow_();
        }
        sink.table_();
        sink.lineBreak();
        if (this.generateGraphs && !(chart = new BarChartRenderer(new CpdBarChartStrategy(bundle, this.mavenProject.getProjectName(), datas))).isEmpty()) {
            String filename = this.replaceForbiddenChar(this.mavenProject.getProjectName());
            filename = filename + "_Cpd." + chart.getFileExtension();
            filename = filename.replace(' ', '_');
            String filenamePath = this.getImagesPath() + "/" + filename;
            this.getLog().debug((CharSequence)("createCpdGraph = " + filenamePath));
            try {
                chart.saveToFile(filenamePath);
                String link = "images/" + filename;
                link = link.replace(' ', '_');
                sink.figure();
                sink.figureGraphics(link);
                sink.figure_();
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)("createCpdGraph exception = " + e.getMessage()));
            }
        }
    }

    public void createCpdLineByReport(ResourceBundle bundle, Sink sink, DashBoardMavenProject mavenProject, boolean isRoot, String prefix, Map datas) {
        if (mavenProject.getModules() != null && !mavenProject.getModules().isEmpty()) {
            Iterator iter = mavenProject.getModules().iterator();
            if (!isRoot) {
                prefix = this.writeMultiProjectRow(sink, mavenProject, prefix, this.cpdAnchorLink);
            }
            while (iter.hasNext()) {
                DashBoardMavenProject subproject = (DashBoardMavenProject)iter.next();
                this.createCpdLineByReport(bundle, sink, subproject, false, prefix, datas);
            }
        } else {
            CpdReportBean cpdReportBean = (CpdReportBean)mavenProject.getReportsByType(CpdReportBean.class);
            if (cpdReportBean != null) {
                sink.tableRow();
                datas.put(mavenProject.getProjectName(), cpdReportBean);
                this.writeProjectCell(sink, mavenProject, prefix, this.cpdAnchorLink);
                this.sinkCell(sink, Integer.toString(cpdReportBean.getNbClasses()));
                this.sinkCell(sink, Integer.toString(cpdReportBean.getNbDuplicate()));
                sink.tableRow_();
            }
        }
    }

    public void createFindBugsSection(ResourceBundle bundle, Sink sink) {
        BarChartRenderer chart;
        sink.section1();
        sink.sectionTitle2();
        sink.anchor("findbugs");
        sink.text(bundle.getString("report.findbugs.header"));
        sink.anchor_();
        sink.sectionTitle2_();
        this.linkToTopPage(sink);
        sink.lineBreak();
        if (this.isDBAvailable) {
            this.linkToHistoricPage(sink, "findbugs");
        }
        sink.section1_();
        sink.table();
        sink.tableRow();
        this.sinkHeader(sink, bundle.getString("report.project.name.header"));
        this.sinkHeader(sink, bundle.getString("report.findbugs.label.nbclasses"));
        this.sinkHeader(sink, bundle.getString("report.findbugs.label.nbbugs"));
        this.sinkHeader(sink, bundle.getString("report.findbugs.label.nberrors"));
        this.sinkHeader(sink, bundle.getString("report.findbugs.label.nbMissingClasses"));
        sink.tableRow_();
        Hashtable datas = new Hashtable();
        this.createFindBugsLineByReport(bundle, sink, this.mavenProject, true, "", datas);
        FindBugsReportBean reportBean = (FindBugsReportBean)this.mavenProject.getReportsByType(FindBugsReportBean.class);
        if (reportBean != null) {
            sink.tableRow();
            this.sinkHeader(sink, "Total");
            this.sinkHeader(sink, Integer.toString(reportBean.getNbClasses()));
            this.sinkHeader(sink, Integer.toString(reportBean.getNbBugs()));
            this.sinkHeader(sink, Integer.toString(reportBean.getNbErrors()));
            this.sinkHeader(sink, Integer.toString(reportBean.getNbMissingClasses()));
            sink.tableRow_();
        }
        sink.table_();
        sink.lineBreak();
        if (this.generateGraphs && !(chart = new BarChartRenderer(new FindBugsBarChartStrategy(bundle, this.mavenProject.getProjectName(), datas))).isEmpty()) {
            String filename = this.replaceForbiddenChar(this.mavenProject.getProjectName());
            filename = filename + "_FindBugs." + chart.getFileExtension();
            filename = filename.replace(' ', '_');
            String filenamePath = this.getImagesPath() + "/" + filename;
            this.getLog().debug((CharSequence)("createFindBugsGraph = " + filenamePath));
            try {
                chart.saveToFile(filenamePath);
                String link = "images/" + filename;
                link = link.replace(' ', '_');
                sink.figure();
                sink.figureGraphics(link);
                sink.figure_();
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)("createFindBugsGraph exception = " + e.getMessage()));
            }
        }
    }

    public void createFindBugsLineByReport(ResourceBundle bundle, Sink sink, DashBoardMavenProject mavenProject, boolean isRoot, String prefix, Map datas) {
        if (mavenProject.getModules() != null && !mavenProject.getModules().isEmpty()) {
            Iterator iter = mavenProject.getModules().iterator();
            if (!isRoot) {
                prefix = this.writeMultiProjectRow(sink, mavenProject, prefix, this.findbugsAnchorLink);
            }
            while (iter.hasNext()) {
                DashBoardMavenProject subproject = (DashBoardMavenProject)iter.next();
                this.createFindBugsLineByReport(bundle, sink, subproject, false, prefix, datas);
            }
        } else {
            FindBugsReportBean findBugsReportBean = (FindBugsReportBean)mavenProject.getReportsByType(FindBugsReportBean.class);
            if (findBugsReportBean != null) {
                sink.tableRow();
                datas.put(mavenProject.getProjectName(), findBugsReportBean);
                this.writeProjectCell(sink, mavenProject, prefix, this.findbugsAnchorLink);
                this.sinkCell(sink, Integer.toString(findBugsReportBean.getNbClasses()));
                this.sinkCell(sink, Integer.toString(findBugsReportBean.getNbBugs()));
                this.sinkCell(sink, Integer.toString(findBugsReportBean.getNbErrors()));
                this.sinkCell(sink, Integer.toString(findBugsReportBean.getNbMissingClasses()));
                sink.tableRow_();
            }
        }
    }

    public void createCheckStyleSection(ResourceBundle bundle, Sink sink) {
        StackedBarChartRenderer chart;
        sink.section1();
        sink.sectionTitle2();
        sink.anchor("checkstyle");
        sink.text(bundle.getString("report.checkstyle.header"));
        sink.anchor_();
        sink.sectionTitle2_();
        this.linkToTopPage(sink);
        sink.lineBreak();
        if (this.isDBAvailable) {
            this.linkToHistoricPage(sink, "checkstyle");
        }
        sink.section1_();
        sink.table();
        sink.tableRow();
        this.sinkHeader(sink, bundle.getString("report.project.name.header"));
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.checkstyle.files"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.checkstyle.column.total"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.checkstyle.column.infos"));
        sink.nonBreakingSpace();
        this.iconInfo(sink);
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.checkstyle.column.warnings"));
        sink.nonBreakingSpace();
        this.iconWarning(sink);
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.checkstyle.column.errors"));
        sink.nonBreakingSpace();
        this.iconError(sink);
        sink.tableHeaderCell_();
        sink.tableRow_();
        Hashtable datas = new Hashtable();
        CheckstyleReportBean reportBean = (CheckstyleReportBean)this.mavenProject.getReportsByType(CheckstyleReportBean.class);
        this.createCheckStyleLineByReport(bundle, sink, this.mavenProject, true, "", datas, reportBean.getNbTotal());
        if (reportBean != null) {
            sink.tableRow();
            this.sinkHeader(sink, "Total");
            this.sinkHeader(sink, Integer.toString(reportBean.getNbClasses()));
            this.sinkHeader(sink, Integer.toString(reportBean.getNbTotal()));
            sink.tableHeaderCell();
            sink.text(Integer.toString(reportBean.getNbInfos()));
            this.sinkInvertPercentGraphic(sink, reportBean.getPercentInfos());
            sink.tableHeaderCell_();
            sink.tableHeaderCell();
            sink.text(Integer.toString(reportBean.getNbWarnings()));
            this.sinkInvertPercentGraphic(sink, reportBean.getPercentWarnings());
            sink.tableHeaderCell_();
            sink.tableHeaderCell();
            sink.text(Integer.toString(reportBean.getNbErrors()));
            this.sinkInvertPercentGraphic(sink, reportBean.getPercentErrors());
            sink.tableHeaderCell_();
            sink.tableRow_();
        }
        sink.table_();
        sink.lineBreak();
        if (this.generateGraphs && !(chart = new StackedBarChartRenderer(new CheckstyleBarChartStrategy(bundle, this.mavenProject.getProjectName(), datas))).isEmpty()) {
            String filename = this.replaceForbiddenChar(this.mavenProject.getProjectName());
            filename = filename + "_CheckStyle." + chart.getFileExtension();
            filename = filename.replace(' ', '_');
            String filenamePath = this.getImagesPath() + "/" + filename;
            this.getLog().debug((CharSequence)("createCheckStyleGraph = " + filenamePath));
            try {
                chart.saveToFile(filenamePath);
                String link = "images/" + filename;
                link = link.replace(' ', '_');
                sink.figure();
                sink.figureGraphics(link);
                sink.figure_();
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)("createCheckStyleGraph exception = " + e.getMessage()));
            }
        }
    }

    public void createCheckStyleLineByReport(ResourceBundle bundle, Sink sink, DashBoardMavenProject mavenProject, boolean isRoot, String prefix, Map datas, int total) {
        if (mavenProject.getModules() != null && !mavenProject.getModules().isEmpty()) {
            Iterator iter = mavenProject.getModules().iterator();
            if (!isRoot) {
                prefix = this.writeMultiProjectRow(sink, mavenProject, prefix, this.checkstyleAnchorLink);
            }
            while (iter.hasNext()) {
                DashBoardMavenProject subproject = (DashBoardMavenProject)iter.next();
                this.createCheckStyleLineByReport(bundle, sink, subproject, false, prefix, datas, total);
            }
        } else {
            CheckstyleReportBean checkStyleReport = (CheckstyleReportBean)mavenProject.getReportsByType(CheckstyleReportBean.class);
            if (checkStyleReport != null) {
                sink.tableRow();
                datas.put(mavenProject.getProjectName(), checkStyleReport);
                this.writeProjectCell(sink, mavenProject, prefix, this.checkstyleAnchorLink);
                this.sinkCell(sink, Integer.toString(checkStyleReport.getNbClasses()));
                if (this.generateGraphs) {
                    this.sinkCell(sink, Integer.toString(checkStyleReport.getNbTotal()));
                } else {
                    sink.tableCell();
                    sink.text(Integer.toString(checkStyleReport.getNbTotal()));
                    this.sinkInvertPercentGraphic(sink, (double)checkStyleReport.getNbTotal() / (double)total);
                    sink.tableCell_();
                }
                this.sinkCell(sink, Integer.toString(checkStyleReport.getNbInfos()));
                this.sinkCell(sink, Integer.toString(checkStyleReport.getNbWarnings()));
                this.sinkCell(sink, Integer.toString(checkStyleReport.getNbErrors()));
                sink.tableRow_();
            }
        }
    }

    public void createJDependSection(ResourceBundle bundle, Sink sink) {
        sink.section1();
        sink.sectionTitle2();
        sink.anchor("jdepend");
        sink.text(bundle.getString("report.xrefpackage.header"));
        sink.anchor_();
        sink.sectionTitle2_();
        this.linkToTopPage(sink);
        sink.section1_();
        JDependReportBean report = (JDependReportBean)this.mavenProject.getReportsByType(JDependReportBean.class);
        if (report == null) {
            sink.text("Error: Unable to read from Jdepend data file .");
        } else {
            double averageAC = report.getAverageAfferentCoupling();
            double calcul = Math.rint(averageAC * 1000.0) / 1000.0;
            sink.sectionTitle3();
            sink.text(bundle.getString("report.xrefpackage.label.average") + " = " + calcul);
            sink.lineBreak();
            sink.text(" Nb Packages = " + report.getNbPackages());
            sink.sectionTitle3_();
            sink.table();
            sink.tableRow();
            this.sinkHeader(sink, bundle.getString("report.xrefpackage.label.package"));
            this.sinkHeader(sink, bundle.getString("report.xrefpackage.label.ac"));
            this.sinkHeader(sink, bundle.getString("report.xrefpackage.label.linecover"));
            this.sinkHeader(sink, bundle.getString("report.xrefpackage.label.branchcover"));
            sink.tableRow_();
            List pack = report.getPackages();
            Iterator iter = pack.iterator();
            boolean threshold = false;
            while (iter.hasNext()) {
                XRefPackageBean bean = (XRefPackageBean)iter.next();
                Integer ac = bean.getAfferentCoupling();
                if (ac.doubleValue() <= averageAC && !threshold) {
                    threshold = true;
                    sink.tableRow();
                    this.sinkCellBold(sink, bundle.getString("report.xrefpackage.label.threshold"));
                    this.sinkCellBold(sink, String.valueOf(calcul));
                    sink.tableRow_();
                }
                sink.tableRow();
                this.sinkCell(sink, bean.getPackageName());
                this.sinkCell(sink, ac.toString());
                this.sinkCellPercentGraphic(sink, bean.getLineCoverRate(), "cobertura");
                this.sinkCellPercentGraphic(sink, bean.getBranchCoverRate(), "cobertura");
                sink.tableRow_();
            }
            sink.table_();
        }
        sink.lineBreak();
    }

    private void writeProjectCell(Sink sink, DashBoardMavenProject mavenProject, String prefix, String suffix) {
        if (prefix == null || prefix.length() == 0) {
            String artefactId;
            String link = artefactId = mavenProject.getArtifactId();
            this.sinkCellWithLink(sink, mavenProject.getProjectName(), link + suffix);
        } else {
            int nbTab = prefix.split("/").length;
            String artefactId = mavenProject.getArtifactId();
            String link = prefix + "/" + artefactId;
            this.sinkCellTabWithLink(sink, mavenProject.getProjectName(), nbTab, link + suffix);
        }
    }

    private String writeMultiProjectRow(Sink sink, DashBoardMavenProject mavenProject, String prefix, String suffix) {
        if (prefix == null || prefix.length() == 0) {
            String artefactId;
            prefix = artefactId = mavenProject.getArtifactId();
            sink.tableRow();
            this.sinkCellBoldWithLink(sink, mavenProject.getProjectName(), prefix + suffix);
            sink.tableRow_();
        } else {
            sink.tableRow();
            int nbTab = prefix.split("/").length;
            String artefactId = mavenProject.getArtifactId();
            prefix = prefix + "/" + artefactId;
            this.sinkCellTabBoldWithLink(sink, mavenProject.getProjectName(), nbTab, prefix + suffix);
            sink.tableRow_();
        }
        return prefix;
    }

    public void createTaglistSection(ResourceBundle bundle, Sink sink) {
        StackedBarChartRenderer chart;
        sink.section1();
        sink.sectionTitle2();
        sink.anchor("taglist");
        sink.text(bundle.getString("report.taglist.header"));
        sink.anchor_();
        sink.sectionTitle2_();
        this.linkToTopPage(sink);
        sink.lineBreak();
        if (this.isDBAvailable) {
            this.linkToHistoricPage(sink, "taglist");
        }
        sink.section1_();
        sink.table();
        sink.tableRow();
        this.sinkHeader(sink, bundle.getString("report.project.name.header"));
        this.sinkHeader(sink, bundle.getString("report.taglist.label.nbclasses"));
        this.sinkHeader(sink, "Total");
        TagListReportBean reportBean = (TagListReportBean)this.mavenProject.getReportsByType(TagListReportBean.class);
        String[] keys = new String[reportBean.getTags().size()];
        int i = 0;
        Iterator ite = reportBean.getTags().entrySet().iterator();
        while (ite.hasNext()) {
            Map.Entry entry = ite.next();
            sink.tableHeaderCell();
            sink.text((String)entry.getKey());
            keys[i] = (String)entry.getKey();
            ++i;
            sink.tableHeaderCell_();
        }
        sink.tableRow_();
        Hashtable datas = new Hashtable();
        this.createTaglistLineByReport(bundle, sink, this.mavenProject, true, "", datas, keys, reportBean.getNbTotal());
        if (reportBean != null) {
            sink.tableRow();
            this.sinkHeader(sink, "Total");
            this.sinkHeader(sink, Integer.toString(reportBean.getNbClasses()));
            this.sinkHeader(sink, Integer.toString(reportBean.getNbTotal()));
            Iterator ite2 = reportBean.getTags().entrySet().iterator();
            while (ite2.hasNext()) {
                Map.Entry entry = ite2.next();
                this.sinkHeader(sink, entry.getValue().toString());
            }
            sink.tableRow_();
        }
        sink.table_();
        sink.lineBreak();
        if (this.generateGraphs && !(chart = new StackedBarChartRenderer(new TaglistBarChartStrategy(bundle, this.mavenProject.getProjectName(), datas))).isEmpty()) {
            String filename = this.replaceForbiddenChar(this.mavenProject.getProjectName());
            filename = filename + "_Taglist." + chart.getFileExtension();
            filename = filename.replace(' ', '_');
            String filenamePath = this.getImagesPath() + "/" + filename;
            this.getLog().debug((CharSequence)("createTaglistStyleGraph = " + filenamePath));
            try {
                chart.saveToFile(filenamePath);
                String link = "images/" + filename;
                link = link.replace(' ', '_');
                sink.figure();
                sink.figureGraphics(link);
                sink.figure_();
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)("createTaglistStyleGraph exception = " + e.getMessage()));
            }
        }
    }

    public void createTaglistLineByReport(ResourceBundle bundle, Sink sink, DashBoardMavenProject mavenProject, boolean isRoot, String prefix, Map datas, String[] keys, int total) {
        if (mavenProject.getModules() != null && !mavenProject.getModules().isEmpty()) {
            Iterator iter = mavenProject.getModules().iterator();
            if (!isRoot) {
                prefix = this.writeMultiProjectRow(sink, mavenProject, prefix, this.taglistAnchorLink);
            }
            while (iter.hasNext()) {
                DashBoardMavenProject subproject = (DashBoardMavenProject)iter.next();
                this.createTaglistLineByReport(bundle, sink, subproject, false, prefix, datas, keys, total);
            }
        } else {
            TagListReportBean taglistReport = (TagListReportBean)mavenProject.getReportsByType(TagListReportBean.class);
            if (taglistReport != null) {
                sink.tableRow();
                datas.put(mavenProject.getProjectName(), taglistReport);
                this.writeProjectCell(sink, mavenProject, prefix, this.taglistAnchorLink);
                this.sinkCell(sink, Integer.toString(taglistReport.getNbClasses()));
                if (this.generateGraphs) {
                    this.sinkCell(sink, Integer.toString(taglistReport.getNbTotal()));
                } else {
                    this.sinkCellInvertPercentGraphic(sink, (double)taglistReport.getNbTotal() / (double)total, "taglist", Integer.toString(taglistReport.getNbTotal()));
                }
                for (int i = 0; i < keys.length; ++i) {
                    this.sinkCell(sink, taglistReport.getTags().get(keys[i]).toString());
                }
                sink.tableRow_();
            }
        }
    }
}

