/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.commons.attributes;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.attributes.compiler.AttributeCompiler;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

public abstract class AbstractCommonsAttributeMojo
extends AbstractMojo {
    private static final String PATH_SEPARATOR = ", ";
    protected MavenProject project;
    protected String projectBuildDirectory;

    public void execute(String sourcePath, File outputDirectory, Set includes, Set excludes) throws MojoExecutionException {
        File sourceDirectory = new File(sourcePath);
        if (!this.shouldExecute(sourceDirectory)) {
            return;
        }
        outputDirectory.mkdirs();
        Project antProject = new Project();
        AttributeCompiler compiler = new AttributeCompiler();
        compiler.setProject(antProject);
        compiler.setDestdir(outputDirectory);
        FileSet fs = new FileSet();
        fs.setIncludes(includes.isEmpty() ? "**/*.java" : this.setToFileSet(includes));
        if (!excludes.isEmpty()) {
            fs.setExcludes(this.setToFileSet(excludes));
        }
        fs.setDir(sourceDirectory);
        compiler.addFileset(fs);
        compiler.execute();
    }

    private boolean shouldExecute(File sourceDirectory) {
        ArtifactHandler artifactHandler = this.project.getArtifact().getArtifactHandler();
        String error = null;
        if (!"java".equals(artifactHandler.getLanguage())) {
            error = "Not executing commons-attributes compiler as this is not a Java project.";
        } else if (!sourceDirectory.exists()) {
            error = "No sources found - No commons-attributes compilation done";
        }
        if (error != null && this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)error);
        }
        return error == null;
    }

    private String setToFileSet(Set paths) {
        if (paths.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            sb.append(path);
            if (!it.hasNext()) continue;
            sb.append(PATH_SEPARATOR);
        }
        return sb.toString();
    }
}

