/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sf.clirr.core.Severity;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.module.xhtml.decoration.render.RenderingContext;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.site.decoration.Body;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.Skin;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.clirr.AbstractClirrMojo;
import org.codehaus.mojo.clirr.ClirrDiffListener;
import org.codehaus.mojo.clirr.ClirrReportGenerator;
import org.codehaus.mojo.clirr.MissingPreviousException;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;

public class ClirrReport
extends AbstractClirrMojo
implements MavenReport {
    private File outputDirectory;
    private Renderer siteRenderer;
    private boolean showSummary;
    private boolean htmlReport;
    private boolean linkXRef;
    private File xrefLocation;

    public String getCategoryName() {
        return "Project Reports";
    }

    public void setReportOutputDirectory(File file) {
        this.outputDirectory = file;
    }

    public File getReportOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isExternalReport() {
        return false;
    }

    private File getSkinArtifactFile() throws MojoFailureException, MojoExecutionException {
        Artifact artifact;
        Skin skin = Skin.getDefaultSkin();
        String version = skin.getVersion();
        try {
            if (version == null) {
                version = "RELEASE";
            }
            VersionRange versionSpec = VersionRange.createFromVersionSpec((String)version);
            artifact = this.factory.createDependencyArtifact(skin.getGroupId(), skin.getArtifactId(), versionSpec, "jar", null, null);
            this.resolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoFailureException("The skin version '" + version + "' is not valid: " + e.getMessage());
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to find skin", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoFailureException("The skin does not exist: " + e.getMessage());
        }
        return artifact.getFile();
    }

    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        if (!this.canGenerateReport()) {
            return;
        }
        try {
            DecorationModel model = new DecorationModel();
            model.setBody(new Body());
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("outputEncoding", "UTF-8");
            Locale locale = Locale.getDefault();
            SiteRenderingContext siteContext = this.siteRenderer.createContextForSkin(this.getSkinArtifactFile(), attributes, model, this.getName(locale), locale);
            RenderingContext context = new RenderingContext(this.outputDirectory, this.getOutputName() + ".html");
            SiteRendererSink sink = new SiteRendererSink(context);
            this.generate((org.codehaus.doxia.sink.Sink)sink, locale);
            this.outputDirectory.mkdirs();
            FileWriter writer = new FileWriter(new File(this.outputDirectory, this.getOutputName() + ".html"));
            this.siteRenderer.generateDocument((Writer)writer, sink, siteContext);
            this.siteRenderer.copyResources(siteContext, new File(this.project.getBasedir(), "src/site/resources"), this.outputDirectory);
        }
        catch (RendererException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)e);
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e));
        }
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        if (!this.canGenerateReport()) {
            this.getLog().info((CharSequence)"Not generating report as there are no sources to compare");
        } else {
            this.doReport(sink, locale);
        }
    }

    private void doReport(Sink sink, Locale locale) throws MavenReportException {
        Severity minSeverity = ClirrReport.convertSeverity(this.minSeverity);
        ResourceBundle bundle = this.getBundle(locale);
        if (minSeverity == null) {
            this.getLog().warn((CharSequence)(bundle.getString("report.clirr.error.invalid.minseverity") + ": '" + this.minSeverity + "'."));
        }
        if (!this.htmlReport && this.xmlOutputFile == null && this.textOutputFile == null && !this.logResults) {
            this.getLog().error((CharSequence)bundle.getString("report.clirr.error.noreports"));
        } else {
            ClirrDiffListener listener;
            try {
                listener = this.executeClirr(minSeverity);
            }
            catch (MissingPreviousException e) {
                this.getLog().error((CharSequence)bundle.getString("report.clirr.error.nopredecessor"));
                return;
            }
            catch (MojoExecutionException e) {
                throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
            }
            catch (MojoFailureException e) {
                throw new MavenReportException(e.getMessage());
            }
            if (this.htmlReport) {
                ClirrReportGenerator generator = new ClirrReportGenerator(sink, bundle, locale);
                generator.setEnableSeveritySummary(this.showSummary);
                generator.setMinSeverity(minSeverity);
                generator.setCurrentVersion(this.project.getVersion());
                if (this.comparisonVersion != null) {
                    generator.setComparisonVersion(this.comparisonVersion);
                }
                if (this.linkXRef) {
                    String relativePath = PathTool.getRelativePath((String)this.outputDirectory.getAbsolutePath(), (String)this.xrefLocation.getAbsolutePath());
                    if (StringUtils.isEmpty((String)relativePath)) {
                        relativePath = ".";
                    }
                    relativePath = relativePath + "/" + this.xrefLocation.getName();
                    if (this.xrefLocation.exists()) {
                        generator.setXrefLocation(relativePath);
                    } else {
                        Iterator reports = this.project.getReportPlugins().iterator();
                        while (reports.hasNext()) {
                            ReportPlugin report = (ReportPlugin)reports.next();
                            String artifactId = report.getArtifactId();
                            if (!"maven-jxr-plugin".equals(artifactId) && !"jxr-maven-plugin".equals(artifactId)) continue;
                            generator.setXrefLocation(relativePath);
                        }
                    }
                    if (generator.getXrefLocation() == null) {
                        this.getLog().warn((CharSequence)"Unable to locate Source XRef to link to - DISABLED");
                    }
                }
                generator.generateReport(listener);
            }
        }
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.clirr.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.clirr.name");
    }

    public String getOutputName() {
        return "clirr-report";
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("clirr-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public boolean canGenerateReport() {
        try {
            return this.canGenerate();
        }
        catch (MojoFailureException e) {
            this.getLog().error((CharSequence)("Can't generate Clirr report: " + e.getMessage()));
            return false;
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)("Can't generate Clirr report: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public void generate(org.codehaus.doxia.sink.Sink sink, Locale locale) throws MavenReportException {
        this.generate((Sink)sink, locale);
    }
}

