/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report.history;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:chronos-report-maven-plugin:1.1.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "Chronos Report", 0);
        this.append(sb, "Plugin for analyzing the result of performance tests and create nice reports of the results", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "chronos-report:help", 0);
            this.append(sb, "Display help information on chronos-report-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0chronos-report:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "historyreport".equals(this.goal)) {
            this.append(sb, "chronos-report:historyreport", 0);
            this.append(sb, "Creates a historic report of performance test results.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "dataid (Default: performancetest)", 2);
                this.append(sb, "The id of the data, to create a report from. Used to separate between several performancetest inside the same maven project", 3);
                this.append(sb, "", 0);
                this.append(sb, "description", 2);
                this.append(sb, "The description of the generated report.", 3);
                this.append(sb, "", 0);
                this.append(sb, "historychartupperbound (Default: 0)", 2);
                this.append(sb, "This sets the default maximum value on the history report charts. This can be set to prevent 'spikes' in the charts which can throw the scale off.", 3);
                this.append(sb, "", 0);
                this.append(sb, "historydir", 2);
                this.append(sb, "The directory where historic data are stored.", 3);
                this.append(sb, "Expression: ${basedir}/target/chronos-history", 3);
                this.append(sb, "", 0);
                this.append(sb, "showgc (Default: true)", 2);
                this.append(sb, "Should the report contain garbage collections? Note that garbage collections are only relevant if they are from the code being tested (if you use JMeter to test wbsites, the jmeter gc logs are totally irrelevant)!", 3);
                this.append(sb, "", 0);
                this.append(sb, "title", 2);
                this.append(sb, "The title of the generated report", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "report".equals(this.goal)) {
            this.append(sb, "chronos-report:report", 0);
            this.append(sb, "Creates a report of the currently executed performancetest in html format.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "averageduration (Default: 20000)", 2);
                this.append(sb, "The timeinterval (in millis) to base moving average calculations on.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dataid (Default: performancetest)", 2);
                this.append(sb, "The id of the data, to create a report from.", 3);
                this.append(sb, "", 0);
                this.append(sb, "description", 2);
                this.append(sb, "The description of the generated report.", 3);
                this.append(sb, "", 0);
                this.append(sb, "metadata (Default: null)", 2);
                this.append(sb, "Points to a simple text file containing meta data about the build.\nThe information will be added to the reports under Additional build info.\nThe file is read line for line and added the report.\nThe readed expects the tab character to seperate keys and values:\nBuild\u00a0no.<tab>567\nSvn\u00a0tag<tab>Test\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "Location (directory) where generated html will be created.", 3);
                this.append(sb, "Expression: ${project.build.directory}/site ", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportid", 2);
                this.append(sb, "The id of the report and the name of the generated html-file. If no id is defined, the dataid is used", 3);
                this.append(sb, "", 0);
                this.append(sb, "showaverage (Default: true)", 2);
                this.append(sb, "Will graphs of responsetimes and histogram show the average?", 3);
                this.append(sb, "", 0);
                this.append(sb, "showdetails (Default: true)", 2);
                this.append(sb, "Should details of each individual test be shown?", 3);
                this.append(sb, "", 0);
                this.append(sb, "showgc (Default: true)", 2);
                this.append(sb, "Will garbage collections be shown?", 3);
                this.append(sb, "", 0);
                this.append(sb, "showhistogram (Default: true)", 2);
                this.append(sb, "Should a histogram be shown?", 3);
                this.append(sb, "", 0);
                this.append(sb, "showpercentile95 (Default: true)", 2);
                this.append(sb, "Will graphs of responsetimes and histogram show 95 percentiles?", 3);
                this.append(sb, "", 0);
                this.append(sb, "showpercentile99 (Default: false)", 2);
                this.append(sb, "Will graphs of responsetimes and histogram show 95 percentiles?", 3);
                this.append(sb, "", 0);
                this.append(sb, "showsummary (Default: true)", 2);
                this.append(sb, "Should a summary of the tests taken together be shown?", 3);
                this.append(sb, "", 0);
                this.append(sb, "showthroughput (Default: true)", 2);
                this.append(sb, "Should a graph of throughput be shown?", 3);
                this.append(sb, "", 0);
                this.append(sb, "title", 2);
                this.append(sb, "The title of the generated report.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

