/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report.chart;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.codehaus.mojo.chronos.report.ReportConfig;
import org.codehaus.mojo.chronos.report.chart.ChartRenderer;
import org.codehaus.mojo.chronos.report.chart.ChartSource;
import org.codehaus.mojo.chronos.report.chart.ChronosReportPlugin;
import org.jfree.chart.JFreeChart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GraphGenerator {
    private List<ChartSource> summaryChartSources = new ArrayList<ChartSource>();
    private Map detailsChartSources = new LinkedHashMap();

    public GraphGenerator(List plugins) {
        for (ChronosReportPlugin plugin : plugins) {
            ChartSource summarySource = plugin.getSummaryChartSource();
            if (summarySource != null) {
                this.summaryChartSources.add(summarySource);
            }
            Map detailsSources = plugin.getDetailChartSources();
            for (String testName : detailsSources.keySet()) {
                ArrayList existing = (ArrayList)this.detailsChartSources.get(testName);
                if (existing == null) {
                    existing = new ArrayList();
                    this.detailsChartSources.put(testName, existing);
                }
                existing.add(detailsSources.get(testName));
            }
        }
    }

    public void generateGraphs(ChartRenderer renderer, ResourceBundle bundle, ReportConfig config) throws IOException {
        for (ChartSource chartSource : this.getSummaryChartSources()) {
            if (!chartSource.isEnabled(config)) continue;
            JFreeChart chart = chartSource.getChart(bundle, config);
            String fileName = chartSource.getFileName(config);
            renderer.renderChart(fileName, chart);
        }
        for (List sources : this.detailsChartSources.values()) {
            for (ChartSource source : sources) {
                if (!source.isEnabled(config)) continue;
                JFreeChart chart = source.getChart(bundle, config);
                String fileName = source.getFileName(config);
                renderer.renderChart(fileName, chart);
            }
        }
    }

    public List<ChartSource> getSummaryChartSources() {
        return this.summaryChartSources;
    }

    public List getDetailsChartSources(String testName) {
        return (List)this.detailsChartSources.get(testName);
    }
}

