/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.jmeter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.jfree.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DependencyUtil {
    private String jmeterhome;
    private Log log;

    public DependencyUtil(String jmeterHome, Log log) {
        this.jmeterhome = jmeterHome;
        this.log = log;
    }

    public List<File> getDependencies(MavenProject project) {
        ArrayList<File> result = new ArrayList<File>();
        this.getDependencies(project, result, result);
        return result;
    }

    List copyDependencies(MavenProject project) throws IOException {
        File junitdir;
        final ArrayList copied = new ArrayList();
        ArrayList<File> compDeps = new ArrayList<File>();
        ArrayList<File> testDeps = new ArrayList<File>();
        this.getDependencies(project, compDeps, testDeps);
        File lib = new File(this.jmeterhome, "lib");
        for (File artifactFile : compDeps) {
            junitdir = new File(lib, "ext");
            this.copyFileToDir(copied, artifactFile, junitdir);
        }
        for (File artifactFile : testDeps) {
            junitdir = new File(lib, "junit");
            this.copyFileToDir(copied, artifactFile, junitdir);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                DependencyUtil.this.cleanUpDependencies(copied);
            }
        });
        return copied;
    }

    void cleanUpDependencies(List copied) {
        for (File file : copied) {
            if (!file.exists()) continue;
            file.delete();
        }
    }

    private void getDependencies(MavenProject project, List<File> compileTime, List<File> testTime) {
        Iterator it = project.getAttachedArtifacts().iterator();
        while (it.hasNext()) {
            this.registerDependency((Artifact)it.next(), compileTime, testTime);
        }
        this.registerDependency(project.getArtifact(), compileTime, testTime);
        Set transitiveDependencies = project.getArtifacts();
        if (transitiveDependencies != null) {
            for (Artifact dependency : transitiveDependencies) {
                this.registerDependency(dependency, compileTime, testTime);
            }
        }
    }

    private void registerDependency(Artifact artifact, List<File> compileTime, List<File> testTime) {
        if (artifact == null) {
            this.log.warn((CharSequence)"Artifact not found. Note that if Your JMeter test contains JUnittestcases, You can only invoke this goal through the default lifecycle.");
            return;
        }
        File artifactFile = artifact.getFile();
        if (artifactFile == null) {
            this.log.warn((CharSequence)"Artifact not found. Note that if Your JMeter test contains JUnittestcases, You can only invoke this goal through the default lifecycle.");
            return;
        }
        System.out.println("found dependency: " + artifact + " " + artifact.getScope() + "  " + artifactFile + "  " + artifact.getClassifier());
        if (Arrays.asList("compile", "runtime", "system", "import").contains(artifact.getScope()) || artifact.getScope() == null) {
            compileTime.add(artifactFile);
        } else if (Arrays.asList("test").contains(artifact.getScope())) {
            testTime.add(artifactFile);
        }
    }

    private void copyFileToDir(List copied, File file, File targetDirr) throws IOException {
        File target = new File(targetDirr, file.getName());
        if (target.exists()) {
            target.delete();
        }
        target.createNewFile();
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(target));
        IOUtils.getInstance().copyStreams((InputStream)input, (OutputStream)output);
        ((OutputStream)output).close();
        ((InputStream)input).close();
        this.log.debug((CharSequence)("Dependency copied to jmeter distribution at: " + target));
        copied.add(target);
    }
}

