/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.jmeter;

import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.mojo.chronos.common.model.ResponsetimeSample;
import org.codehaus.mojo.chronos.common.model.ResponsetimeSampleGroup;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class JMeterSAXFileHandler
extends DefaultHandler {
    private static final String JUNIT_SAMPLER_20 = "org.apache.jmeter.protocol.java.sampler.JUnitSampler";
    private final Collector collector = new Collector();
    private Properties sampleAttributes;
    private boolean inProperty = false;
    private boolean insideSample = false;
    private StringBuffer testMethodNameSB = new StringBuffer();
    private Properties parentSampleAttributes;

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("sampleResult".equals(qName)) {
            Properties props = new Properties();
            for (int i = 0; i < attributes.getLength(); ++i) {
                props.put(attributes.getQName(i), attributes.getValue(i));
            }
            this.sampleAttributes = props;
            this.insideSample = true;
        } else if ("property".equals(qName)) {
            this.inProperty = true;
        } else if ("httpSample".equals(qName) || "sample".equals(qName)) {
            if (this.insideSample) {
                this.parentSampleAttributes = this.sampleAttributes;
            }
            Properties props = new Properties();
            for (int i = 0; i < attributes.getLength(); ++i) {
                props.put(attributes.getQName(i), attributes.getValue(i));
            }
            this.sampleAttributes = props;
            this.insideSample = true;
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.insideSample && this.inProperty) {
            this.testMethodNameSB.append(new String(ch, start, length));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("property".equals(qName)) {
            this.inProperty = false;
        } else if ("sampleResult".equals(qName)) {
            String embeddedPropertyValue = this.testMethodNameSB.toString();
            this.collectJtl20(embeddedPropertyValue, this.sampleAttributes);
            this.reset();
        } else if ("httpSample".equals(qName) || "sample".equals(qName)) {
            if (!this.insideSample) {
                this.sampleAttributes = this.parentSampleAttributes;
            }
            this.collectJtl21(this.sampleAttributes);
            this.reset();
        }
    }

    private void collectJtl20(String embeddedPropertyValue, Properties sampleAttributes) {
        String label = sampleAttributes.getProperty("label");
        String sampleName = JUNIT_SAMPLER_20.equals(label) && !"".equals(embeddedPropertyValue) ? embeddedPropertyValue : label;
        int responsetime = Integer.parseInt(sampleAttributes.getProperty("time"));
        long timestamp = Long.parseLong(sampleAttributes.getProperty("timeStamp"));
        boolean success = "true".equals(sampleAttributes.getProperty("success"));
        String threadId = sampleAttributes.getProperty("threadName").intern();
        this.collector.collect(sampleName, responsetime, timestamp, success, threadId);
    }

    private void collectJtl21(Properties sampleAttributes) {
        String sampleName = sampleAttributes.getProperty("lb");
        int responsetime = Integer.parseInt(sampleAttributes.getProperty("t"));
        long timestamp = Long.parseLong(sampleAttributes.getProperty("ts"));
        boolean success = "true".equals(sampleAttributes.getProperty("s"));
        String threadId = sampleAttributes.getProperty("tn").intern();
        this.collector.collect(sampleName, responsetime, timestamp, success, threadId);
    }

    private void reset() {
        this.testMethodNameSB.setLength(0);
        this.insideSample = false;
        this.sampleAttributes = null;
    }

    void writeTo(XMLStreamWriter writer) throws XMLStreamException {
        this.collector.writeTo(writer);
    }

    private static class Collector {
        private final SortedMap<String, ResponsetimeSampleGroup> sampleGroupsByName = new TreeMap<String, ResponsetimeSampleGroup>();
        protected int succeeded;

        private Collector() {
        }

        private void collect(String sampleName, int responsetime, long timestamp, boolean success, String threadId) {
            ResponsetimeSampleGroup groupElement;
            if (success) {
                ++this.succeeded;
            }
            if ((groupElement = (ResponsetimeSampleGroup)this.sampleGroupsByName.get(sampleName)) == null) {
                groupElement = new ResponsetimeSampleGroup(sampleName);
                this.sampleGroupsByName.put(sampleName, groupElement);
            }
            groupElement.add(new ResponsetimeSample(responsetime, timestamp, success, threadId));
        }

        void writeTo(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement("groupedresponsetimesamples");
            writer.writeAttribute("succeeded", Integer.toString(this.succeeded));
            for (ResponsetimeSampleGroup sampleGroup : this.sampleGroupsByName.values()) {
                sampleGroup.writeTo(writer);
            }
            writer.writeEndElement();
        }
    }
}

