/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.history;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.chronos.common.HistoricDataDirectory;
import org.codehaus.mojo.chronos.common.ProjectBaseDir;
import org.codehaus.mojo.chronos.common.TestDataDirectory;
import org.codehaus.mojo.chronos.common.model.GCSamples;
import org.codehaus.mojo.chronos.common.model.GroupedResponsetimeSamples;
import org.codehaus.mojo.chronos.common.model.HistoricSample;
import org.jdom.JDOMException;

public class SaveHistoryMojo
extends AbstractMojo {
    MavenProject project;
    File historydir;
    String dataid;

    public void execute() throws MojoExecutionException, MojoFailureException {
        HistoricDataDirectory historicDataDirectory = new HistoricDataDirectory(this.historydir, this.dataid);
        ProjectBaseDir projectBaseDir = new ProjectBaseDir(this.project, this.getLog());
        TestDataDirectory testDataDirectory = projectBaseDir.getDataDirectory(this.dataid);
        try {
            GroupedResponsetimeSamples responseSamples = testDataDirectory.readResponsetimeSamples();
            if (responseSamples.size() == 0) {
                throw new MojoExecutionException("Response time samples not found for " + this.dataid);
            }
            GCSamples gcSamples = testDataDirectory.readGCSamples();
            HistoricSample history = new HistoricSample(responseSamples, gcSamples);
            historicDataDirectory.writeHistorySample(history);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("unable to find gcsamples with dataid=" + this.dataid, (Exception)ex);
        }
        catch (JDOMException ex) {
            throw new MojoExecutionException("unable to find gcsamples with dataid=" + this.dataid, (Exception)((Object)ex));
        }
    }
}

