/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.cassandra.AbstractCassandraMojo;
import org.codehaus.mojo.cassandra.Utils;

public class LoadCassandraMojo
extends AbstractCassandraMojo {
    protected File script;
    private boolean loadFailureIgnore;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block6: {
            if (this.skip) {
                this.getLog().info((CharSequence)"Skipping cassandra: cassandra.skip==true");
                return;
            }
            try {
                if (!this.script.isFile()) {
                    if (this.loadFailureIgnore) {
                        this.getLog().error((CharSequence)("Specified script " + this.script + " does not exist." + ". Ignoring as loadFailureIgnore is true"));
                        return;
                    }
                    throw new MojoFailureException("Specified script " + this.script + " does not exist.");
                }
                int rv = Utils.runLoadScript(this.cassandraDir, this.newCliCommandLine("--file", this.script.getAbsolutePath()), this.createEnvironmentVars(), this.getLog());
                if (rv == 0) break block6;
                if (this.loadFailureIgnore) {
                    this.getLog().error((CharSequence)("Command exited with error code " + rv + ". Ignoring as loadFailureIgnore is true"));
                    break block6;
                }
                throw new MojoExecutionException("Command exited with error code " + rv);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
            }
        }
    }
}

