/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import org.apache.cassandra.thrift.Cassandra;
import org.apache.commons.lang.StringUtils;
import org.codehaus.mojo.cassandra.AbstractSchemaCassandraMojo;
import org.codehaus.mojo.cassandra.ThriftApiExecutionException;
import org.codehaus.mojo.cassandra.ThriftApiOperation;

public class DropColumnFamiliesMojo
extends AbstractSchemaCassandraMojo {
    protected String columnFamilies;
    private String[] columnFamilyList;

    @Override
    protected ThriftApiOperation buildOperation() {
        DropCfOperation dropCfOp = new DropCfOperation(this.rpcAddress, this.rpcPort);
        dropCfOp.setKeyspace(this.keyspace);
        return dropCfOp;
    }

    @Override
    protected void parseArguments() throws IllegalArgumentException {
        if (StringUtils.isNotBlank((String)this.keyspace)) {
            throw new IllegalArgumentException("The keyspace to drop column families from cannot be empty");
        }
        this.columnFamilyList = StringUtils.split((String)this.columnFamilies, (char)',');
    }

    class DropCfOperation
    extends ThriftApiOperation {
        public DropCfOperation(String rpcAddress, int rpcPort) {
            super(rpcAddress, rpcPort);
        }

        @Override
        public void executeOperation(Cassandra.Client client) throws ThriftApiExecutionException {
            try {
                if (DropColumnFamiliesMojo.this.columnFamilyList != null && DropColumnFamiliesMojo.this.columnFamilyList.length > 0) {
                    for (int i = 0; i < DropColumnFamiliesMojo.this.columnFamilyList.length; ++i) {
                        client.system_drop_column_family(DropColumnFamiliesMojo.this.columnFamilyList[i]);
                        DropColumnFamiliesMojo.this.getLog().info((CharSequence)("Dropped column family \"" + DropColumnFamiliesMojo.this.columnFamilyList[i] + "\"."));
                    }
                } else {
                    client.system_drop_keyspace(DropColumnFamiliesMojo.this.keyspace);
                    DropColumnFamiliesMojo.this.getLog().info((CharSequence)("Dropped keyspace \"" + DropColumnFamiliesMojo.this.keyspace + "\"."));
                }
            }
            catch (Exception e) {
                throw new ThriftApiExecutionException(e);
            }
        }
    }
}

