/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.cassandra.thrift.CassandraDaemon;

public class CassandraMonitor
extends Thread {
    public static final String HOST_PROPERTY_NAME = "STOP.HOST";
    public static final String PORT_PROPERTY_NAME = "STOP.PORT";
    public static final String KEY_PROPERTY_NAME = "STOP.KEY";
    private final String key;
    private ServerSocket serverSocket;

    public CassandraMonitor(String address, int port, String key) throws IOException {
        this.key = key;
        this.serverSocket = new ServerSocket(port, 1, InetAddress.getByName(address));
        this.serverSocket.setReuseAddress(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.serverSocket != null) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
                socket.setSoLinger(false, 0);
                LineNumberReader lin = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
                String key = lin.readLine();
                if (!this.key.equals(key)) continue;
                String cmd = lin.readLine();
                if ("stop".equals(cmd)) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.serverSocket = null;
                    System.out.println("Killing Cassandra");
                    System.exit(0);
                    continue;
                }
                System.out.println("Unsupported monitor operation.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
                socket = null;
            }
        }
    }

    public static void main(String[] args) throws IOException {
        String host = System.getProperty(HOST_PROPERTY_NAME, "127.0.0.1");
        String property = System.getProperty(PORT_PROPERTY_NAME);
        String key = System.getProperty(KEY_PROPERTY_NAME);
        if (property != null && key != null) {
            int port = Integer.parseInt(property);
            CassandraMonitor monitor = new CassandraMonitor(host, port, key);
            monitor.setDaemon(true);
            monitor.start();
        }
        CassandraDaemon.main((String[])args);
    }
}

