/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.resolver.bod.mojo;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.resolver.bod.BuildOnDemandResolutionException;
import org.codehaus.mojo.resolver.bod.BuildOnDemandResolutionManager;
import org.codehaus.mojo.resolver.bod.BuildOnDemandResolutionRequest;
import org.codehaus.mojo.resolver.bod.build.BuildConfiguration;
import org.codehaus.mojo.resolver.bod.pom.rewrite.PomRewriteConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildOnDemandMojo
extends AbstractMojo {
    private static final BuildConfiguration DEFAULT_BUILD_CONFIGURATION;
    private static Set<String> globalBuildCache;
    private String resolutionMode;
    private List<MavenProject> reactorProjects;
    private MavenProject project;
    private ArtifactRepository localRepository;
    private boolean useGlobalBuildCache;
    private BuildConfiguration build = DEFAULT_BUILD_CONFIGURATION;
    private PomRewriteConfiguration rewrite;
    private File dependencyProjectsDir;
    private BuildOnDemandResolutionManager buildOnDemandResolutionManager;
    private Settings settings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        HashSet<String> buildCache;
        if (!BuildOnDemandResolutionRequest.isModeValid(this.resolutionMode)) {
            throw new MojoExecutionException(BuildOnDemandResolutionRequest.getInvalidModeMessage(this.resolutionMode));
        }
        if (this.useGlobalBuildCache) {
            BuildOnDemandMojo buildOnDemandMojo = this;
            synchronized (buildOnDemandMojo) {
                if (globalBuildCache == null) {
                    globalBuildCache = new HashSet<String>();
                }
            }
            buildCache = globalBuildCache;
        } else {
            buildCache = new HashSet();
        }
        if (this.getLog().isDebugEnabled()) {
            this.build.setDebug(true);
        }
        try {
            BuildOnDemandResolutionRequest request = new BuildOnDemandResolutionRequest();
            this.build.setOffline(this.settings.isOffline());
            request.setMode(this.resolutionMode);
            request.setBuildPrototype(this.build);
            request.setCompletedBuilds(buildCache);
            request.setCurrentPendingProjects(this.reactorProjects);
            request.setLocalRepository(this.localRepository);
            request.setPomRewriteConfiguration(this.rewrite);
            request.setProject(this.project);
            request.setProjectsDirectory(this.dependencyProjectsDir);
            request.setSettings(this.settings);
            this.buildOnDemandResolutionManager.resolveDependencies(request);
        }
        catch (BuildOnDemandResolutionException e) {
            MojoFailureException error = new MojoFailureException((Object)e, "Failed to build dependency projects.", "Failed to build dependency projects. Reason: " + e.getMessage());
            error.initCause((Throwable)e);
            throw error;
        }
    }

    public void setBuild(BuildConfiguration build) {
        this.build = build;
    }

    public void setDependencyProjectsDir(File dependencyProjectsDir) {
        this.dependencyProjectsDir = dependencyProjectsDir;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setReactorProjects(List<MavenProject> reactorProjects) {
        this.reactorProjects = reactorProjects;
    }

    public void setDependencyBuilder(BuildOnDemandResolutionManager buildOnDemandResolutionManager) {
        this.buildOnDemandResolutionManager = buildOnDemandResolutionManager;
    }

    public void setUseGlobalBuildCache(boolean useGlobalBuildCache) {
        this.useGlobalBuildCache = useGlobalBuildCache;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void setResolutionMode(String resolutionMode) {
        this.resolutionMode = resolutionMode;
    }

    static {
        BuildConfiguration config = new BuildConfiguration();
        config.setGoals(Collections.singletonList("install"));
        DEFAULT_BUILD_CONFIGURATION = config;
    }
}

