/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.axistools.java2wsdl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.axistools.axis.AbstractAxisPlugin;
import org.codehaus.mojo.axistools.axis.AxisPluginException;
import org.codehaus.mojo.axistools.java2wsdl.Java2WSDLPlugin;
import org.codehaus.mojo.axistools.java2wsdl.Java2WSDLWrapper;

public class DefaultJava2WSDLPlugin
extends AbstractAxisPlugin
implements Java2WSDLPlugin {
    private File outputDirectory;
    private String filename;
    private String classOfPortType;
    private String input;
    private String location;
    private String portTypeName;
    private String bindingName;
    private String serviceElementName;
    private String servicePortName;
    private String namespace;
    private String packageToNamespace;
    private ArrayList methods;
    private boolean all;
    private String outputWSDLMode;
    private String locationImport;
    private String namespaceImpl;
    private String outputImpl;
    private String implClass;
    private ArrayList excludes;
    private ArrayList stopClasses;
    private String typeMappingVersion;
    private String soapAction;
    private String style;
    private String use;
    private ArrayList extraClasses;
    private String importSchema;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private String classpath;

    public void execute() throws AxisPluginException {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        try {
            Java2WSDLWrapper wrapper = new Java2WSDLWrapper();
            wrapper.execute(this.generateArgumentList());
        }
        catch (Throwable t) {
            throw new AxisPluginException("Java2WSDL execution failed", t);
        }
        this.projectHelper.addResource(this.project, this.outputDirectory.getAbsolutePath(), Collections.singletonList("**/*.wsdl"), Collections.EMPTY_LIST);
    }

    private String[] generateArgumentList() throws AxisPluginException {
        Iterator i;
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("-o");
        argsList.add(this.outputDirectory.getAbsolutePath() + File.separator + this.filename);
        if (this.input != null) {
            argsList.add("-I");
            argsList.add(this.input);
        }
        if (this.location != null) {
            argsList.add("-l");
            argsList.add(this.location);
        }
        if (this.portTypeName != null) {
            argsList.add("-P");
            argsList.add(this.portTypeName);
        }
        if (this.bindingName != null) {
            argsList.add("-b");
            argsList.add(this.bindingName);
        }
        if (this.serviceElementName != null) {
            argsList.add("-S");
            argsList.add(this.serviceElementName);
        }
        if (this.servicePortName != null) {
            argsList.add("-s");
            argsList.add(this.servicePortName);
        }
        if (this.namespace != null) {
            argsList.add("-n");
            argsList.add(this.namespace);
        }
        if (this.packageToNamespace != null) {
            argsList.add("-p");
            argsList.add(this.packageToNamespace);
        }
        if (this.methods != null && this.methods.size() > 0) {
            argsList.add("-m");
            String methodList = "";
            Iterator i2 = this.methods.iterator();
            while (i2.hasNext()) {
                methodList = methodList + i2.next() + " ";
            }
            argsList.add(methodList);
        }
        if (this.all) {
            argsList.add("-a");
        }
        if (this.outputWSDLMode != null) {
            if ("All".equalsIgnoreCase(this.outputWSDLMode) || "Interface".equalsIgnoreCase(this.outputWSDLMode) || "Implementation".equalsIgnoreCase(this.outputWSDLMode)) {
                argsList.add("-w");
                argsList.add(this.outputWSDLMode);
            } else {
                throw new AxisPluginException("invalid outputWSDLMode setting");
            }
        }
        if (this.locationImport != null) {
            argsList.add("-L");
            argsList.add(this.locationImport);
        }
        if (this.namespaceImpl != null) {
            argsList.add("-N");
            argsList.add(this.namespaceImpl);
        }
        if (this.outputImpl != null) {
            argsList.add("-O");
            argsList.add(this.outputImpl);
        }
        if (this.implClass != null) {
            argsList.add("-i");
            argsList.add(this.implClass);
        }
        if (this.excludes != null && this.excludes.size() > 0) {
            argsList.add("-x");
            i = this.excludes.iterator();
            while (i.hasNext()) {
                argsList.add((String)i.next());
            }
        }
        if (this.stopClasses != null && this.stopClasses.size() > 0) {
            argsList.add("-c");
            i = this.stopClasses.iterator();
            while (i.hasNext()) {
                argsList.add((String)i.next());
            }
        }
        if (this.typeMappingVersion != null) {
            if ("1.1".equals(this.typeMappingVersion) || "1.2".equals(this.typeMappingVersion)) {
                argsList.add("-T");
                argsList.add(this.typeMappingVersion);
            } else {
                throw new AxisPluginException("invalid typeMappingVersion (1.1 or 1.2)");
            }
        }
        if (this.soapAction != null && ("DEFAULT".equalsIgnoreCase(this.soapAction) || "OPERATION".equalsIgnoreCase(this.soapAction) || "NONE".equalsIgnoreCase(this.soapAction))) {
            argsList.add("-A");
            argsList.add(this.soapAction.toUpperCase());
        }
        if (this.style != null && ("RPC".equalsIgnoreCase(this.style) || "DOCUMENT".equalsIgnoreCase(this.style) || "WRAPPED".equalsIgnoreCase(this.style))) {
            argsList.add("-y");
            argsList.add(this.style.toUpperCase());
        }
        if (this.use != null && ("LITERAL".equalsIgnoreCase(this.use) || "ENCODED".equalsIgnoreCase(this.use))) {
            argsList.add("-u");
            argsList.add(this.use.toUpperCase());
        }
        if (this.extraClasses != null && this.extraClasses.size() > 0) {
            i = this.extraClasses.iterator();
            while (i.hasNext()) {
                argsList.add("-e");
                argsList.add((String)i.next());
            }
        }
        if (this.importSchema != null) {
            argsList.add("-C");
            argsList.add(this.importSchema);
        }
        argsList.add("--classpath");
        argsList.add(this.classpath);
        if (this.classOfPortType != null) {
            if (this.portTypeName == null) {
                argsList.add(this.classOfPortType);
            } else {
                throw new AxisPluginException("invalid parameters, can not use portTypeName and classOfPortType together");
            }
        }
        this.getLog().debug((CharSequence)("argslist: " + argsList.toString()));
        return argsList.toArray(new String[argsList.size()]);
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setClassOfPortType(String classOfPortType) {
        this.classOfPortType = classOfPortType;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setPortTypeName(String portTypeName) {
        this.portTypeName = portTypeName;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public void setServiceElementName(String serviceElementName) {
        this.serviceElementName = serviceElementName;
    }

    public void setServicePortName(String servicePortName) {
        this.servicePortName = servicePortName;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPackageToNamespace(String packageToNamespace) {
        this.packageToNamespace = packageToNamespace;
    }

    public void setMethods(ArrayList methods) {
        this.methods = methods;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public void setOutputWSDLMode(String outputWSDLMode) {
        this.outputWSDLMode = outputWSDLMode;
    }

    public void setLocationImport(String locationImport) {
        this.locationImport = locationImport;
    }

    public void setNamespaceImpl(String namespaceImpl) {
        this.namespaceImpl = namespaceImpl;
    }

    public void setOutputImpl(String outputImpl) {
        this.outputImpl = outputImpl;
    }

    public void setImplClass(String implClass) {
        this.implClass = implClass;
    }

    public void setExcludes(ArrayList excludes) {
        this.excludes = excludes;
    }

    public void setStopClasses(ArrayList stopClasses) {
        this.stopClasses = stopClasses;
    }

    public void setTypeMappingVersion(String typeMappingVersion) {
        this.typeMappingVersion = typeMappingVersion;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public void setExtraClasses(ArrayList extraClasses) {
        this.extraClasses = extraClasses;
    }

    public void setImportSchema(String importSchema) {
        this.importSchema = importSchema;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setProjectHelper(MavenProjectHelper projectHelper) {
        this.projectHelper = projectHelper;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }
}

