/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.aspectj;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHolder;
import org.aspectj.tools.ajc.Main;
import org.codehaus.mojo.aspectj.AbstractAjcMojo;
import org.codehaus.mojo.aspectj.AjcHelper;
import org.codehaus.mojo.aspectj.CompilationFailedException;
import org.codehaus.mojo.aspectj.MavenMessageHandler;
import org.codehaus.mojo.aspectj.Module;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractAjcCompiler
extends AbstractAjcMojo {
    protected String aspectDirectory = "src/main/aspect";
    protected String testAspectDirectory = "src/test/aspect";
    protected String[] includes;
    protected String[] excludes;
    protected String ajdtBuildDefFile;
    protected Module[] weaveDependencies;
    protected Module[] aspectLibraries;
    protected boolean outxml;
    protected String outxmlfile;
    protected boolean emacssym;
    protected String Xlint;
    protected String target;
    protected String source;
    protected String complianceLevel;
    protected boolean deprecation;
    protected boolean noImportError;
    protected boolean proceedOnError;
    protected boolean preserveAllLocals;
    protected boolean referenceInfo;
    protected String encoding;
    protected boolean verbose;
    protected boolean showWeaveInfo;
    protected int repeat;
    protected boolean Xreweavable;
    protected boolean XnoInline;
    protected boolean XserializableAspects;
    protected boolean XaddSerialVersionUID;
    protected String bootclasspath;
    protected String warn;
    protected String argumentFileName = "builddef.lst";
    protected List ajcOptions = new ArrayList();
    protected Set resolvedIncludes;

    protected abstract List getOutputDirectories();

    protected abstract List getSourceDirectories();

    protected abstract String getAdditionalAspectPaths();

    public void execute() throws MojoExecutionException {
        ArtifactHandler artifactHandler = this.project.getArtifact().getArtifactHandler();
        if (!"java".equals(artifactHandler.getLanguage())) {
            this.getLog().debug((CharSequence)"Not executing aspectJ compiler as the project is not a Java classpath-capable package");
            return;
        }
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.project.getCompileSourceRoots().add(this.basedir.getAbsolutePath() + "/" + this.aspectDirectory);
        this.project.getTestCompileSourceRoots().add(this.basedir.getAbsolutePath() + "/" + this.testAspectDirectory);
        this.assembleArguments();
        if (!this.hasSourcesToCompile()) {
            this.getLog().debug((CharSequence)"No sources found skipping aspectJ compile");
            return;
        }
        if (!this.isBuildNeeded()) {
            this.getLog().debug((CharSequence)"No modifications found skipping aspectJ compile");
            return;
        }
        this.getLog().debug((CharSequence)"Starting compiling aspects");
        if (this.getLog().isDebugEnabled()) {
            String command = "Running : ajc ";
            Iterator iter = this.ajcOptions.iterator();
            while (iter.hasNext()) {
                command = command + iter.next() + " ";
            }
            this.getLog().debug((CharSequence)command);
        }
        try {
            File outDir = new File((String)this.getOutputDirectories().get(0));
            AjcHelper.writeBuildConfigToFile(this.ajcOptions, this.argumentFileName, outDir);
            this.getLog().debug((CharSequence)("Argumentsfile written : " + new File(outDir.getAbsolutePath() + this.argumentFileName).getAbsolutePath()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write arguments file to the target area");
        }
        Main main = new Main();
        MavenMessageHandler mavenMessageHandler = new MavenMessageHandler(this.getLog());
        main.setHolder((IMessageHolder)mavenMessageHandler);
        main.runMain(this.ajcOptions.toArray(new String[0]), false);
        IMessage[] errors = mavenMessageHandler.getErrors();
        if (errors.length > 0) {
            throw new CompilationFailedException(errors);
        }
    }

    protected void assembleArguments() throws MojoExecutionException {
        this.ajcOptions.add("-classpath");
        this.ajcOptions.add(AjcHelper.createClassPath(this.project, null, this.getOutputDirectories()));
        if (null != this.bootclasspath) {
            this.ajcOptions.add("-bootclasspath");
            this.ajcOptions.add(this.bootclasspath);
        }
        if (null != this.warn) {
            this.ajcOptions.add("-warn:");
            this.ajcOptions.add(this.warn);
        }
        this.addModulesArgument("-inpath", this.ajcOptions, this.weaveDependencies, null, "a dependency to weave");
        this.addModulesArgument("-aspectpath", this.ajcOptions, this.aspectLibraries, this.getAdditionalAspectPaths(), "an aspect library");
        this.ajcOptions.add("-d");
        this.ajcOptions.add(this.getOutputDirectories().get(0));
        this.resolvedIncludes = null != this.ajdtBuildDefFile ? AjcHelper.getBuildFilesForAjdtFile(this.ajdtBuildDefFile, this.basedir) : AjcHelper.getBuildFilesForSourceDirs(this.getSourceDirectories(), this.includes, this.excludes);
        this.ajcOptions.addAll(this.resolvedIncludes);
    }

    private void addModulesArgument(String argument, List arguments, Module[] modules, String aditionalpath, String role) throws MojoExecutionException {
        StringBuffer buf = new StringBuffer();
        if (null != aditionalpath) {
            arguments.add(argument);
            buf.append(aditionalpath);
        }
        if (modules != null && modules.length > 0) {
            if (!arguments.contains(argument)) {
                arguments.add(argument);
            }
            for (int i = 0; i < modules.length; ++i) {
                Module module = modules[i];
                String key = ArtifactUtils.versionlessKey((String)module.getGroupId(), (String)module.getArtifactId());
                Artifact artifact = (Artifact)this.project.getArtifactMap().get(key);
                if (artifact == null) {
                    throw new MojoExecutionException("The artifact " + key + " referenced in aspectj plugin as " + role + ", is not found the project dependencies");
                }
                if (buf.length() != 0) {
                    buf.append(File.pathSeparatorChar);
                }
                buf.append(artifact.getFile().getPath());
            }
        }
        if (buf.length() > 0) {
            String pathString = buf.toString();
            arguments.add(pathString);
            this.getLog().debug((CharSequence)("Adding " + argument + ": " + pathString));
        }
    }

    protected boolean isBuildNeeded() throws MojoExecutionException {
        File outDir = new File(this.getOutputDirectories().get(0).toString());
        return this.hasNoPreviousBuild(outDir) || this.hasArgumentsChanged(outDir) || this.hasSourcesChanged(outDir);
    }

    private boolean hasNoPreviousBuild(File outDir) {
        return !FileUtils.fileExists((String)new File(outDir.getAbsolutePath(), this.argumentFileName).getAbsolutePath());
    }

    private boolean hasArgumentsChanged(File outDir) throws MojoExecutionException {
        try {
            return !((Object)this.ajcOptions).equals(AjcHelper.readBuildConfigFile(this.argumentFileName, outDir));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during reading of previous argumentsfile ");
        }
    }

    private boolean hasSourcesToCompile() {
        return this.resolvedIncludes.size() > 0;
    }

    private boolean hasSourcesChanged(File outDir) {
        Iterator sourceIter = this.resolvedIncludes.iterator();
        long lastBuild = new File(outDir.getAbsolutePath(), this.argumentFileName).lastModified();
        while (sourceIter.hasNext()) {
            File sourceFile = new File((String)sourceIter.next());
            long sourceModified = sourceFile.lastModified();
            if (sourceModified < lastBuild) continue;
            return true;
        }
        return false;
    }

    public void setComplianceLevel(String complianceLevel) {
        if (complianceLevel.equals("1.3") || complianceLevel.equals("1.4") || complianceLevel.equals("1.5")) {
            this.ajcOptions.add("-" + complianceLevel);
        }
    }

    public void setDeprecation(boolean deprecation) {
        if (deprecation) {
            this.ajcOptions.add("-deprecation");
        }
    }

    public void setEmacssym(boolean emacssym) {
        if (emacssym) {
            this.ajcOptions.add("-emacssym");
        }
    }

    public void setEncoding(String encoding) {
        this.ajcOptions.add("-encoding");
        this.ajcOptions.add(encoding);
    }

    public void setNoImportError(boolean noImportError) {
        if (noImportError) {
            this.ajcOptions.add("-noImportError");
        }
    }

    public void setOutxml(boolean outxml) {
        if (outxml) {
            this.ajcOptions.add("-outxml");
        }
    }

    public void setOutxmlfile(String outxmlfile) {
        this.ajcOptions.add("-outxmlfile");
        this.ajcOptions.add(outxmlfile);
    }

    public void setPreserveAllLocals(boolean preserveAllLocals) {
        if (preserveAllLocals) {
            this.ajcOptions.add("-preserveAllLocals");
        }
    }

    public void setProceedOnError(boolean proceedOnError) {
        if (proceedOnError) {
            this.ajcOptions.add("-proceedOnError");
        }
    }

    public void setReferenceInfo(boolean referenceInfo) {
        if (referenceInfo) {
            this.ajcOptions.add("-referenceInfo");
        }
    }

    public void setRepeat(int repeat) {
        this.ajcOptions.add("-repeat");
        this.ajcOptions.add("" + repeat);
    }

    public void setShowWeaveInfo(boolean showWeaveInfo) {
        if (showWeaveInfo) {
            this.ajcOptions.add("-showWeaveInfo");
        }
    }

    public void setTarget(String target) {
        this.ajcOptions.add("-target");
        this.ajcOptions.add(target);
    }

    public void setSource(String source) {
        this.ajcOptions.add("-source");
        this.ajcOptions.add(source);
    }

    public void setVerbose(boolean verbose) {
        if (verbose) {
            this.ajcOptions.add("-verbose");
        }
    }

    public void setXlint(String xlint) {
        this.ajcOptions.add("-Xlint:" + xlint);
    }

    public void setXnoInline(boolean xnoInline) {
        if (xnoInline) {
            this.ajcOptions.add("-XnoInline");
        }
    }

    public void setXreweavable(boolean xreweavable) {
        if (xreweavable) {
            this.ajcOptions.add("-Xreweavable");
        }
    }

    public void setXserializableAspects(boolean xserializableAspects) {
        if (xserializableAspects) {
            this.ajcOptions.add("-XserializableAspects");
        }
    }

    public void setXaddSerialVersionUID(boolean xaddSerialVersionUID) {
        if (xaddSerialVersionUID) {
            this.ajcOptions.add("-XaddSerialVersionUID");
        }
    }

    public void setBootClassPath(String bootclasspath) {
        this.bootclasspath = bootclasspath;
    }

    public void setWarn(String warn) {
        this.warn = warn;
    }

    public void setArgumentFileName(String argumentFileName) {
        this.argumentFileName = argumentFileName;
    }
}

