/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.mapping.MappingUtils;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractAppAssemblerMojo
extends AbstractMojo
implements Contextualizable {
    protected String outputFileNameMapping;
    protected String repositoryLayout;
    protected boolean useTimestampInSnapshotFileName;
    protected ArtifactRepository localRepository;
    protected Artifact projectArtifact;
    protected ArtifactRepositoryFactory artifactRepositoryFactory;
    protected PlexusContainer container;

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    protected ArtifactRepositoryLayout getArtifactRepositoryLayout() throws MojoFailureException {
        try {
            ArtifactRepositoryLayout artifactRepositoryLayout = null;
            artifactRepositoryLayout = (ArtifactRepositoryLayout)this.container.lookup("org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout", this.repositoryLayout);
            if (artifactRepositoryLayout == null) {
                throw new MojoFailureException("Unknown repository layout '" + this.repositoryLayout + "'.");
            }
            return artifactRepositoryLayout;
        }
        catch (ComponentLookupException e) {
            throw new MojoFailureException("Unable to lookup the repository layout component '" + this.repositoryLayout + "': " + e.getMessage());
        }
    }

    protected void installArtifact(Artifact artifact, ArtifactRepository artifactRepository, boolean useTimestampInSnapshotFileName) throws MojoExecutionException {
        if (artifact != null && artifact.getFile() != null) {
            try {
                artifact.isSnapshot();
                File source = artifact.getFile();
                String localPath = artifactRepository.pathOf(artifact);
                File destination = new File(artifactRepository.getBasedir(), localPath);
                if (!destination.getParentFile().exists()) {
                    destination.getParentFile().mkdirs();
                }
                if (artifact.isSnapshot() && !useTimestampInSnapshotFileName) {
                    destination = new File(destination.getParentFile(), source.getName());
                }
                if (!source.isDirectory()) {
                    if (this.outputFileNameMapping != null) {
                        String fileName = MappingUtils.evaluateFileNameMapping((String)this.outputFileNameMapping, (Artifact)artifact);
                        destination = new File(destination.getParent(), fileName);
                    }
                    FileUtils.copyFile((File)source, (File)destination);
                }
                this.getLog().info((CharSequence)("Installing artifact " + source.getPath() + " to " + destination));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy artifact.", (Exception)e);
            }
            catch (InterpolationException e) {
                throw new MojoExecutionException("Failed to map file name.", (Exception)((Object)e));
            }
        }
    }

    protected void installArtifact(Artifact artifact, ArtifactRepository artifactRepository) throws MojoExecutionException {
        this.installArtifact(artifact, artifactRepository, true);
    }
}

