/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.antlr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:antlr-maven-plugin:2.2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven ANTLR Plugin", 0);
        this.append(sb, "Maven Plugin for Antlr v2", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "generate".equals(this.goal)) {
            this.append(sb, "antlr:generate", 0);
            this.append(sb, "Generates files based on grammar files with Antlr tool.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "Launch the ParseView debugger upon parser invocation.\nSee Command Line Options", 3);
                this.append(sb, "", 0);
                this.append(sb, "diagnostic (Default: false)", 2);
                this.append(sb, "Generate a text file from your grammar with a lot of debugging info.\nSee Command Line Options", 3);
                this.append(sb, "", 0);
                this.append(sb, "grammarDefs", 2);
                this.append(sb, "Grammar list presents in the sourceDirectory directory.\nSee Command Line Options\nExample:\n<grammarDefs>\n\n\u00a0\u00a0<grammar>\n\n\u00a0\u00a0\u00a0\u00a0<name>myGrammar.g</name>\n\n\u00a0\u00a0\u00a0\u00a0<glib>mySuperGrammar.g;myOtherSuperGrammar.g</glib>\n\n\u00a0\u00a0</grammar>\n\n</grammarDefs>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "grammars", 2);
                this.append(sb, "Comma separated grammar file names or grammar pattern file names present in the sourceDirectory directory.\nSee Command Line Options", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/antlr)", 2);
                this.append(sb, "Specifies the destination directory where Antlr should generate files.\nSee Command Line Options", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceDirectory (Default: ${basedir}/src/main/antlr)", 2);
                this.append(sb, "Specifies the Antlr directory containing grammar files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "trace (Default: false)", 2);
                this.append(sb, "Have all rules call traceIn/traceOut.\nSee Command Line Options", 3);
                this.append(sb, "", 0);
                this.append(sb, "traceLexer (Default: false)", 2);
                this.append(sb, "Have lexer rules call traceIn/traceOut.\nSee Command Line Options", 3);
                this.append(sb, "", 0);
                this.append(sb, "traceParser (Default: false)", 2);
                this.append(sb, "Have parser rules call traceIn/traceOut.\nSee Command Line Options", 3);
                this.append(sb, "", 0);
                this.append(sb, "traceTreeParser (Default: false)", 2);
                this.append(sb, "Have tree rules call traceIn/traceOut.\nSee Command Line Options", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "antlr:help", 0);
            this.append(sb, "Display help information on antlr-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0antlr:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "html".equals(this.goal)) {
            this.append(sb, "antlr:html", 0);
            this.append(sb, "Generates Antlr documentation from grammar files.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "Launch the ParseView debugger upon parser invocation.\nSee Command Line Options", 3);
                this.append(sb, "", 0);
                this.append(sb, "description (Default: Generated Antlr report from grammars.)", 2);
                this.append(sb, "The description of the Antlr report.", 3);
                this.append(sb, "", 0);
                this.append(sb, "diagnostic (Default: false)", 2);
                this.append(sb, "Generate a text file from your grammar with a lot of debugging info.\nSee Command Line Options", 3);
                this.append(sb, "", 0);
                this.append(sb, "grammarDefs", 2);
                this.append(sb, "Grammar list presents in the sourceDirectory directory.\nSee Command Line Options\nExample:\n<grammarDefs>\n\n\u00a0\u00a0<grammar>\n\n\u00a0\u00a0\u00a0\u00a0<name>myGrammar.g</name>\n\n\u00a0\u00a0\u00a0\u00a0<glib>mySuperGrammar.g;myOtherSuperGrammar.g</glib>\n\n\u00a0\u00a0</grammar>\n\n</grammarDefs>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "grammars", 2);
                this.append(sb, "Comma separated grammar file names or grammar pattern file names present in the sourceDirectory directory.\nSee Command Line Options", 3);
                this.append(sb, "", 0);
                this.append(sb, "name (Default: Antlr Grammars)", 2);
                this.append(sb, "The name of the Antlr report.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/antlr)", 2);
                this.append(sb, "Specifies the destination directory where Antlr should generate files.\nSee Command Line Options", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportOutputDirectory (Default: ${project.build.directory}/generated-site/antlr)", 2);
                this.append(sb, "Specifies the destination directory where Antlr generates HTML files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceDirectory (Default: ${basedir}/src/main/antlr)", 2);
                this.append(sb, "Specifies the Antlr directory containing grammar files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "trace (Default: false)", 2);
                this.append(sb, "Have all rules call traceIn/traceOut.\nSee Command Line Options", 3);
                this.append(sb, "", 0);
                this.append(sb, "traceLexer (Default: false)", 2);
                this.append(sb, "Have lexer rules call traceIn/traceOut.\nSee Command Line Options", 3);
                this.append(sb, "", 0);
                this.append(sb, "traceParser (Default: false)", 2);
                this.append(sb, "Have parser rules call traceIn/traceOut.\nSee Command Line Options", 3);
                this.append(sb, "", 0);
                this.append(sb, "traceTreeParser (Default: false)", 2);
                this.append(sb, "Have tree rules call traceIn/traceOut.\nSee Command Line Options", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

