/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.store.metadata;

import java.util.Collections;
import java.util.Map;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.metadata.AbstractMetadataPlugin;
import org.codehaus.modello.metadata.AssociationMetadata;
import org.codehaus.modello.metadata.ClassMetadata;
import org.codehaus.modello.metadata.FieldMetadata;
import org.codehaus.modello.metadata.ModelMetadata;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.store.metadata.StoreAssociationMetadata;
import org.codehaus.modello.plugin.store.metadata.StoreClassMetadata;
import org.codehaus.modello.plugin.store.metadata.StoreFieldMetadata;
import org.codehaus.modello.plugin.store.metadata.StoreModelMetadata;
import org.codehaus.plexus.util.StringUtils;

public class StoreMetadataPlugin
extends AbstractMetadataPlugin {
    public static final String PART = "stash.part";
    public static final String KEY_TYPE = "stash.keyType";

    public ModelMetadata getModelMetadata(Model model, Map data) {
        return new StoreModelMetadata();
    }

    public ClassMetadata getClassMetadata(ModelClass clazz, Map data) throws ModelloException {
        StoreClassMetadata metadata = new StoreClassMetadata();
        String storable = (String)data.get("stash.storable");
        if (storable != null && storable.equals("true")) {
            metadata.setStorable(true);
        }
        return metadata;
    }

    public FieldMetadata getFieldMetadata(ModelField field, Map data) throws ModelloException {
        StoreFieldMetadata metadata = new StoreFieldMetadata();
        metadata.setStorable(this.getBoolean(data, "stash.storable", true));
        String maxSize = (String)data.get("stash.maxSize");
        if (!StringUtils.isEmpty((String)maxSize)) {
            if (!field.getType().equals("String")) {
                throw new ModelloException("When specifying max size on a field the type must be String. Class: '" + field.getModelClass().getName() + "', " + "field : '" + field.getName() + "'.");
            }
            try {
                metadata.setMaxSize(Integer.parseInt(maxSize));
            }
            catch (NumberFormatException e) {
                throw new ModelloException("Max size on a field the type must be String. Class: '" + field.getModelClass().getName() + "', " + "field : '" + field.getName() + "'.");
            }
        }
        return metadata;
    }

    public AssociationMetadata getAssociationMetadata(ModelAssociation association, Map data) throws ModelloException {
        StoreAssociationMetadata metadata = new StoreAssociationMetadata();
        metadata.setStorable(this.getBoolean(data, "stash.storable", true));
        if (data.containsKey(PART)) {
            metadata.setPart(new Boolean((String)data.get(PART)));
        }
        String keyType = (String)data.get(KEY_TYPE);
        if (association.getType() != null && association.getType().equals("Map")) {
            if (StringUtils.isEmpty((String)keyType)) {
                throw new ModelloException("When the association is a java.util.Map key type has to be specified.Class: '" + association.getModelClass().getName() + "', " + "field : '" + association.getName() + "'.");
            }
            metadata.setKeyType(keyType);
        }
        return metadata;
    }

    public Map getFieldMap(ModelField field, FieldMetadata metadata) {
        return Collections.EMPTY_MAP;
    }
}

