/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.maven;

import java.io.File;
import java.util.Properties;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.modello.maven.AbstractModelloGeneratorMojo;

public abstract class AbstractModelloSourceGeneratorMojo
extends AbstractModelloGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}/generated-sources/modello", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(defaultValue="${maven.compiler.source}")
    private String javaSource;
    @Parameter(defaultValue="true")
    private boolean domAsXpp3;

    @Override
    protected boolean producesCompilableResult() {
        return true;
    }

    @Override
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    protected void customizeParameters(Properties parameters) {
        super.customizeParameters(parameters);
        if (this.encoding != null) {
            parameters.setProperty("modello.output.encoding", this.encoding);
        }
        if (this.javaSource != null) {
            if (this.javaSource.startsWith("1.")) {
                this.javaSource = this.javaSource.substring("1.".length());
            }
            parameters.setProperty("modello.output.java.source", this.javaSource);
        }
        parameters.setProperty("modello.dom.xpp3", Boolean.toString(this.domAsXpp3));
    }
}

