/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.plugin.execute;

import java.io.File;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.path.PathTranslator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;

public class ExpressionEvaluatorImpl
implements ExpressionEvaluator {
    private final MavenSession context;
    private final MojoExecution mojoExecution;
    private final MavenProject project;
    private final PathTranslator pathTranslator;
    private final String basedir;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ExpressionEvaluatorImpl(MavenSession context, MavenProject project) {
        this.context = context;
        this.mojoExecution = new MojoExecution(new MojoDescriptor());
        this.pathTranslator = this.lookupPathTranslator();
        this.project = project;
        this.basedir = this.lookupBasedir();
    }

    private PathTranslator lookupPathTranslator() {
        try {
            return (PathTranslator)this.context.lookup(PathTranslator.ROLE);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(e);
        }
    }

    private String lookupBasedir() {
        File projectFile;
        String basedir = null;
        if (this.project != null && (projectFile = this.project.getFile()) != null) {
            basedir = projectFile.getParentFile().getAbsolutePath();
        }
        if (basedir == null) {
            basedir = System.getProperty("user.dir");
        }
        return basedir;
    }

    public Object evaluate(String expr) throws ExpressionEvaluationException {
        try {
            return this.doEvaluate(expr);
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expr, (Throwable)e);
        }
    }

    private Object doEvaluate(String expr) throws Exception {
        String val;
        int exprStartDelimiter;
        if (expr == null) {
            return null;
        }
        String expression = this.stripTokens(expr);
        if (expression.equals(expr)) {
            int lastIndex;
            int index = expr.indexOf("${");
            if (index >= 0 && (lastIndex = expr.indexOf("}", index)) >= 0) {
                String retVal = expr.substring(0, index);
                retVal = index > 0 && expr.charAt(index - 1) == '$' ? retVal + expr.substring(index + 1, lastIndex + 1) : retVal + this.doEvaluate(expr.substring(index, lastIndex + 1));
                retVal = retVal + this.doEvaluate(expr.substring(lastIndex + 1));
                return retVal;
            }
            if (expression.indexOf("$$") > -1) {
                return expression.replaceAll("\\$\\$", "\\$");
            }
            return expression;
        }
        Object value = this.evaluateSpecials(expression);
        if (value == null) {
            value = this.resolveProperties(expression);
        }
        if (value instanceof String && (exprStartDelimiter = (val = (String)value).indexOf("${")) >= 0) {
            value = exprStartDelimiter > 0 ? val.substring(0, exprStartDelimiter) + this.doEvaluate(val.substring(exprStartDelimiter)) : this.doEvaluate(val.substring(exprStartDelimiter));
        }
        return value;
    }

    private Object resolveProperties(String expression) {
        if (!$assertionsDisabled && this.project == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.project.getProperties() == null) {
            throw new AssertionError();
        }
        return this.project.getProperties().get(expression);
    }

    private Object evaluateSpecials(String expression) throws Exception {
        Object value = null;
        if ("localRepository".equals(expression)) {
            value = this.context.getLocalRepository();
        } else if ("session".equals(expression)) {
            value = this.context;
        } else if ("reactorProjects".equals(expression)) {
            value = this.context.getSortedProjects();
        } else if ("reports".equals(expression)) {
            value = this.mojoExecution.getReports();
        } else if ("project".equals(expression)) {
            value = this.project;
        } else if ("executedProject".equals(expression)) {
            value = this.project.getExecutionProject();
        } else if (expression.startsWith("project")) {
            value = this.evaluateInContext(expression, this.project);
        } else if (expression.startsWith("plugin")) {
            value = this.evaluateInContext(expression, this.mojoExecution.getMojoDescriptor().getPluginDescriptor());
        } else if ("settings".equals(expression)) {
            value = this.context.getSettings();
        } else if (expression.startsWith("settings")) {
            value = this.evaluateInContext(expression, this.context.getSettings());
        } else if ("basedir".equals(expression)) {
            value = this.basedir;
        } else if (expression.startsWith("basedir")) {
            int pathSeparator = expression.indexOf("/");
            if (pathSeparator > 0) {
                value = this.basedir + expression.substring(pathSeparator);
            } else {
                throw new ExpressionEvaluationException("Unrecognized expression: " + expression);
            }
        }
        return value;
    }

    private Object evaluateInContext(String expression, Object context) throws Exception {
        Object value;
        int pathSeparator = expression.indexOf("/");
        if (pathSeparator > 0) {
            String pathExpression = expression.substring(0, pathSeparator);
            value = ReflectionValueExtractor.evaluate((String)pathExpression, (Object)context);
            value = value + expression.substring(pathSeparator);
        } else {
            value = ReflectionValueExtractor.evaluate((String)expression.substring(1), (Object)context);
        }
        return value;
    }

    private String stripTokens(String expr) {
        if (expr.startsWith("${") && expr.indexOf("}") == expr.length() - 1) {
            expr = expr.substring(2, expr.length() - 1);
        }
        return expr;
    }

    public File alignToBaseDirectory(File file) {
        File basedir = this.project != null && this.project.getFile() != null ? this.project.getFile().getParentFile() : new File(".").getAbsoluteFile().getParentFile();
        return new File(this.pathTranslator.alignToBaseDirectory(file.getPath(), basedir));
    }

    static {
        $assertionsDisabled = !ExpressionEvaluatorImpl.class.desiredAssertionStatus();
    }
}

