/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.plugin;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.gmaven.common.ArtifactItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MojoSupport
extends AbstractMojo {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected MavenProject project;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected ArtifactRepository artifactRepository;
    protected List remoteRepositories;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.doExecute();
        }
        catch (Exception e) {
            if (e instanceof MojoExecutionException) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
            if (e instanceof MojoFailureException) {
                MojoFailureException x = new MojoFailureException(e.getMessage());
                x.initCause((Throwable)e);
                throw x;
            }
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected abstract void doExecute() throws Exception;

    protected List getProjectClasspathElements() throws DependencyResolutionRequiredException {
        return Collections.EMPTY_LIST;
    }

    protected ArtifactItem[] getUserClassspathElements() {
        return new ArtifactItem[0];
    }

    protected URL[] createClassPath() throws Exception {
        ArtifactItem[] items;
        ArrayList<URL> list = new ArrayList<URL>();
        List files = this.getProjectClasspathElements();
        if (files != null) {
            this.log.debug("Project Classpath:");
            for (int i = 0; i < files.size(); ++i) {
                URL url = new File((String)files.get(i)).toURI().toURL();
                list.add(url);
                this.log.debug("    {}", (Object)url);
            }
        }
        if ((items = this.getUserClassspathElements()) != null) {
            this.log.debug("User Classpath:");
            for (int i = 0; i < items.length; ++i) {
                Artifact artifact = this.getArtifact(items[i]);
                URL url = artifact.getFile().toURI().toURL();
                list.add(url);
                this.log.debug("    {}", (Object)url);
            }
        }
        return list.toArray(new URL[list.size()]);
    }

    protected Artifact createArtifact(ArtifactItem item) throws MojoExecutionException {
        VersionRange range;
        if (!$assertionsDisabled && item == null) {
            throw new AssertionError();
        }
        if (item.getVersion() == null) {
            this.fillMissingArtifactVersion(item);
            if (item.getVersion() == null) {
                throw new MojoExecutionException("Unable to find artifact version of " + item.getGroupId() + ":" + item.getArtifactId() + " in either dependency list or in project's dependency management.");
            }
        }
        try {
            range = VersionRange.createFromVersionSpec((String)item.getVersion());
            this.log.trace("Using version range: {}", (Object)range);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Could not create range for version: " + item.getVersion(), (Exception)((Object)e));
        }
        return this.artifactFactory.createDependencyArtifact(item.getGroupId(), item.getArtifactId(), range, item.getType(), item.getClassifier(), "provided");
    }

    protected Artifact getArtifact(ArtifactItem item) throws MojoExecutionException {
        if (!$assertionsDisabled && item == null) {
            throw new AssertionError();
        }
        Artifact artifact = this.createArtifact(item);
        return this.resolveArtifact(artifact, false);
    }

    protected Artifact resolveArtifact(Artifact artifact, boolean transitive) throws MojoExecutionException {
        if (!$assertionsDisabled && artifact == null) {
            throw new AssertionError();
        }
        try {
            if (transitive) {
                this.artifactResolver.resolveTransitively(Collections.singleton(artifact), this.project.getArtifact(), this.project.getRemoteArtifactRepositories(), this.artifactRepository, this.artifactMetadataSource);
            } else {
                this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.artifactRepository);
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to find artifact", (Exception)((Object)e));
        }
        return artifact;
    }

    private void fillMissingArtifactVersion(ArtifactItem item) {
        Dependency dependency;
        int i;
        this.log.trace("Attempting to find missing version in {}:{}", (Object)item.getGroupId(), (Object)item.getArtifactId());
        List list = this.project.getDependencies();
        for (i = 0; i < list.size(); ++i) {
            dependency = (Dependency)list.get(i);
            if (!dependency.getGroupId().equals(item.getGroupId()) || !dependency.getArtifactId().equals(item.getArtifactId()) || !dependency.getType().equals(item.getType())) continue;
            this.log.trace("Found missing version: {} in dependency list", (Object)dependency.getVersion());
            item.setVersion(dependency.getVersion());
            return;
        }
        list = this.project.getDependencyManagement().getDependencies();
        for (i = 0; i < list.size(); ++i) {
            dependency = (Dependency)list.get(i);
            if (!dependency.getGroupId().equals(item.getGroupId()) || !dependency.getArtifactId().equals(item.getArtifactId()) || !dependency.getType().equals(item.getType())) continue;
            this.log.trace("Found missing version: {} in dependency management list", (Object)dependency.getVersion());
            item.setVersion(dependency.getVersion());
        }
    }

    static {
        $assertionsDisabled = !MojoSupport.class.desiredAssertionStatus();
    }
}

