package org.chorem.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class SessionHelper {

    /**
     * SessionHelper :
     * utility class all provided methods are accessible the static way
     */

    private SessionHelper() {// empty
}

    /**
     * getSessionDate :
     * @param wikitty 
     * @return Date 
     */

    public static Date getSessionDate(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(Session.EXT_SESSION, Session.FIELD_SESSION_SESSIONDATE);
        return value;
}

    /**
     * setSessionDate :
     * @param wikitty 
     * @param sessionDate 
     * @return Date 
     */

    public static Date setSessionDate(Wikitty wikitty, Date sessionDate) {
        Date oldValue = getSessionDate(wikitty);
        wikitty.setField(Session.EXT_SESSION, Session.FIELD_SESSION_SESSIONDATE, sessionDate);
        return oldValue;
}

    /**
     * getNum :
     * @param wikitty 
     * @return int 
     */

    public static int getNum(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(Session.EXT_SESSION, Session.FIELD_SESSION_NUM);
        return value;
}

    /**
     * setNum :
     * @param wikitty 
     * @param num 
     * @return int 
     */

    public static int setNum(Wikitty wikitty, int num) {
        int oldValue = getNum(wikitty);
        wikitty.setField(Session.EXT_SESSION, Session.FIELD_SESSION_NUM, num);
        return oldValue;
}

    /**
     * getStatus :
     * @param wikitty 
     * @return int 
     */

    public static int getStatus(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(Session.EXT_SESSION, Session.FIELD_SESSION_STATUS);
        return value;
}

    /**
     * setStatus :
     * @param wikitty 
     * @param status 
     * @return int 
     */

    public static int setStatus(Wikitty wikitty, int status) {
        int oldValue = getStatus(wikitty);
        wikitty.setField(Session.EXT_SESSION, Session.FIELD_SESSION_STATUS, status);
        return oldValue;
}

    /**
     * getParagraph :
     * @param wikitty 
     * @return String 
     */

    public static String getParagraph(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Session.EXT_SESSION, Session.FIELD_SESSION_PARAGRAPH);
        return value;
}

    /**
     * setParagraph :
     * @param wikitty 
     * @param paragraph 
     * @return String 
     */

    public static String setParagraph(Wikitty wikitty, String paragraph) {
        String oldValue = getParagraph(wikitty);
        wikitty.setField(Session.EXT_SESSION, Session.FIELD_SESSION_PARAGRAPH, paragraph);
        return oldValue;
}

    /**
     * getSessionLogs :
     * @param wikitty 
     * @return String 
     */

    public static String getSessionLogs(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Session.EXT_SESSION, Session.FIELD_SESSION_SESSIONLOGS);
        return value;
}

    /**
     * setSessionLogs :
     * @param wikitty 
     * @param sessionLogs 
     * @return String 
     */

    public static String setSessionLogs(Wikitty wikitty, String sessionLogs) {
        String oldValue = getSessionLogs(wikitty);
        wikitty.setField(Session.EXT_SESSION, Session.FIELD_SESSION_SESSIONLOGS, sessionLogs);
        return oldValue;
}

    /**
     * getFiles :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getFiles(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(Session.EXT_SESSION, Session.FIELD_SESSION_FILES, String.class);
        return result;
}

    /**
     * setFiles :
     * @param wikitty 
     * @param files 
     */

    public static void setFiles(Wikitty wikitty, Set<String> files) {
        wikitty.setField(Session.EXT_SESSION, Session.FIELD_SESSION_FILES, files);
}

    /**
     * addAllFiles :
     * @param wikitty 
     * @param files 
     */

    public static void addAllFiles(Wikitty wikitty, Set<String> files) {
        if(files != null){
            for (String id:files){
                addFiles(wikitty, id);
            }
        }
}

    /**
     * addFiles :
     * @param wikitty 
     * @param element 
     */

    public static void addFiles(Wikitty wikitty, String element) {
        wikitty.addToField(Session.EXT_SESSION, Session.FIELD_SESSION_FILES, element);
}

    /**
     * removeFiles :
     * @param wikitty 
     * @param element 
     */

    public static void removeFiles(Wikitty wikitty, String element) {
        wikitty.removeFromField(Session.EXT_SESSION, Session.FIELD_SESSION_FILES, element);
}

    /**
     * clearFiles :
     * @param wikitty 
     */

    public static void clearFiles(Wikitty wikitty) {
        wikitty.clearField(Session.EXT_SESSION, Session.FIELD_SESSION_FILES);
}

    /**
     * getSending :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getSending(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(Session.EXT_SESSION, Session.FIELD_SESSION_SENDING, String.class);
        return result;
}

    /**
     * setSending :
     * @param wikitty 
     * @param sending 
     */

    public static void setSending(Wikitty wikitty, Set<String> sending) {
        wikitty.setField(Session.EXT_SESSION, Session.FIELD_SESSION_SENDING, sending);
}

    /**
     * addAllSending :
     * @param wikitty 
     * @param sending 
     */

    public static void addAllSending(Wikitty wikitty, Set<String> sending) {
        if(sending != null){
            for (String id:sending){
                addSending(wikitty, id);
            }
        }
}

    /**
     * addSending :
     * @param wikitty 
     * @param element 
     */

    public static void addSending(Wikitty wikitty, String element) {
        wikitty.addToField(Session.EXT_SESSION, Session.FIELD_SESSION_SENDING, element);
}

    /**
     * removeSending :
     * @param wikitty 
     * @param element 
     */

    public static void removeSending(Wikitty wikitty, String element) {
        wikitty.removeFromField(Session.EXT_SESSION, Session.FIELD_SESSION_SENDING, element);
}

    /**
     * clearSending :
     * @param wikitty 
     */

    public static void clearSending(Wikitty wikitty) {
        wikitty.clearField(Session.EXT_SESSION, Session.FIELD_SESSION_SENDING);
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_SESSIONDATE);
            Object f2 = w2.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_SESSIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_NUM);
            Object f2 = w2.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_NUM);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_STATUS);
            Object f2 = w2.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_STATUS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_PARAGRAPH);
            Object f2 = w2.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_PARAGRAPH);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_SESSIONLOGS);
            Object f2 = w2.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_SESSIONLOGS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_FILES);
            Object f2 = w2.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_FILES);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_SENDING);
            Object f2 = w2.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_SENDING);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Session.EXT_SESSION);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : SessionAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //SessionHelper
