/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: FileUploadAware.java 3423 2012-06-05 16:50:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.2/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/FileUploadAware.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions;

import org.chorem.pollen.ui.interceptors.PollenFileUploadInterceptor;

import java.io.File;

/**
 * Contract to place on actions which needs some upload.
 * <p/>
 * This is linked with the {@link PollenFileUploadInterceptor} interceptor
 * which logic is not the same than the bacis struts2 upload interceptor.
 * <p/>
 * Created: 30/03/12
 *
 * @author fdesbois <desbois@codelutin.com>
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public interface FileUploadAware {

    void addFile(int index, File file);

    void addFileContentType(int index, String contentType);

    void addFileName(int index, String fileName);

}
