/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.user;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.services.FavoriteListImport;
import org.chorem.pollen.services.exceptions.FavoriteListAlreadyExistException;
import org.chorem.pollen.services.exceptions.FavoriteListImportException;
import org.chorem.pollen.services.exceptions.FavoriteListNotFoundException;
import org.chorem.pollen.services.exceptions.ParticipantAlreadyFoundInListException;
import org.chorem.pollen.services.impl.FavoriteListImportCSV;
import org.chorem.pollen.services.impl.FavoriteListImportLDAP;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.PollenActionSupport;

public class ManageFavoriteLists
extends PollenActionSupport {
    private static final long serialVersionUID = 1L;
    protected PersonList favoriteList;
    protected File csvImport;
    protected String csvImportContentType;
    protected String csvImportFileName;
    protected String ldapImport;
    protected String action;

    public void setCsvImport(File csvImport) {
        this.csvImport = csvImport;
    }

    public void setCsvImportContentType(String csvImportContentType) {
        this.csvImportContentType = csvImportContentType;
    }

    public void setCsvImportFileName(String csvImportFileName) {
        this.csvImportFileName = csvImportFileName;
    }

    public String getLdapImport() {
        return this.ldapImport;
    }

    public void setLdapImport(String ldapImport) {
        this.ldapImport = ldapImport;
    }

    public PersonList getCreateFavoriteList() {
        return this.getFavoriteList();
    }

    public PersonList getDeleteFavoriteList() {
        return this.getFavoriteList();
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public PageSkin getSkin() {
        return PageSkin.EDITION;
    }

    public void validate() {
        if ("create".equals(this.action) && StringUtils.isBlank((CharSequence)this.getCreateFavoriteList().getName())) {
            this.addFieldError("createFavoriteList.name", this._("pollen.error.favoriteListName.required", new Object[0]));
        }
    }

    public String create() throws Exception {
        String result;
        Preconditions.checkNotNull((Object)this.favoriteList);
        Preconditions.checkNotNull((Object)this.favoriteList.getName());
        try {
            FavoriteListImport importService;
            PersonList personList = this.getFavoriteService().createFavoriteList(this.getPollenUserAccount(), this.favoriteList.getName());
            if (this.csvImportFileName != null) {
                importService = (FavoriteListImport)this.newService(FavoriteListImportCSV.class);
                this.addImport(importService, this.csvImport.getAbsolutePath(), personList);
            }
            if (StringUtils.isNotBlank((CharSequence)this.ldapImport)) {
                importService = (FavoriteListImport)this.newService(FavoriteListImportLDAP.class);
                this.addImport(importService, this.ldapImport, personList);
            }
        }
        catch (FavoriteListAlreadyExistException ex) {
            this.addFieldError("createFavoriteList.name", this._("pollen.error.favoriteList.already.used", new Object[0]));
        }
        if (this.hasAnyErrors()) {
            result = "input";
        } else {
            this.getTransaction().commitTransaction();
            this.addFlashMessage(this._("pollen.information.favoriteList.created", new Object[]{this.favoriteList.getName()}));
            this.action = null;
            this.favoriteList = null;
            result = "success";
        }
        return result;
    }

    public String delete() throws Exception {
        Preconditions.checkNotNull((Object)this.favoriteList);
        PersonList deletedFavoritedList = this.getFavoriteService().deleteFavoriteList(this.getPollenUserAccount(), this.favoriteList);
        this.getTransaction().commitTransaction();
        this.addFlashMessage(this._("pollen.information.favoriteList.deleted", new Object[]{deletedFavoritedList.getName()}));
        this.action = null;
        this.favoriteList = null;
        return "success";
    }

    protected PersonList getFavoriteList() {
        if (this.favoriteList == null) {
            this.favoriteList = this.getFavoriteService().newFavoriteList();
        }
        return this.favoriteList;
    }

    protected void addImport(FavoriteListImport service, String url, PersonList list) throws FavoriteListNotFoundException {
        try {
            List importedAccounts = service.execute(url);
            for (PollAccount importedAccount : importedAccounts) {
                try {
                    this.getFavoriteService().addPollAccountToFavoriteList(list, importedAccount);
                }
                catch (ParticipantAlreadyFoundInListException ex) {
                    this.addFlashError(this._("pollen.error.favoriteList.import.participantExists", new Object[]{importedAccount.getEmail()}));
                }
            }
        }
        catch (FavoriteListImportException ex) {
            String message = ex.getLocalizedMessage(this.getLocale());
            this.addFlashError(message);
        }
    }
}

