/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui;

import com.google.common.collect.Maps;
import com.opensymphony.xwork2.ActionContext;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.PollenApplicationContext;
import org.chorem.pollen.PollenConfiguration;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.PollenTopiaRootContextFactory;
import org.chorem.pollen.entities.PollenDAOHelper;
import org.chorem.pollen.services.DefaultPollenServiceContext;
import org.chorem.pollen.services.PollenNotifierWorker;
import org.chorem.pollen.services.PollenServiceContext;
import org.chorem.pollen.services.PollenServiceFactory;
import org.chorem.pollen.services.impl.UserService;
import org.chorem.pollen.ui.PollenUIUtils;
import org.chorem.pollen.votecounting.strategy.VoteCountingStrategyProvider;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.util.FileUtil;

public class PollenApplicationListener
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(PollenApplicationListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        PollenConfiguration configuration;
        PollenApplicationContext applicationContext;
        block10: {
            if (log.isInfoEnabled()) {
                log.info((Object)("Application starting at " + new Date() + "..."));
            }
            PollenUIUtils.setServletContext((ServletContext)sce.getServletContext());
            DefaultI18nInitializer i18nInitializer = new DefaultI18nInitializer("pollen-i18n");
            i18nInitializer.setMissingKeyReturnNull(true);
            I18n.init((I18nInitializer)i18nInitializer, (Locale)Locale.getDefault());
            applicationContext = new PollenApplicationContext();
            PollenApplicationContext.set((ServletContext)sce.getServletContext(), (PollenApplicationContext)applicationContext);
            configuration = this.prepareConfiguration();
            if (log.isInfoEnabled()) {
                log.info((Object)("Base url " + configuration.getApplicationUrl()));
            }
            applicationContext.setConfiguration(configuration);
            applicationContext.setVoteCountingStrategyProvider(new VoteCountingStrategyProvider());
            File temporaryDirectory = configuration.getTemporaryDirectory();
            try {
                FileUtils.deleteDirectory((File)temporaryDirectory);
                FileUtil.createDirectoryIfNecessary((File)temporaryDirectory);
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block10;
                log.error((Object)("Could not delete tmp dir " + temporaryDirectory), (Throwable)e);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Initializing RootContext...");
        }
        HashMap map = Maps.newHashMap();
        map.put("com.opensymphony.xwork2.ActionContext.application", Maps.newHashMap());
        ActionContext actionContext = new ActionContext((Map)map);
        ActionContext.setContext((ActionContext)actionContext);
        PollenApplicationContext.set((ActionContext)actionContext, (PollenApplicationContext)applicationContext);
        try {
            PollenTopiaRootContextFactory f = new PollenTopiaRootContextFactory();
            TopiaContext rootContext = f.newDatabaseFromConfig(configuration);
            applicationContext.setRootContext(rootContext);
            this.initDB(applicationContext);
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not init db", (Throwable)e);
        }
        finally {
            ActionContext.setContext(null);
            PollenApplicationContext.set((ActionContext)actionContext, null);
        }
        this.initPollenNotifierworker(applicationContext);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext servletContext;
        PollenApplicationContext applicationContext;
        if (log.isInfoEnabled()) {
            log.info((Object)("Application is ending at " + new Date() + "..."));
        }
        if ((applicationContext = PollenApplicationContext.get((ServletContext)(servletContext = sce.getServletContext()))) != null) {
            this.closePollenNotifierWorker(applicationContext.getPollenNotifierWorker());
            this.closeRootcontext(applicationContext.getRootContext());
        }
    }

    protected PollenConfiguration prepareConfiguration() {
        PollenConfiguration configuration;
        String configurationFile = System.getProperty("pollenConfigurationFile");
        if (StringUtils.isNotBlank((CharSequence)configurationFile)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Use specific configuration file : " + configurationFile));
            }
            configuration = new PollenConfiguration(configurationFile, null);
        } else {
            configuration = new PollenConfiguration();
        }
        if (log.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("\n-----------------------------------------------------------------------------------------------------");
            builder.append("\nPollen configuration:");
            builder.append(configuration.printConfig());
            builder.append("\n-----------------------------------------------------------------------------------------------------");
            log.info((Object)builder.toString());
        }
        return configuration;
    }

    private void initPollenNotifierworker(PollenApplicationContext applicationContext) {
        PollenServiceContext serviceContext = DefaultPollenServiceContext.newContext((Locale)Locale.getDefault(), null, (PollenConfiguration)applicationContext.getConfiguration(), (PollenServiceFactory)new PollenServiceFactory(), (VoteCountingStrategyProvider)applicationContext.getVoteCountingStrategyProvider());
        PollenNotifierWorker pollenNotifierWorker = new PollenNotifierWorker(serviceContext, applicationContext.getRootContext());
        applicationContext.setPollenNotifierWorker(pollenNotifierWorker);
        pollenNotifierWorker.run();
    }

    private void closePollenNotifierWorker(PollenNotifierWorker pollenNotifierWorker) {
        block4: {
            if (pollenNotifierWorker != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Shuting down pollenNotifierWorker... " + pollenNotifierWorker));
                }
                try {
                    pollenNotifierWorker.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Could not close pollenNotifierWorker", (Throwable)e);
                }
            }
        }
    }

    private void closeRootcontext(TopiaContext rootContext) {
        block5: {
            if (rootContext != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Shuting down RootContext... " + rootContext));
                }
                if (!rootContext.isClosed()) {
                    try {
                        rootContext.closeContext();
                    }
                    catch (TopiaException te) {
                        if (!log.isErrorEnabled()) break block5;
                        log.error((Object)"Could not close rootContext", (Throwable)te);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDB(PollenApplicationContext applicationContext) throws TopiaException {
        ActionContext context = ActionContext.getContext();
        PollenApplicationContext.set((ActionContext)context, (PollenApplicationContext)applicationContext);
        TopiaContext rootContext = applicationContext.getRootContext();
        boolean schemaFound = TopiaUtil.isSchemaExist((TopiaContext)rootContext, (String)PollenDAOHelper.PollenEntityEnum.UserAccount.getImplementation().getName());
        if (!schemaFound) {
            rootContext.updateSchema();
        }
        PollenConfiguration configuration = applicationContext.getConfiguration();
        PollenServiceFactory serviceFactory = new PollenServiceFactory();
        TopiaContext transaction = rootContext.beginTransaction();
        try {
            PollenServiceContext serviceContext = DefaultPollenServiceContext.newContext((Locale)Locale.getDefault(), (TopiaContext)transaction, (PollenConfiguration)configuration, (PollenServiceFactory)serviceFactory, (VoteCountingStrategyProvider)applicationContext.getVoteCountingStrategyProvider());
            UserService service = (UserService)serviceFactory.newService(UserService.class, serviceContext);
            int nbUsers = service.getNbUsers();
            if (nbUsers == 0) {
                service.createDefaultUsers();
                transaction.commitTransaction();
            }
        }
        finally {
            this.closeTransaction(transaction);
        }
    }

    protected void closeTransaction(TopiaContext tx) throws TopiaException {
        if (tx != null && !tx.isClosed()) {
            tx.closeContext();
        }
    }
}

