/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: PollenFileUploadInterceptor.java 3257 2012-04-13 11:28:02Z fdesbois $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/interceptors/PollenFileUploadInterceptor.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.interceptors;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.interceptor.FileUploadInterceptor;
import org.chorem.pollen.ui.actions.FileUploadAware;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Overrides the default file upload interceptor to be able to match uploaded
 * files in specific fields.
 *
 * We want to put upload files in a list (field is file for example) and then
 * fileName in another list but the default interceptor does not accept this
 * since it suffix the filename field with FileName...
 *
 * TODO tchemit 2012-03-05 submit a patch to struts guys to avoid this fork.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class PollenFileUploadInterceptor extends FileUploadInterceptor {
    private static final long serialVersionUID = 1L;

    protected final Pattern FILENAME_PATTERN = Pattern.compile("(.+)\\[(.+)\\]");

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        ActionContext ac = invocation.getInvocationContext();

        HttpServletRequest request = (HttpServletRequest) ac.get(ServletActionContext.HTTP_REQUEST);

        if (!(request instanceof MultiPartRequestWrapper)) {
            if (LOG.isDebugEnabled()) {
                ActionProxy proxy = invocation.getProxy();
                LOG.debug(getTextMessage("struts.messages.bypass.request", new Object[]{proxy.getNamespace(), proxy.getActionName()}, ac.getLocale()));
            }

            return invocation.invoke();
        }

        ValidationAware validation = null;

        Object action = invocation.getAction();

        if (action instanceof ValidationAware) {
            validation = (ValidationAware) action;
        }

        MultiPartRequestWrapper multiWrapper = (MultiPartRequestWrapper) request;

        if (multiWrapper.hasErrors()) {
            for (String error : multiWrapper.getErrors()) {
                if (validation != null) {
                    validation.addActionError(error);
                }

                if (LOG.isWarnEnabled()) {
                    LOG.warn(error);
                }
            }
        }

        // bind allowed Files
        Enumeration fileParameterNames = multiWrapper.getFileParameterNames();
        while (fileParameterNames != null && fileParameterNames.hasMoreElements()) {
            // get the value of this input tag
            String inputName = (String) fileParameterNames.nextElement();

            // get the content type
            String[] contentType = multiWrapper.getContentTypes(inputName);

            if (isNonEmpty(contentType)) {
                // get the name of the file from the input tag
                String[] fileName = multiWrapper.getFileNames(inputName);

                if (isNonEmpty(fileName)) {
                    // get a File object for the uploaded File
                    File[] files = multiWrapper.getFiles(inputName);
                    if (files != null && files.length > 0) {
                        List<File> acceptedFiles = new ArrayList<File>(files.length);
                        List<String> acceptedContentTypes = new ArrayList<String>(files.length);
                        List<String> acceptedFileNames = new ArrayList<String>(files.length);

                        Matcher matcher1 = FILENAME_PATTERN.matcher(inputName);

                        String contentTypeName;
                        String fileNameName;
                        if (matcher1.matches()) {
                            String prefix = matcher1.group(1);
                            String suffix = matcher1.group(2);
                            contentTypeName = prefix + "ContentType[" + suffix + "]";
                            fileNameName = prefix + "FileName[" + suffix + "]";
                        } else {
                            contentTypeName = inputName + "ContentType";
                            fileNameName = inputName + "FileName";
                        }


                        for (int index = 0; index < files.length; index++) {
                            if (acceptFile(action, files[index], fileName[index], contentType[index], inputName, validation, ac.getLocale())) {
                                acceptedFiles.add(files[index]);
                                acceptedContentTypes.add(contentType[index]);
                                acceptedFileNames.add(fileName[index]);
                            }
                        }

                        if (!acceptedFiles.isEmpty()) {

                            if (action instanceof FileUploadAware) {
                                FileUploadAware fileUpload = (FileUploadAware) action;

                                fileUpload.setFiles(inputName, acceptedFiles);
                                fileUpload.setFileContentTypes(contentTypeName, acceptedContentTypes);
                                fileUpload.setFileNames(fileNameName, acceptedFileNames);

                            } else {
                                Map<String, Object> params = ac.getParameters();

                                params.put(inputName, acceptedFiles.toArray(new File[acceptedFiles.size()]));
                                params.put(contentTypeName, acceptedContentTypes.toArray(new String[acceptedContentTypes.size()]));
                                params.put(fileNameName, acceptedFileNames.toArray(new String[acceptedFileNames.size()]));
                            }
                        }
                    }
                } else {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn(getTextMessage(action, "struts.messages.invalid.file", new Object[]{inputName}, ac.getLocale()));
                    }
                }
            } else {
                if (LOG.isWarnEnabled()) {
                    LOG.warn(getTextMessage(action, "struts.messages.invalid.content.type", new Object[]{inputName}, ac.getLocale()));
                }
            }
        }

        // invoke action
        return invocation.invoke();
    }

    private static final String DEFAULT_MESSAGE = "no.message.found";

//    private PatternMatcher matcher;
//
//    @Inject
//    public void setMatcher(PatternMatcher matcher) {
//        this.matcher = matcher;
//    }

    private boolean isNonEmpty(Object[] objArray) {
        boolean result = false;
        for (int index = 0; index < objArray.length && !result; index++) {
            if (objArray[index] != null) {
                result = true;
            }
        }
        return result;
    }

    private String getTextMessage(String messageKey, Object[] args, Locale locale) {
        return getTextMessage(null, messageKey, args, locale);
    }

    private String getTextMessage(Object action, String messageKey, Object[] args, Locale locale) {
        if (args == null || args.length == 0) {
            if (action != null && useActionMessageBundle) {
                return LocalizedTextUtil.findText(action.getClass(), messageKey, locale);
            }
            return LocalizedTextUtil.findText(this.getClass(), messageKey, locale);
        } else {
            if (action != null && useActionMessageBundle) {
                return LocalizedTextUtil.findText(action.getClass(), messageKey, locale, DEFAULT_MESSAGE, args);
            }
            return LocalizedTextUtil.findText(this.getClass(), messageKey, locale, DEFAULT_MESSAGE, args);
        }
    }
}
