/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: PollUriConverter.java 3395 2012-05-28 15:34:46Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/converters/PollUriConverter.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.converters;

import com.google.common.base.Preconditions;
import org.apache.struts2.util.StrutsTypeConverter;
import org.chorem.pollen.bean.PollUri;

import java.util.Map;

/**
 * Created: 27/03/12
 *
 * @author fdesbois <desbois@codelutin.com>
 */
public class PollUriConverter extends StrutsTypeConverter {

    private static PollUriConverter instance;

    public static PollUriConverter getInstance() {
        if (instance == null) {
            instance = new PollUriConverter();
        }
        return instance;
    }

    @Override
    public PollUri convertFromString(Map context, String[] values, Class toClass) {
        PollUri result;
        if (values.length == 1) {
            String value = values[0];
            result = PollUri.newPollUri(value);

        } else {
            result = null;
        }
        return result;
    }

    @Override
    public String convertToString(Map context, Object o) {
        String result;
        if (o != null) {
            result = ((PollUri) o).getUri();

        } else {
            result = "";
        }
        return result;
    }

    public static PollUri convertFromString(String[] values) {
        Preconditions.checkNotNull(values);
        PollUri result = getInstance().convertFromString(null, values, PollUri.class);
        return result;
    }
}
