/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.interceptors;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import java.io.File;
import java.util.Enumeration;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.interceptor.FileUploadInterceptor;
import org.chorem.pollen.ui.actions.FileUploadAware;

public class PollenFileUploadInterceptor
extends FileUploadInterceptor {
    private static final long serialVersionUID = 1L;
    protected final Pattern FILENAME_PATTERN = Pattern.compile("(.+)\\[(.+)\\]");
    private static final String DEFAULT_MESSAGE = "no.message.found";

    public String intercept(ActionInvocation invocation) throws Exception {
        MultiPartRequestWrapper multiWrapper;
        ActionContext ac = invocation.getInvocationContext();
        HttpServletRequest request = (HttpServletRequest)ac.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        if (!(request instanceof MultiPartRequestWrapper)) {
            if (LOG.isDebugEnabled()) {
                ActionProxy proxy = invocation.getProxy();
                LOG.debug(this.getTextMessage("struts.messages.bypass.request", new Object[]{proxy.getNamespace(), proxy.getActionName()}, ac.getLocale()), new String[0]);
            }
            return invocation.invoke();
        }
        ValidationAware validation = null;
        Object action = invocation.getAction();
        if (!(action instanceof FileUploadAware)) {
            return invocation.invoke();
        }
        if (action instanceof ValidationAware) {
            validation = (ValidationAware)action;
        }
        if ((multiWrapper = (MultiPartRequestWrapper)request).hasErrors()) {
            for (String error : multiWrapper.getErrors()) {
                if (validation != null) {
                    validation.addActionError(error);
                }
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn(error, new String[0]);
            }
        }
        Enumeration fileParameterNames = multiWrapper.getFileParameterNames();
        while (fileParameterNames != null && fileParameterNames.hasMoreElements()) {
            String inputName = (String)fileParameterNames.nextElement();
            Matcher matcher1 = this.FILENAME_PATTERN.matcher(inputName);
            if (!matcher1.matches()) {
                throw new IllegalStateException("Uploaded param name must match " + this.FILENAME_PATTERN);
            }
            Integer suffix = Integer.valueOf(matcher1.group(2));
            Object[] contentType = multiWrapper.getContentTypes(inputName);
            if (this.isNonEmpty(contentType)) {
                Object[] fileName = multiWrapper.getFileNames(inputName);
                if (this.isNonEmpty(fileName)) {
                    File[] files = multiWrapper.getFiles(inputName);
                    if (files == null || files.length <= 0) continue;
                    if (files.length > 1) {
                        throw new IllegalStateException("Only accept one file to upload for name " + inputName);
                    }
                    File acceptedFile = null;
                    Object acceptedContentType = null;
                    Object acceptedFileName = null;
                    if (this.acceptFile(action, files[0], (String)fileName[0], (String)contentType[0], inputName, validation, ac.getLocale())) {
                        acceptedFile = files[0];
                        acceptedContentType = contentType[0];
                        acceptedFileName = fileName[0];
                    }
                    if (acceptedFile == null) continue;
                    FileUploadAware fileUpload = (FileUploadAware)action;
                    fileUpload.addFile(suffix.intValue(), acceptedFile);
                    fileUpload.addFileContentType(suffix.intValue(), (String)acceptedContentType);
                    fileUpload.addFileName(suffix.intValue(), (String)acceptedFileName);
                    continue;
                }
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn(this.getTextMessage(action, "struts.messages.invalid.file", new Object[]{inputName}, ac.getLocale()), new String[0]);
                continue;
            }
            if (!LOG.isWarnEnabled()) continue;
            LOG.warn(this.getTextMessage(action, "struts.messages.invalid.content.type", new Object[]{inputName}, ac.getLocale()), new String[0]);
        }
        return invocation.invoke();
    }

    private boolean isNonEmpty(Object[] objArray) {
        boolean result = false;
        for (int index = 0; index < objArray.length && !result; ++index) {
            if (objArray[index] == null) continue;
            result = true;
        }
        return result;
    }

    private String getTextMessage(String messageKey, Object[] args, Locale locale) {
        return this.getTextMessage(null, messageKey, args, locale);
    }

    private String getTextMessage(Object action, String messageKey, Object[] args, Locale locale) {
        if (args == null || args.length == 0) {
            if (action != null && this.useActionMessageBundle) {
                return LocalizedTextUtil.findText(action.getClass(), (String)messageKey, (Locale)locale);
            }
            return LocalizedTextUtil.findText(this.getClass(), (String)messageKey, (Locale)locale);
        }
        if (action != null && this.useActionMessageBundle) {
            return LocalizedTextUtil.findText(action.getClass(), (String)messageKey, (Locale)locale, (String)DEFAULT_MESSAGE, (Object[])args);
        }
        return LocalizedTextUtil.findText(this.getClass(), (String)messageKey, (Locale)locale, (String)DEFAULT_MESSAGE, (Object[])args);
    }
}

