/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Function;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.services.PollenServiceFunctions;
import org.chorem.pollen.services.impl.FavoriteService;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.ui.actions.PollenActionSupport;

public class ImportPersonListToVotingList
extends PollenActionSupport {
    private static final long serialVersionUID = 1L;
    protected String votingListType;
    protected int votingListNumber;
    protected VotingList votingList;
    protected int startNumber;
    protected String personListId;

    public int getVotingListNumber() {
        return this.votingListNumber;
    }

    public int getStartNumber() {
        return this.startNumber;
    }

    public String getVotingListType() {
        return this.votingListType;
    }

    public VotingList getVotingList() {
        return this.votingList;
    }

    public void setVotingListNumber(int votingListNumber) {
        this.votingListNumber = votingListNumber;
    }

    public void setVotingListType(String votingListType) {
        this.votingListType = votingListType;
    }

    public void setStartNumber(int startNumber) {
        this.startNumber = startNumber;
    }

    public void setPersonListId(String personListId) {
        this.personListId = personListId;
    }

    public String execute() throws Exception {
        FavoriteService service = (FavoriteService)this.newService(FavoriteService.class);
        PersonList favoriteList = service.getFavoriteList(this.getPollenUserAccount(), this.personListId);
        Function persontoListCreator = PollenServiceFunctions.newPersonToListCreator();
        Function votingListCreator = PollenServiceFunctions.newVotingListCreator((Function)persontoListCreator);
        this.votingList = (VotingList)votingListCreator.apply(null);
        PollService pollService = (PollService)this.newService(PollService.class);
        for (PollAccount pollAccount : favoriteList.getPollAccount()) {
            PersonToList p = pollService.getNewPersonToList(pollAccount);
            this.votingList.addPollAccountPersonToList(p);
        }
        return "success";
    }
}

