/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: LoadPoll.java 3394 2012-05-28 15:27:04Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/LoadPoll.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll;

import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.PreventRule;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.services.impl.PreventRuleService;

import java.util.List;

/**
 * Created: 04/04/12
 *
 * @author fdesbois <desbois@codelutin.com>
 */
public class LoadPoll extends AbstractPollForm {

    private static final long serialVersionUID = 1L;

    private PollUri pollUri;

    private boolean clone;

    public PollUri getUriId() {
        return pollUri;
    }

    public void setUriId(PollUri pollUri) {
        this.pollUri = pollUri;
    }

    public void setClone(boolean clone) {
        this.clone = clone;
    }

    @Override
    public String execute() throws Exception {

        prepareFormPage();

        UserAccount userAccount = getPollenUserAccount();
        String pollUid = pollUri == null ? null : pollUri.getPollId();
        poll = getPollService().getPollEditable(pollUid, userAccount, clone);

        if (poll.isClosed()) {
            addFlashWarning(_("pollen.warning.poll.is.closed.so.read.only"));
        }
        List<Choice> pollChoices = poll.getChoice();
        List<VotingList> pollVotingLists = poll.getVotingList();

        loadChoicesAndvotingLists(poll,
                                  pollChoices,
                                  pollVotingLists,
                                  !isVoteStarted());

        if (poll.getMaxChoiceNb() > 0) {
            setLimitChoice(true);
        }

        PreventRule reminder = poll.getPreventRuleByScope(
                PreventRuleService.SCOPE_REMINDER);
        if (reminder != null) {
            setReminder(true);
            setReminderHourCountdown(reminder.getSensibility());
        }

        PreventRule notification = poll.getPreventRuleByScope(
                PreventRuleService.SCOPE_VOTE);
        if (notification != null) {
            setNotification(true);
        }

        if (isVoteStarted()) {
            addFlashMessage(_("pollen.information.poll.form.voteStarted"));
        }

        return SUCCESS;
    }


}
