/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: AbstractPollUriIdAction.java 3395 2012-05-28 15:34:46Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/AbstractPollUriIdAction.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.chorem.pollen.ui.converters.PollUriConverter;

import java.util.Map;

/**
 * Abstract action for all actions with a poll uri id.
 *
 * @author tchemit <chemit@codelutin.com>
 * @author fdesbois <fdesbois@codelutin.com>
 * @since 1.3
 */
public abstract class AbstractPollUriIdAction extends PollenActionSupport {

    public static final String PARAM_POLL_URI = "uriId";

    public static final String PARAM_POLL_PAGE = "page";

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(AbstractPollUriIdAction.class);

    private PollUri pollUri;

    private int page;

    public final PollUri getUriId() {
        return pollUri;
    }

    public final void setUriId(PollUri pollUri) {
        if (log.isInfoEnabled()) {
            log.info("PollUri : " + pollUri.getUri());
        }
        this.pollUri = pollUri;
    }

    public final int getPage() {
        return page;
    }

    public final void setPage(int page) {
        if (log.isInfoEnabled()) {
            log.info("Page number : " + page);
        }
        this.page = page;
    }

    public final String getPollId() {
        return pollUri != null ? pollUri.getPollId() : null;
    }

    public final String getAccountId() {
        return pollUri != null ? pollUri.getAccountId() : null;
    }

    protected void preparePollUri(Map<String, String[]> parameters) {
        if (pollUri == null) {
            String[] values = parameters.get(PARAM_POLL_URI);
            pollUri = PollUriConverter.convertFromString(values);
        }
    }

    protected void preparePollUri(String pollId, String accountId) {
        pollUri = PollUri.newPollUri(pollId, accountId);
    }
}
