/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.job;

import java.util.Locale;
import org.chorem.pollen.persistence.PollenPersistenceContext;
import org.chorem.pollen.services.PollenService;
import org.chorem.pollen.services.PollenServiceContext;
import org.chorem.pollen.services.PollenServicesApplicationContext;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPollenJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(AbstractPollenJob.class);
    public static final String APPLICATION_CONTEXT = "applicationContext";
    protected PollenServiceContext serviceContext;

    protected <E extends PollenService> E newService(Class<E> serviceClass) {
        return this.serviceContext.newService(serviceClass);
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        log.debug("Now running '{}' job", (Object)this.getDescription());
        PollenServicesApplicationContext applicationContext = (PollenServicesApplicationContext)jobExecutionContext.getMergedJobDataMap().get((Object)APPLICATION_CONTEXT);
        if (!applicationContext.isReady()) {
            log.warn("Application is not ready yet, aborting '{}' job execution", (Object)this.getDescription());
            return;
        }
        try (PollenPersistenceContext persistenceContext = applicationContext.newPersistenceContext();){
            this.serviceContext = applicationContext.newServiceContext(persistenceContext, Locale.getDefault());
            this.execute();
        }
        catch (Exception e) {
            log.error("Exception on Job", (Throwable)e);
            throw new JobExecutionException((Throwable)e);
        }
    }

    protected abstract String getDescription();

    protected abstract void execute();
}

