/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteDAOAbstract;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

public class VoteDAOImpl<E extends Vote>
extends VoteDAOAbstract<E> {
    private static final Log log = LogFactory.getLog(VoteDAOImpl.class);

    public List<E> getAllVotes(Poll poll) throws TopiaException {
        List results;
        Preconditions.checkNotNull((Object)poll);
        if (poll.isAnonymous()) {
            results = Lists.newArrayList();
        } else {
            TopiaQuery query = this.createQuery("e").addFrom(Poll.class, "p").addWhere("p", TopiaQuery.Op.EQ, (Object)poll).addWhere("e in elements (p.vote)").addOrder(new String[]{"e.topiaCreateDate DESC"});
            results = this.findAllByQuery(query);
        }
        return results;
    }

    public List<E> getVotesByPoll(Poll poll, TopiaFilterPagerUtil.FilterPagerBean pager) throws TopiaException {
        List results;
        Preconditions.checkNotNull((Object)poll);
        Preconditions.checkNotNull((Object)pager);
        if (poll.isAnonymous()) {
            results = Lists.newArrayList();
        } else {
            TopiaQuery query = this.createQuery("e").addFrom(Poll.class, "p").addWhere("p", TopiaQuery.Op.EQ, (Object)poll).addWhere("e in elements (p.vote)").addOrder(new String[]{"e.topiaCreateDate"});
            TopiaFilterPagerUtil.addPagerToQuery((TopiaQuery)query, (TopiaFilterPagerUtil.FilterPagerBean)pager);
            results = this.findAllByQuery(query);
        }
        return results;
    }

    public boolean hasAlreadyVoted(Poll poll, String votingId) throws TopiaException {
        TopiaQuery query = this.createQuery("e").addFrom(Poll.class, "p").addWhere("p", TopiaQuery.Op.EQ, (Object)poll).addWhere("e in elements(p.vote)").addWhere("e.pollAccount.votingId", TopiaQuery.Op.EQ, (Object)votingId).addOrder(new String[]{"e.topiaCreateDate"});
        boolean result = this.existByQuery(query);
        return result;
    }

    public Vote findByAccountId(String accountId) throws TopiaException {
        String accountIdProperty = TopiaQuery.getProperty((String[])new String[]{"e", "pollAccount", "accountId"});
        TopiaQuery query = this.createQuery("e").addEquals(accountIdProperty, new Object[]{accountId});
        Vote result = (Vote)this.findByQuery(query);
        return result;
    }
}

