/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.PollenFunctions;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollDAOAbstract;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.VoteDAO;
import org.chorem.pollen.entities.PollenDAOHelper;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;
import org.nuiton.util.PagerUtil;

public class PollDAOImpl<E extends Poll>
extends PollDAOAbstract<E> {
    private static final Log log = LogFactory.getLog(PollDAOImpl.class);

    public List<E> getPolls(TopiaFilterPagerUtil.FilterPagerBean pager) throws TopiaException {
        Preconditions.checkNotNull((Object)pager);
        long records = this.count();
        pager.setRecords((int)records);
        TopiaQuery query = this.createQuery("e");
        TopiaFilterPagerUtil.addPagerToQuery((TopiaQuery)query, (TopiaFilterPagerUtil.FilterPagerBean)pager);
        List result = this.findAllByQuery(query);
        return result;
    }

    public List<E> getCreatedPolls(TopiaFilterPagerUtil.FilterPagerBean pager, UserAccount user) throws TopiaException {
        Preconditions.checkNotNull((Object)pager);
        Preconditions.checkNotNull((Object)user);
        TopiaQuery countQuery = this.createQuery("e");
        countQuery.addWhere("e.creator.userAccount", TopiaQuery.Op.EQ, (Object)user);
        long records = this.countByQuery(countQuery);
        pager.setRecords((int)records);
        TopiaQuery query = TopiaFilterPagerUtil.addPagerToQuery((TopiaQuery)countQuery, (TopiaFilterPagerUtil.FilterPagerBean)pager);
        List result = this.findAllByQuery(query);
        return result;
    }

    public List<Pair<Poll, PollAccount>> getInvitedPolls(TopiaFilterPagerUtil.FilterPagerBean pager, UserAccount userToUse) throws TopiaException {
        Preconditions.checkNotNull((Object)pager);
        Preconditions.checkNotNull((Object)userToUse);
        String email = userToUse.getEmail();
        TopiaQuery query = this.createQuery("p").setSelect(new String[]{"p", "l.pollAccount"}).addLeftJoin("p.votingList", "v", false).addLeftJoin("v.pollAccountPersonToList", "l", false).addEquals("l.pollAccount.email", new Object[]{email});
        List<Pair<Poll, PollAccount>> result = this.findAllWithPollAccounts(query, pager);
        return result;
    }

    public List<Pair<Poll, PollAccount>> getParticipatedPolls(TopiaFilterPagerUtil.FilterPagerBean pager, UserAccount userToUse) throws TopiaException {
        Preconditions.checkNotNull((Object)pager);
        Preconditions.checkNotNull((Object)userToUse);
        VoteDAO voteDao = PollenDAOHelper.getVoteDAO((TopiaContext)this.context);
        TopiaQuery query = voteDao.createQuery("e").addFrom(Poll.class, "p").addWhere("e in elements(p.vote)").setSelect(new String[]{"p", "e.pollAccount"}).addWhere("e.pollAccount.userAccount", TopiaQuery.Op.EQ, (Object)userToUse);
        List<Pair<Poll, PollAccount>> result = this.findAllWithPollAccounts(query, pager);
        return result;
    }

    protected List<Pair<Poll, PollAccount>> findAllWithPollAccounts(TopiaQuery query, TopiaFilterPagerUtil.FilterPagerBean pager) throws TopiaException {
        List queryResults = this.getContext().findByQuery(query);
        LinkedHashMap mapResult = Maps.newLinkedHashMap();
        for (Object[] row : queryResults) {
            Poll poll = (Poll)row[0];
            PollAccount pollAccount = (PollAccount)row[1];
            mapResult.put(poll, pollAccount);
        }
        long records = mapResult.size();
        pager.setRecords((int)records);
        TopiaFilterPagerUtil.computeRecordIndexesAndPagesNumber((PagerUtil.PagerBean)pager);
        LinkedList entries = Lists.newLinkedList(mapResult.entrySet());
        List result = Lists.transform((List)TopiaFilterPagerUtil.getPageFromList((List)entries, (TopiaFilterPagerUtil.FilterPagerBean)pager), PollenFunctions.MAP_ENTRY_TO_PAIR_FUNCTION);
        return result;
    }

    public List<E> getRunningPolls(boolean withEndDate) throws TopiaException {
        TopiaQuery query = withEndDate ? this.createQuery("poll").addWhere("poll.endDate is not null and poll.endDate > current_timestamp()").addWhere("poll.beginDate is null or poll.beginDate < current_timestamp()") : this.createQuery("poll").addWhere("poll.endDate is null or poll.endDate > current_timestamp()").addWhere("poll.beginDate is null or poll.beginDate < current_timestamp()");
        List results = this.findAllByQuery(query);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
        }
        return results;
    }
}

