/*
 * #%L
 * Pollen :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.entities.PollenDAOHelper.PollenEntityEnum;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class UserAccountDAOAbstract<E extends UserAccount> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)UserAccount.class;
    }

    @Override
    public PollenEntityEnum getTopiaEntityEnum() {
        return PollenEntityEnum.UserAccount;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<PersonList> list = getContext()
                                                    .getDAO(PersonList.class)
                                                    .findAllByProperties(PersonList.PROPERTY_OWNER, entity);
                                            for (PersonList item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getOwner())) {
                                                    item.setOwner(null);
                                                }
                        
                    }
                }

                                        {
                                        List<PollAccount> list = getContext()
                                                    .getDAO(PollAccount.class)
                                                    .findAllByProperties(PollAccount.PROPERTY_USER_ACCOUNT, entity);
                                            for (PollAccount item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getUserAccount())) {
                                                    item.setUserAccount(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByLogin(String v) throws TopiaException {
        E result = findByProperty(UserAccount.PROPERTY_LOGIN, v);
        return result;
    }

    public List<E> findAllByLogin(String v) throws TopiaException {
        List<E> result = findAllByProperty(UserAccount.PROPERTY_LOGIN, v);
        return result;
    }

    public E findByPassword(String v) throws TopiaException {
        E result = findByProperty(UserAccount.PROPERTY_PASSWORD, v);
        return result;
    }

    public List<E> findAllByPassword(String v) throws TopiaException {
        List<E> result = findAllByProperty(UserAccount.PROPERTY_PASSWORD, v);
        return result;
    }

    public E findByFirstName(String v) throws TopiaException {
        E result = findByProperty(UserAccount.PROPERTY_FIRST_NAME, v);
        return result;
    }

    public List<E> findAllByFirstName(String v) throws TopiaException {
        List<E> result = findAllByProperty(UserAccount.PROPERTY_FIRST_NAME, v);
        return result;
    }

    public E findByLastName(String v) throws TopiaException {
        E result = findByProperty(UserAccount.PROPERTY_LAST_NAME, v);
        return result;
    }

    public List<E> findAllByLastName(String v) throws TopiaException {
        List<E> result = findAllByProperty(UserAccount.PROPERTY_LAST_NAME, v);
        return result;
    }

    public E findByAdministrator(boolean v) throws TopiaException {
        E result = findByProperty(UserAccount.PROPERTY_ADMINISTRATOR, v);
        return result;
    }

    public List<E> findAllByAdministrator(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(UserAccount.PROPERTY_ADMINISTRATOR, v);
        return result;
    }

    public E findByLanguage(String v) throws TopiaException {
        E result = findByProperty(UserAccount.PROPERTY_LANGUAGE, v);
        return result;
    }

    public List<E> findAllByLanguage(String v) throws TopiaException {
        List<E> result = findAllByProperty(UserAccount.PROPERTY_LANGUAGE, v);
        return result;
    }

    public E findByEmail(String v) throws TopiaException {
        E result = findByProperty(UserAccount.PROPERTY_EMAIL, v);
        return result;
    }

    public List<E> findAllByEmail(String v) throws TopiaException {
        List<E> result = findAllByProperty(UserAccount.PROPERTY_EMAIL, v);
        return result;
    }

    public E findContainsFavoriteList(PersonList v) throws TopiaException {
        E result = findContains(UserAccount.PROPERTY_FAVORITE_LIST, v);
        return result;
    }

    public List<E> findAllContainsFavoriteList(PersonList v) throws TopiaException {
        List<E> result = findAllContains(UserAccount.PROPERTY_FAVORITE_LIST, v);
        return result;
    }

    public E findContainsPollAccount(PollAccount v) throws TopiaException {
        E result = findContains(UserAccount.PROPERTY_POLL_ACCOUNT, v);
        return result;
    }

    public List<E> findAllContainsPollAccount(PollAccount v) throws TopiaException {
        List<E> result = findAllContains(UserAccount.PROPERTY_POLL_ACCOUNT, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == PersonList.class) {
            PersonListDAO dao = (PersonListDAO)
                getContext().getDAO(PersonList.class);
            tmp = dao.findAllByOwner(entity);
            result.addAll(tmp);
        }

        if (type == PollAccount.class) {
            PollAccountDAO dao = (PollAccountDAO)
                getContext().getDAO(PollAccount.class);
            tmp = dao.findAllByUserAccount(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(PersonList.class, entity);
        if (!list.isEmpty()) {
            result.put(PersonList.class, list);
        }

        list = findUsages(PollAccount.class, entity);
        if (!list.isEmpty()) {
            result.put(PollAccount.class, list);
        }

        return result;
    }

} //UserAccountDAOAbstract<E extends UserAccount>
