package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.entities.PollenDAOHelper.PollenEntityEnum;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class CommentDAOAbstract<E extends Comment> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Comment.class;
    }

    @Override
    public PollenEntityEnum getTopiaEntityEnum() {
        return PollenEntityEnum.Comment;
    }

    public E findByText(String v) throws TopiaException {
        E result = findByProperty(Comment.PROPERTY_TEXT, v);
        return result;
    }

    public List<E> findAllByText(String v) throws TopiaException {
        List<E> result = findAllByProperty(Comment.PROPERTY_TEXT, v);
        return result;
    }

    public E findByPostDate(Date v) throws TopiaException {
        E result = findByProperty(Comment.PROPERTY_POST_DATE, v);
        return result;
    }

    public List<E> findAllByPostDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Comment.PROPERTY_POST_DATE, v);
        return result;
    }

    public E findByAuthor(String v) throws TopiaException {
        E result = findByProperty(Comment.PROPERTY_AUTHOR, v);
        return result;
    }

    public List<E> findAllByAuthor(String v) throws TopiaException {
        List<E> result = findAllByProperty(Comment.PROPERTY_AUTHOR, v);
        return result;
    }

    public E findByPoll(Poll v) throws TopiaException {
        E result = findByProperty(Comment.PROPERTY_POLL, v);
        return result;
    }

    public List<E> findAllByPoll(Poll v) throws TopiaException {
        List<E> result = findAllByProperty(Comment.PROPERTY_POLL, v);
        return result;
    }

    public E findByPollAccount(PollAccount v) throws TopiaException {
        E result = findByProperty(Comment.PROPERTY_POLL_ACCOUNT, v);
        return result;
    }

    public List<E> findAllByPollAccount(PollAccount v) throws TopiaException {
        List<E> result = findAllByProperty(Comment.PROPERTY_POLL_ACCOUNT, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Poll.class) {
            PollDAO dao = (PollDAO)
                getContext().getDAO(Poll.class);
            tmp = dao.findAllContainsComment(entity);
            result.addAll(tmp);
        }

        if (type == PollAccount.class) {
            PollAccountDAO dao = (PollAccountDAO)
                getContext().getDAO(PollAccount.class);
            tmp = dao.findAllContainsComment(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(Poll.class, entity);
        if (!list.isEmpty()) {
            result.put(Poll.class, list);
        }

        list = findUsages(PollAccount.class, entity);
        if (!list.isEmpty()) {
            result.put(PollAccount.class, list);
        }

        return result;
    }

} //CommentDAOAbstract<E extends Comment>
