/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.PollAbstract;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PreventRule;
import org.chorem.pollen.business.persistence.Result;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VotingList;

public class PollImpl
extends PollAbstract {
    private static final long serialVersionUID = 1L;

    @Override
    public List<Vote> getVote() {
        if (this.vote == null) {
            this.vote = Lists.newArrayList();
        }
        return this.vote;
    }

    @Override
    public List<Choice> getChoice() {
        if (this.choice == null) {
            this.choice = Lists.newArrayList();
        }
        return this.choice;
    }

    @Override
    public List<Result> getResult() {
        if (this.result == null) {
            this.result = Lists.newArrayList();
        }
        return this.result;
    }

    @Override
    public List<Comment> getComment() {
        if (this.comment == null) {
            this.comment = Lists.newArrayList();
        }
        return this.comment;
    }

    @Override
    public List<PreventRule> getPreventRule() {
        if (this.preventRule == null) {
            this.preventRule = Lists.newArrayList();
        }
        return this.preventRule;
    }

    @Override
    public List<VotingList> getVotingList() {
        if (this.votingList == null) {
            this.votingList = Lists.newArrayList();
        }
        return this.votingList;
    }

    @Override
    public Vote getVoteByPollAccount(PollAccount account) {
        Preconditions.checkNotNull((Object)account);
        Vote resultVote = null;
        if (!this.isVoteEmpty()) {
            for (Vote vote : this.getVote()) {
                if (!account.equals(vote.getPollAccount())) continue;
                resultVote = vote;
                break;
            }
        }
        return resultVote;
    }

    @Override
    public String getAdminId() {
        return this.getVoteId(this.getCreator());
    }

    @Override
    public String getVoteId(PollAccount account) {
        String voteId = this.getPollId();
        if (account != null) {
            voteId = voteId + ":" + account.getAccountId();
        }
        return voteId;
    }

    @Override
    public boolean isStarted(Date currentDate) {
        return this.beginDate == null || this.beginDate.before(currentDate);
    }

    @Override
    public boolean isRunning(Date currentDate) {
        return !this.isClosed() && this.isStarted(currentDate) && !this.isFinished(currentDate);
    }

    @Override
    public boolean isFinished(Date currentDate) {
        return this.endDate != null && currentDate.after(this.endDate);
    }

    @Override
    public boolean isAddChoiceStarted(Date currentDate) {
        return this.choiceAddAllowed && (this.beginChoiceDate == null || this.beginChoiceDate.before(currentDate));
    }

    @Override
    public boolean isAddChoiceRunning(Date currentDate) {
        return !this.isClosed() && !this.isFinished(currentDate) && this.isAddChoiceStarted(currentDate) && !this.isAddChoiceFinished(currentDate);
    }

    @Override
    public boolean isAddChoiceFinished(Date currentDate) {
        return !this.choiceAddAllowed || this.endChoiceDate != null && this.endChoiceDate.after(currentDate);
    }

    @Override
    public PreventRule getPreventRuleByScope(String scope) {
        Preconditions.checkNotNull((Object)scope);
        for (PreventRule value : this.getPreventRule()) {
            if (!scope.equals(value.getScope())) continue;
            return value;
        }
        return null;
    }

    @Override
    public PersonToList getPersonToListByVote(Vote vote) {
        Preconditions.checkNotNull((Object)vote);
        for (VotingList votingList : this.getVotingList()) {
            PersonToList result = votingList.getPollAccountPersonToList(vote.getPollAccount());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public List<PollAccount> getPollAccounts(boolean withNoVote) {
        LinkedList result = Lists.newLinkedList();
        for (VotingList votingList : this.getVotingList()) {
            for (PersonToList personToList : votingList.getPollAccountPersonToList()) {
                if (withNoVote && personToList.isHasVoted()) continue;
                result.add(personToList.getPollAccount());
            }
        }
        return result;
    }
}

