/*
 * #%L
 * Pollen :: Persistence
 * 
 * $Id: PersonToListDAOImpl.java 3395 2012-05-28 15:34:46Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1/pollen-persistence/src/main/java/org/chorem/pollen/business/persistence/PersonToListDAOImpl.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import java.util.List;

/**
 * Created: 28/03/12
 *
 * @author fdesbois <desbois@codelutin.com>
 *         $Id: PersonToListDAOImpl.java 3395 2012-05-28 15:34:46Z tchemit $
 */
public class PersonToListDAOImpl<E extends PersonToList> extends PersonToListDAOAbstract<E> {

    public PersonToList findByPollAndAccount(Poll poll, PollAccount account) {

//        TopiaQuery query = createQuery("e")
//                .addFrom(Poll.class, "p")
//                .addFrom(VotingList.class, "v")
//                .addEquals("p", poll)
//                .addInElements("v", "p." + Poll.PROPERTY_VOTING_LIST)
//                .addWhere("e." + PersonToList.PROPERTY_VOTING_LIST + " = v." + VotingList.PROPERTY_POLL_ACCOUNT_PERSON_TO_LIST)
//                .addEquals("e." + PersonToList.PROPERTY_POLL_ACCOUNT, account);

        PersonToList result;
        List<VotingList> votingLists = poll.getVotingList();
        for (VotingList votingList : votingLists) {
            result = votingList.getPollAccountPersonToList(account);
            if (result != null) {
                return result;
            }
        }
        return null;
    }
    
}
