/*
 * #%L
 * Pollen :: Persistence
 * 
 * $Id: PollenConfigurationOption.java 3349 2012-05-02 11:16:10Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1/pollen-persistence/src/main/java/org/chorem/pollen/PollenConfigurationOption.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen;

import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.common.VoteCountingType;
import org.hibernate.dialect.H2Dialect;
import org.nuiton.util.ApplicationConfig;

import java.io.File;
import java.net.URL;

import static org.nuiton.i18n.I18n.n_;

/**
 * All Pollen configuration options.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public enum PollenConfigurationOption implements ApplicationConfig.OptionDef {

    /** login for default admin. */
    APPLICATION_URL("siteUrl", n_("pollen.configuration.siteUrl"), "", URL.class),
    /** login for default admin. */
    DATA_DIR("pollen.dataDirectory", n_("pollen.configuration.dataDirectory"), "/var/local/pollen/data", File.class),
    /** login for default admin. */
    ADMIN_LOGIN("adminLogin", n_("pollen.configuration.db.login"), "admin", String.class),
    /** password for default admin. */
    ADMIN_PASSWORD("adminPassword", n_("pollen.configuration.db.password"), "pollen", String.class),
    /** email for default admin. */
    ADMIN_EMAIL("adminEmail", n_("pollen.configuration.adminEmail"), "admin@domain.com", String.class),
    /** email for contact link. */
    CONTACT_EMAIL("contactEmail", n_("pollen.configuration.contactEmail"), "", String.class),
    /** host for email sending configuration. */
    EMAIL_HOST("email_host", n_("pollen.configuration.emailHost"), "smtp", String.class),
    /** port for email sending configuration. */
    EMAIL_PORT("email_port", n_("pollen.configuration.emailPort"), "25", String.class),
    /** from for email sending configuration. */
    EMAIL_FROM("email_from", n_("pollen.configuration.emailFrom"), "bot@pollen.org", String.class),
    /** directory to store emails before sending them. */
    EMAIL_DIR("pollen.emails.directory", n_("pollen.configuration.emaiDirectory"), "${pollen.dataDirectory}/emails", File.class),
    /** path for feed directory. */
    FEED_DIR("feedDir", n_("pollen.configuration.feedDirectory"), "${pollen.dataDirectory}/feeds", File.class),
    /** path for uploaded images directory. */
    IMG_DIR("upImgDir", n_("pollen.configuration.imageDirectory"), "${pollen.dataDirectory}/uploadedImages", File.class),
    /** nb votes to display per page. */
    NB_VOTES_PER_PAGE("pollen.ui.nbVotesPerPage", n_("pollen.configuration.nbVoteByPage"), "25", int.class),
    /** Charset of Pollen. */
    CHARSET("pollen.charset", n_("pollen.configuration.charset"), "UTF-8", String.class),

    /** Default poll type to use at a new poll creation. */
    DEFAULT_POLL_TYPE("pollen.default.pollType", n_("pollen.configuration.defaultPollType"), PollType.FREE.name(), PollType.class),
    /** Default vote counting type to use at a new poll creation. */
    DEFAULT_VOTE_COUNTING_TYPE("pollen.default.voteCountingType", n_("pollen.configuration.defaultVoteCountingType"), VoteCountingType.NORMAL.name(), VoteCountingType.class),

    /** Default choice type to use at a new poll creation. */
    DEFAULT_CHOICE_TYPE("pollen.default.choiceType", n_("pollen.configuration.defaultChoiceType"), ChoiceType.TEXT.name(), ChoiceType.class),

    /** db driver. */
    DB_DRIVER("hibernate.connection.driver_class", n_("pollen.configuration.dbDriver"), org.h2.Driver.class.getName(), Class.class),

    /** db dialect. */
    DB_DIALECT("hibernate.dialect", n_("pollen.configuration.dbDialect"), H2Dialect.class.getName(), Class.class),

    /** db url. */
    DB_URL("hibernate.connection.url", n_("pollen.configuration.dbUrl"), "jdbc:h2:file:${pollen.dataDirectory}/db/pollendb", String.class),

    /** login to db. */
    DB_LOGIN("hibernate.connection.username", n_("pollen.configuration.dbLogin"), "sa", String.class),

    /** passowrd to db. */
    DB_PASSWORD("hibernate.connection.password", n_("pollen.configuration.dbPassword"), "", String.class);

    /** Configuration key. */
    protected final String key;

    /** I18n key of option description */
    protected final String description;

    /** Type of option */
    protected final Class<?> type;

    /** Default value of option. */
    protected String defaultValue;

    PollenConfigurationOption(String key,
                              String description,
                              String defaultValue,
                              Class<?> type) {
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this.type = type;
    }

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public Class<?> getType() {
        return type;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public String getDefaultValue() {
        return defaultValue;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void setTransient(boolean newValue) {
        // not used
    }

    @Override
    public void setFinal(boolean newValue) {
        // not used
    }
}
