/*
 * #%L
 * Pollen :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.entities;

import java.util.HashMap;
import java.util.Map;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PreventRule;
import org.chorem.pollen.business.persistence.Result;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteToChoice;
import org.chorem.pollen.business.persistence.VotingList;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.persistence.TopiaEntity;

public class PollenQueryHelper {
    public static abstract class EntityProperty<E> {

            protected String alias;

            protected Map<String, String> propertiesCache;

            public EntityProperty()         {
            propertiesCache = new HashMap<String, String>();
            }

            protected void setAlias(String alias)         {
            this.alias = alias;
            }

            public String $alias()         {
            return alias;
            }

            public String $property(String propertyName)         {
            String result = propertiesCache.get(propertyName);
            if (result == null) {
                result = TopiaQuery.getProperty(alias, propertyName);
                propertiesCache.put(propertyName, result);
            }
            return result;
            }

            public String topiaCreateDate()         {
            return $property(TopiaEntity.TOPIA_CREATE_DATE);
            }

            public String topiaId()         {
            return $property(TopiaEntity.TOPIA_ID);
            }

            public String topiaVersion()         {
            return $property(TopiaEntity.TOPIA_VERSION);
            }

            public abstract Class<E> getEntityClass();

            public abstract String defaultAlias();

        } //EntityProperty<E>
        public static class VoteProperty extends EntityProperty<Vote> {

                protected VoteProperty()             {
                }

                @Override
                public Class<Vote> getEntityClass()             {
            return Vote.class;
                }

                @Override
                public String defaultAlias()             {
            return ALIAS_VOTE;
                }

                public String weight()             {
            return $property(Vote.PROPERTY_WEIGHT);
                }

                public String comment()             {
            return $property(Vote.PROPERTY_COMMENT);
                }

                public String anonymous()             {
            return $property(Vote.PROPERTY_ANONYMOUS);
                }

                public String choiceVoteToChoice()             {
            return $property(Vote.PROPERTY_CHOICE_VOTE_TO_CHOICE);
                }

                public VoteToChoiceProperty choiceVoteToChoiceProperty()             {
            return newVoteToChoiceProperty(choiceVoteToChoice());
                }

                public String poll()             {
            return $property(Vote.PROPERTY_POLL);
                }

                public PollProperty pollProperty()             {
            return newPollProperty(poll());
                }

                public String pollAccount()             {
            return $property(Vote.PROPERTY_POLL_ACCOUNT);
                }

                public PollAccountProperty pollAccountProperty()             {
            return newPollAccountProperty(pollAccount());
                }

                public String votingList()             {
            return $property(Vote.PROPERTY_VOTING_LIST);
                }

                public VotingListProperty votingListProperty()             {
            return newVotingListProperty(votingList());
                }

            } //VoteProperty
            public static class UserAccountProperty extends EntityProperty<UserAccount> {

                    protected UserAccountProperty()                 {
                    }

                    @Override
                    public Class<UserAccount> getEntityClass()                 {
            return UserAccount.class;
                    }

                    @Override
                    public String defaultAlias()                 {
            return ALIAS_USER_ACCOUNT;
                    }

                    public String login()                 {
            return $property(UserAccount.PROPERTY_LOGIN);
                    }

                    public String password()                 {
            return $property(UserAccount.PROPERTY_PASSWORD);
                    }

                    public String firstName()                 {
            return $property(UserAccount.PROPERTY_FIRST_NAME);
                    }

                    public String lastName()                 {
            return $property(UserAccount.PROPERTY_LAST_NAME);
                    }

                    public String administrator()                 {
            return $property(UserAccount.PROPERTY_ADMINISTRATOR);
                    }

                    public String language()                 {
            return $property(UserAccount.PROPERTY_LANGUAGE);
                    }

                    public String email()                 {
            return $property(UserAccount.PROPERTY_EMAIL);
                    }

                    public String favoriteList()                 {
            return $property(UserAccount.PROPERTY_FAVORITE_LIST);
                    }

                    public String pollAccount()                 {
            return $property(UserAccount.PROPERTY_POLL_ACCOUNT);
                    }

                } //UserAccountProperty
                public static class PersonToListProperty extends EntityProperty<PersonToList> {

                        protected PersonToListProperty()                     {
                        }

                        @Override
                        public Class<PersonToList> getEntityClass()                     {
            return PersonToList.class;
                        }

                        @Override
                        public String defaultAlias()                     {
            return ALIAS_PERSON_TO_LIST;
                        }

                        public String weight()                     {
            return $property(PersonToList.PROPERTY_WEIGHT);
                        }

                        public String hasVoted()                     {
            return $property(PersonToList.PROPERTY_HAS_VOTED);
                        }

                        public String votingList()                     {
            return $property(PersonToList.PROPERTY_VOTING_LIST);
                        }

                        public PersonToListProperty votingListPersonToListProperty()                     {
            return newPersonToListProperty(votingList());
                        }

                        public String pollAccount()                     {
            return $property(PersonToList.PROPERTY_POLL_ACCOUNT);
                        }

                        public PersonToListProperty pollAccountPersonToListProperty()                     {
            return newPersonToListProperty(pollAccount());
                        }

                    } //PersonToListProperty
                    public static class PreventRuleProperty extends EntityProperty<PreventRule> {

                            protected PreventRuleProperty()                         {
                            }

                            @Override
                            public Class<PreventRule> getEntityClass()                         {
            return PreventRule.class;
                            }

                            @Override
                            public String defaultAlias()                         {
            return ALIAS_PREVENT_RULE;
                            }

                            public String scope()                         {
            return $property(PreventRule.PROPERTY_SCOPE);
                            }

                            public String sensibility()                         {
            return $property(PreventRule.PROPERTY_SENSIBILITY);
                            }

                            public String repeated()                         {
            return $property(PreventRule.PROPERTY_REPEATED);
                            }

                            public String active()                         {
            return $property(PreventRule.PROPERTY_ACTIVE);
                            }

                            public String oneTime()                         {
            return $property(PreventRule.PROPERTY_ONE_TIME);
                            }

                            public String method()                         {
            return $property(PreventRule.PROPERTY_METHOD);
                            }

                            public String poll()                         {
            return $property(PreventRule.PROPERTY_POLL);
                            }

                            public PollProperty pollProperty()                         {
            return newPollProperty(poll());
                            }

                        } //PreventRuleProperty
                        public static class ChoiceProperty extends EntityProperty<Choice> {

                                protected ChoiceProperty()                             {
                                }

                                @Override
                                public Class<Choice> getEntityClass()                             {
            return Choice.class;
                                }

                                @Override
                                public String defaultAlias()                             {
            return ALIAS_CHOICE;
                                }

                                public String name()                             {
            return $property(Choice.PROPERTY_NAME);
                                }

                                public String description()                             {
            return $property(Choice.PROPERTY_DESCRIPTION);
                                }

                                public String validate()                             {
            return $property(Choice.PROPERTY_VALIDATE);
                                }

                                public String voteVoteToChoice()                             {
            return $property(Choice.PROPERTY_VOTE_VOTE_TO_CHOICE);
                                }

                                public VoteToChoiceProperty voteVoteToChoiceProperty()                             {
            return newVoteToChoiceProperty(voteVoteToChoice());
                                }

                            } //ChoiceProperty
                            public static class VoteToChoiceProperty extends EntityProperty<VoteToChoice> {

                                    protected VoteToChoiceProperty()                                 {
                                    }

                                    @Override
                                    public Class<VoteToChoice> getEntityClass()                                 {
            return VoteToChoice.class;
                                    }

                                    @Override
                                    public String defaultAlias()                                 {
            return ALIAS_VOTE_TO_CHOICE;
                                    }

                                    public String voteValue()                                 {
            return $property(VoteToChoice.PROPERTY_VOTE_VALUE);
                                    }

                                    public String vote()                                 {
            return $property(VoteToChoice.PROPERTY_VOTE);
                                    }

                                    public VoteToChoiceProperty voteVoteToChoiceProperty()                                 {
            return newVoteToChoiceProperty(vote());
                                    }

                                    public String choice()                                 {
            return $property(VoteToChoice.PROPERTY_CHOICE);
                                    }

                                    public VoteToChoiceProperty choiceVoteToChoiceProperty()                                 {
            return newVoteToChoiceProperty(choice());
                                    }

                                } //VoteToChoiceProperty
                                public static class ResultProperty extends EntityProperty<Result> {

                                        protected ResultProperty()                                     {
                                        }

                                        @Override
                                        public Class<Result> getEntityClass()                                     {
            return Result.class;
                                        }

                                        @Override
                                        public String defaultAlias()                                     {
            return ALIAS_RESULT;
                                        }

                                        public String name()                                     {
            return $property(Result.PROPERTY_NAME);
                                        }

                                        public String resultValue()                                     {
            return $property(Result.PROPERTY_RESULT_VALUE);
                                        }

                                        public String byGroup()                                     {
            return $property(Result.PROPERTY_BY_GROUP);
                                        }

                                        public String poll()                                     {
            return $property(Result.PROPERTY_POLL);
                                        }

                                        public PollProperty pollProperty()                                     {
            return newPollProperty(poll());
                                        }

                                        public String voteCountingType()                                     {
            return $property(Result.PROPERTY_VOTE_COUNTING_TYPE);
                                        }

                                    } //ResultProperty
                                    public static class VotingListProperty extends EntityProperty<VotingList> {

                                            protected VotingListProperty()                                         {
                                            }

                                            @Override
                                            public Class<VotingList> getEntityClass()                                         {
            return VotingList.class;
                                            }

                                            @Override
                                            public String defaultAlias()                                         {
            return ALIAS_VOTING_LIST;
                                            }

                                            public String name()                                         {
            return $property(VotingList.PROPERTY_NAME);
                                            }

                                            public String weight()                                         {
            return $property(VotingList.PROPERTY_WEIGHT);
                                            }

                                            public String pollAccountPersonToList()                                         {
            return $property(VotingList.PROPERTY_POLL_ACCOUNT_PERSON_TO_LIST);
                                            }

                                            public PersonToListProperty pollAccountPersonToListProperty()                                         {
            return newPersonToListProperty(pollAccountPersonToList());
                                            }

                                            public String poll()                                         {
            return $property(VotingList.PROPERTY_POLL);
                                            }

                                            public PollProperty pollProperty()                                         {
            return newPollProperty(poll());
                                            }

                                            public String vote()                                         {
            return $property(VotingList.PROPERTY_VOTE);
                                            }

                                            public VoteProperty voteProperty()                                         {
            return newVoteProperty(vote());
                                            }

                                        } //VotingListProperty
                                        public static class PollAccountProperty extends EntityProperty<PollAccount> {

                                                protected PollAccountProperty()                                             {
                                                }

                                                @Override
                                                public Class<PollAccount> getEntityClass()                                             {
            return PollAccount.class;
                                                }

                                                @Override
                                                public String defaultAlias()                                             {
            return ALIAS_POLL_ACCOUNT;
                                                }

                                                public String accountId()                                             {
            return $property(PollAccount.PROPERTY_ACCOUNT_ID);
                                                }

                                                public String votingId()                                             {
            return $property(PollAccount.PROPERTY_VOTING_ID);
                                                }

                                                public String email()                                             {
            return $property(PollAccount.PROPERTY_EMAIL);
                                                }

                                                public String votingListPersonToList()                                             {
            return $property(PollAccount.PROPERTY_VOTING_LIST_PERSON_TO_LIST);
                                                }

                                                public PersonToListProperty votingListPersonToListProperty()                                             {
            return newPersonToListProperty(votingListPersonToList());
                                                }

                                                public String pollsCreated()                                             {
            return $property(PollAccount.PROPERTY_POLLS_CREATED);
                                                }

                                                public String comment()                                             {
            return $property(PollAccount.PROPERTY_COMMENT);
                                                }

                                                public String vote()                                             {
            return $property(PollAccount.PROPERTY_VOTE);
                                                }

                                                public String personList()                                             {
            return $property(PollAccount.PROPERTY_PERSON_LIST);
                                                }

                                                public PersonListProperty personListProperty()                                             {
            return newPersonListProperty(personList());
                                                }

                                                public String userAccount()                                             {
            return $property(PollAccount.PROPERTY_USER_ACCOUNT);
                                                }

                                                public UserAccountProperty userAccountProperty()                                             {
            return newUserAccountProperty(userAccount());
                                                }

                                            } //PollAccountProperty
                                            public static class PollProperty extends EntityProperty<Poll> {

                                                    protected PollProperty()                                                 {
                                                    }

                                                    @Override
                                                    public Class<Poll> getEntityClass()                                                 {
            return Poll.class;
                                                    }

                                                    @Override
                                                    public String defaultAlias()                                                 {
            return ALIAS_POLL;
                                                    }

                                                    public String pollId()                                                 {
            return $property(Poll.PROPERTY_POLL_ID);
                                                    }

                                                    public String title()                                                 {
            return $property(Poll.PROPERTY_TITLE);
                                                    }

                                                    public String description()                                                 {
            return $property(Poll.PROPERTY_DESCRIPTION);
                                                    }

                                                    public String beginChoiceDate()                                                 {
            return $property(Poll.PROPERTY_BEGIN_CHOICE_DATE);
                                                    }

                                                    public String beginDate()                                                 {
            return $property(Poll.PROPERTY_BEGIN_DATE);
                                                    }

                                                    public String endDate()                                                 {
            return $property(Poll.PROPERTY_END_DATE);
                                                    }

                                                    public String maxChoiceNb()                                                 {
            return $property(Poll.PROPERTY_MAX_CHOICE_NB);
                                                    }

                                                    public String closed()                                                 {
            return $property(Poll.PROPERTY_CLOSED);
                                                    }

                                                    public String choiceAddAllowed()                                                 {
            return $property(Poll.PROPERTY_CHOICE_ADD_ALLOWED);
                                                    }

                                                    public String anonymousVoteAllowed()                                                 {
            return $property(Poll.PROPERTY_ANONYMOUS_VOTE_ALLOWED);
                                                    }

                                                    public String anonymous()                                                 {
            return $property(Poll.PROPERTY_ANONYMOUS);
                                                    }

                                                    public String publicResults()                                                 {
            return $property(Poll.PROPERTY_PUBLIC_RESULTS);
                                                    }

                                                    public String continuousResults()                                                 {
            return $property(Poll.PROPERTY_CONTINUOUS_RESULTS);
                                                    }

                                                    public String endChoiceDate()                                                 {
            return $property(Poll.PROPERTY_END_CHOICE_DATE);
                                                    }

                                                    public String vote()                                                 {
            return $property(Poll.PROPERTY_VOTE);
                                                    }

                                                    public String choice()                                                 {
            return $property(Poll.PROPERTY_CHOICE);
                                                    }

                                                    public String result()                                                 {
            return $property(Poll.PROPERTY_RESULT);
                                                    }

                                                    public String creator()                                                 {
            return $property(Poll.PROPERTY_CREATOR);
                                                    }

                                                    public PollAccountProperty creatorProperty()                                                 {
            return newPollAccountProperty(creator());
                                                    }

                                                    public String comment()                                                 {
            return $property(Poll.PROPERTY_COMMENT);
                                                    }

                                                    public String preventRule()                                                 {
            return $property(Poll.PROPERTY_PREVENT_RULE);
                                                    }

                                                    public String votingList()                                                 {
            return $property(Poll.PROPERTY_VOTING_LIST);
                                                    }

                                                    public String pollType()                                                 {
            return $property(Poll.PROPERTY_POLL_TYPE);
                                                    }

                                                    public String choiceType()                                                 {
            return $property(Poll.PROPERTY_CHOICE_TYPE);
                                                    }

                                                    public String voteCountingType()                                                 {
            return $property(Poll.PROPERTY_VOTE_COUNTING_TYPE);
                                                    }

                                                } //PollProperty
                                                public static class CommentProperty extends EntityProperty<Comment> {

                                                        protected CommentProperty()                                                     {
                                                        }

                                                        @Override
                                                        public Class<Comment> getEntityClass()                                                     {
            return Comment.class;
                                                        }

                                                        @Override
                                                        public String defaultAlias()                                                     {
            return ALIAS_COMMENT;
                                                        }

                                                        public String text()                                                     {
            return $property(Comment.PROPERTY_TEXT);
                                                        }

                                                        public String postDate()                                                     {
            return $property(Comment.PROPERTY_POST_DATE);
                                                        }

                                                        public String author()                                                     {
            return $property(Comment.PROPERTY_AUTHOR);
                                                        }

                                                        public String poll()                                                     {
            return $property(Comment.PROPERTY_POLL);
                                                        }

                                                        public PollProperty pollProperty()                                                     {
            return newPollProperty(poll());
                                                        }

                                                        public String pollAccount()                                                     {
            return $property(Comment.PROPERTY_POLL_ACCOUNT);
                                                        }

                                                        public PollAccountProperty pollAccountProperty()                                                     {
            return newPollAccountProperty(pollAccount());
                                                        }

                                                    } //CommentProperty
                                                    public static class PersonListProperty extends EntityProperty<PersonList> {

                                                            protected PersonListProperty()                                                         {
                                                            }

                                                            @Override
                                                            public Class<PersonList> getEntityClass()                                                         {
            return PersonList.class;
                                                            }

                                                            @Override
                                                            public String defaultAlias()                                                         {
            return ALIAS_PERSON_LIST;
                                                            }

                                                            public String name()                                                         {
            return $property(PersonList.PROPERTY_NAME);
                                                            }

                                                            public String owner()                                                         {
            return $property(PersonList.PROPERTY_OWNER);
                                                            }

                                                            public UserAccountProperty ownerProperty()                                                         {
            return newUserAccountProperty(owner());
                                                            }

                                                            public String pollAccount()                                                         {
            return $property(PersonList.PROPERTY_POLL_ACCOUNT);
                                                            }

                                                        } //PersonListProperty

    public static final String ALIAS_VOTE = "V";

    public static final String ALIAS_USER_ACCOUNT = "UA";

    public static final String ALIAS_PERSON_TO_LIST = "PTL";

    public static final String ALIAS_PREVENT_RULE = "PR";

    public static final String ALIAS_CHOICE = "C";

    public static final String ALIAS_VOTE_TO_CHOICE = "VTC";

    public static final String ALIAS_RESULT = "R";

    public static final String ALIAS_VOTING_LIST = "VL";

    public static final String ALIAS_POLL_ACCOUNT = "PA";

    public static final String ALIAS_POLL = "P";

    public static final String ALIAS_COMMENT = "CO";

    public static final String ALIAS_PERSON_LIST = "PL";

    public static TopiaQuery createQuery(EntityProperty property) {
        return new TopiaQuery((Class<? extends TopiaEntity>)property.getEntityClass(), property.$alias());
    }

    public static String format(String statement, String... propertyNames) {
        for (int i = 1; i <= propertyNames.length; i++) {
           statement = statement.replace("$" + i, propertyNames[i-1]);
        }
        return statement;
    }

    private static <P extends EntityProperty> P newEntityProperty(Class<P> propertyClass) {
        return newEntityProperty(propertyClass, null);
    }

    private static <P extends EntityProperty> P newEntityProperty(Class<P> propertyClass, String alias) {
        try {
            P property = propertyClass.newInstance();
            if (alias == null) {
                alias = property.defaultAlias();
            }
            property.setAlias(alias);
            return property;
        } catch (Exception eee) {
    
            throw new Error("Error instantiate " + propertyClass.getName(), eee);
    
        }
    }

    public static VoteProperty newVoteProperty() {
        return newVoteProperty(null);
    }

    public static VoteProperty newVoteProperty(String alias) {
        return newEntityProperty(VoteProperty.class, alias);
    }

    public static UserAccountProperty newUserAccountProperty() {
        return newUserAccountProperty(null);
    }

    public static UserAccountProperty newUserAccountProperty(String alias) {
        return newEntityProperty(UserAccountProperty.class, alias);
    }

    public static PersonToListProperty newPersonToListProperty() {
        return newPersonToListProperty(null);
    }

    public static PersonToListProperty newPersonToListProperty(String alias) {
        return newEntityProperty(PersonToListProperty.class, alias);
    }

    public static PreventRuleProperty newPreventRuleProperty() {
        return newPreventRuleProperty(null);
    }

    public static PreventRuleProperty newPreventRuleProperty(String alias) {
        return newEntityProperty(PreventRuleProperty.class, alias);
    }

    public static ChoiceProperty newChoiceProperty() {
        return newChoiceProperty(null);
    }

    public static ChoiceProperty newChoiceProperty(String alias) {
        return newEntityProperty(ChoiceProperty.class, alias);
    }

    public static VoteToChoiceProperty newVoteToChoiceProperty() {
        return newVoteToChoiceProperty(null);
    }

    public static VoteToChoiceProperty newVoteToChoiceProperty(String alias) {
        return newEntityProperty(VoteToChoiceProperty.class, alias);
    }

    public static ResultProperty newResultProperty() {
        return newResultProperty(null);
    }

    public static ResultProperty newResultProperty(String alias) {
        return newEntityProperty(ResultProperty.class, alias);
    }

    public static VotingListProperty newVotingListProperty() {
        return newVotingListProperty(null);
    }

    public static VotingListProperty newVotingListProperty(String alias) {
        return newEntityProperty(VotingListProperty.class, alias);
    }

    public static PollAccountProperty newPollAccountProperty() {
        return newPollAccountProperty(null);
    }

    public static PollAccountProperty newPollAccountProperty(String alias) {
        return newEntityProperty(PollAccountProperty.class, alias);
    }

    public static PollProperty newPollProperty() {
        return newPollProperty(null);
    }

    public static PollProperty newPollProperty(String alias) {
        return newEntityProperty(PollProperty.class, alias);
    }

    public static CommentProperty newCommentProperty() {
        return newCommentProperty(null);
    }

    public static CommentProperty newCommentProperty(String alias) {
        return newEntityProperty(CommentProperty.class, alias);
    }

    public static PersonListProperty newPersonListProperty() {
        return newPersonListProperty(null);
    }

    public static PersonListProperty newPersonListProperty(String alias) {
        return newEntityProperty(PersonListProperty.class, alias);
    }

} //PollenQueryHelper
