package org.chorem.lima.ui.opening;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class OpeningView extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJVVTU8TQRierrRQPi0oYkSDSri5xcSTEEUgBEgVI8agvTjdHduB6c44O2uXi/En+BP07sXEmyfjwbMHL8a/YIwHr8Z3dpftbtnGpUmn7fvxvB87z9N3P1HRlejyPvZ9U3qOom1ibt/Z29tp7BNLrRPXklQoLlH4KhjIqKMRO7a7Cl2t13R6NUqvrvG24A5xEtlLNTTsqkNG3BYhSqGL6QzLdau7sXvJF548Qo2bykJ98/uX8dp+9dZAyBfQ3TiMMve/rO4kAzVkUFuhSaj0AlcZdprQhqROE/od07Y1hl33Hm6T5+glGqyhksASwBS6kn/kACPI94VCY1wQByqsU8x4U6EFLpum1eKStE1G29j0qBmFmDvh5yNKOkIEECWFBlvYsRmRCl3Ll7oZxicQ5h/iBiOLCs2kduV2dGbg05Hl3oTr+mdFHxOxa5TaMDVVh1sWd2CTeml+hLRdww3CdOBkHF8U2CGsN/C+NqYDRzuEWbxNYoxpfZxLFIaNS7XqKaULT6XwQmtPArYsDpO6utMYsFtwHOaQhw3OD/pFVJ5R18JMEEm53S9oaD4cezH2dZdVsrBjhdNcSnsMfpC0SnQh9WSAH2aXH90LXKijovTADI+yfpxSD8AVkmmmh0waMPD+nZ769vHHh40jBo1A7bOZoQkBgJstJNw0qaguPRHSx1OUVe9isVRHZZcwUI9AHWYzGtuN3NAc1KvodFOnm5vYbQFEcfD7p8/TT7+eQsYGGmYc2xtYx2+hsmpJ2AJnti9urwQdjXaG4DwNbwPuF9xFBisaDQgRsQHMbW5juHYDSnrEh4XMZiwk7qpR/vJnavf9ytFSCtDk+b7h3cUUn6ASdRh1SCAskWZkCsmIcIln8642ZKkF6pULEZF4MThvHFtAASakARFjXprCafqeDr8ZTKK/LaMe4p4A94hFfXGTNMuPG7JvVbOvH3IPQfNjT4S8fUyw7At+nNt58BXx4b/gTPKumZFuZe4mqWn58adS+KHuZT/ShCTmh59MwVuMu5nNR+KVH7eSwnXAlgULypcDssTwIYe50PiyjRWea1DHBtRbxxAL+hw+wfDLIWHnsII//oanSB/MBcD8B1J0l3QtCQAA";
    private static final Log log = LogFactory.getLog(OpeningView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel accountsIcon;
    protected JButton cancel;
    protected JLabel entrybooksIcon;
    protected JLabel fiscalperiodsIcon;
    protected OpeningViewHandler handler;
    protected JLabel identityIcon;
    protected JButton importButton;
    protected JButton ok;
    protected OpeningView openingDialog = this;
    protected JPanel panel;
    protected JLabel welcomeLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        protected void performNext() {
            dispose();
        }
        protected void performCancel() {
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public OpeningView(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Dialog param0) {
        super(param0);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView() {
        $initialize();
    }

    public OpeningView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Frame param0) {
        super(param0);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Window param0) {
        super(param0);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__importButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.importSave();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.next();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getAccountsIcon() {
        return accountsIcon;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JLabel getEntrybooksIcon() {
        return entrybooksIcon;
    }

    public JLabel getFiscalperiodsIcon() {
        return fiscalperiodsIcon;
    }

    public OpeningViewHandler getHandler() {
        return handler;
    }

    public JLabel getIdentityIcon() {
        return identityIcon;
    }

    public JButton getImportButton() {
        return importButton;
    }

    public JButton getOk() {
        return ok;
    }

    public JPanel getPanel() {
        return panel;
    }

    public JLabel getWelcomeLabel() {
        return welcomeLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToOpeningDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0);
    }

    protected void addChildrenToPanel() {
        if (!allComponentsCreated) {
            return;
        }
        panel.add(welcomeLabel);
        panel.add(importButton);
    }

    protected void createAccountsIcon() {
        $objectMap.put("accountsIcon", accountsIcon = new JLabel());
        
        accountsIcon.setName("accountsIcon");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.opening.close"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createEntrybooksIcon() {
        $objectMap.put("entrybooksIcon", entrybooksIcon = new JLabel());
        
        entrybooksIcon.setName("entrybooksIcon");
    }

    protected void createFiscalperiodsIcon() {
        $objectMap.put("fiscalperiodsIcon", fiscalperiodsIcon = new JLabel());
        
        fiscalperiodsIcon.setName("fiscalperiodsIcon");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new OpeningViewHandler(this));
    }

    protected void createIdentityIcon() {
        $objectMap.put("identityIcon", identityIcon = new JLabel());
        
        identityIcon.setName("identityIcon");
    }

    protected void createImportButton() {
        $objectMap.put("importButton", importButton = new JButton());
        
        importButton.setName("importButton");
        importButton.setText(t("lima.opening.import"));
        importButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importButton"));
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.opening.next"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createPanel() {
        $objectMap.put("panel", panel = new JPanel());
        
        panel.setName("panel");
    }

    protected void createWelcomeLabel() {
        $objectMap.put("welcomeLabel", welcomeLabel = new JLabel());
        
        welcomeLabel.setName("welcomeLabel");
        welcomeLabel.setText(t("lima.opening.welcome"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToOpeningDialog();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.9, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel0, new GridBagConstraints(0, 1, 1, 1, 0.8, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cancel, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ok, new GridBagConstraints(2, 1, 1, 1, 0.1, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(identityIcon, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(panel, new GridBagConstraints(1, 0, 1, 4, 0.9, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(accountsIcon, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(entrybooksIcon, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(fiscalperiodsIcon, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToPanel();
        
        // apply 5 property setters
        identityIcon.setIcon(SwingUtil.createImageIcon("identity.png"));
        accountsIcon.setIcon(SwingUtil.createImageIcon("accounts.png"));
        entrybooksIcon.setIcon(SwingUtil.createImageIcon("entryBooks.png"));
        fiscalperiodsIcon.setIcon(SwingUtil.createImageIcon("fiscalYears.png"));
        // late initializer
        openingDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("openingDialog", openingDialog);
        createHandler();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createIdentityIcon();
        createPanel();
        createWelcomeLabel();
        createImportButton();
        createAccountsIcon();
        createEntrybooksIcon();
        createFiscalperiodsIcon();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t(""));
        createCancel();
        createOk();
        // inline creation of openingDialog
        setName("openingDialog");
        openingDialog.getContentPane().setLayout(new BorderLayout());
        setTitle(t("lima.opening"));
        setModal(true);
        
        getRootPane().setDefaultButton(ok);$completeSetup();
    }

}