package org.chorem.lima.ui.opening;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.enums.AccountsChartEnum;
import static org.nuiton.i18n.I18n.t;

public class CreateAccountsPanel extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1UQU8TQRgdSlsoSFAJWBWMIh48uPXOQaAsAinQUGKMvTi7O6FLtrvjzGxZYzT+BH+C3r2YePNkPHj24MX4F4zx4NX4zWx3t4VBGuIeNu1+877vfW/f27c/UIEzdOMAR5HBQl+4bWJsLj98uGMdEFusEm4zl4qAofgayqFcE4076XMu0M1mTcIrXXilGrRp4BO/B71YQ2NcPPUIbxEiBJrrR9icVxppeTGiIUu6pqR0XV//+pl75bx8k0MoosCuBKtcPw2VbZKvoZzrCHQRJnVwxcP+PtBgrr8PfCfks6qHOd/GbfIEvUAjNVSkmEEzgeYHX1n1UPiICjS6sFnHPvHuCmQEbN+wWwEjbcNz29gIXSOgxIf5RpURLMiybQcwgSsEpapLUaBxKxQi8O+zIISO830L80MJl29wJTuUQUcW9rDlEZhe1sBUTZ4spYAJ3OVQwxbxQCspS5SMUQ/lyckUUOKwkSA+cdSMnsO72HGDmFU/JG9hrsZeOtLKIR3igSSOruiC5EzYvHNykVi0t8jQ1b6lwXZGZrvMF0NNVGAhPIYNmsedugul2KPlIx6VDVX1z8zU1w/f368lxizC7Gnt0Z5cgWEog22ZcOXoydiVoXC9yhami02QlngQShW6WQ2xRrcM5GDeBQk3JNxYx7wFLQoj3z5+mnn8ZRjl1tCYF2BnDcvzG6gkWgxUCDwnoveWFKNzh6NwPy+5wRsSJALXTyubJh5NnBGBErMaJVI6Vunz76nGu6VEjSFgd/nE45kihUeo6Pqe6xMV1G4GtcEcp5yETpBlTZc+dNTOSTBuqfvtY5vnIa+x5tLNecFCkmoxp7SwW5iJVAmjx/v9Ie3/V+hgT7aae5YkvCr7mH7YNhrrO7t75ra5+jwKJas7SjD5q4J603Ua9+GUaVnHVEZuMJJlDcmV5Yap5aeiPDg1rYhp6s8u4qr5wKzt1E8SMZ0wONNrOqbxVwbc2xmM6hUN1Y2tOrxwPc/0E/d/eMLn8OySxjzNlfq/qMIEuP4C4ADlF1UIAAA=";
    private static final Log log = LogFactory.getLog(CreateAccountsPanel.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel accountsLabel;
    protected JRadioButton base;
    protected JAXXButtonGroup buttonGroup;
    protected JRadioButton developed;
    protected JRadioButton importcsv;
    protected JRadioButton importebp;
    protected JRadioButton shortened;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CreateAccountsPanel $JPanel0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateAccountsPanel(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateAccountsPanel(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateAccountsPanel() {
        $initialize();
    }

    public CreateAccountsPanel(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateAccountsPanel(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateAccountsPanel(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateAccountsPanel(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateAccountsPanel(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getAccountsLabel() {
        return accountsLabel;
    }

    public JRadioButton getBase() {
        return base;
    }

    public JAXXButtonGroup getButtonGroup() {
        return buttonGroup;
    }

    public JRadioButton getDeveloped() {
        return developed;
    }

    public JRadioButton getImportcsv() {
        return importcsv;
    }

    public JRadioButton getImportebp() {
        return importebp;
    }

    public JRadioButton getShortened() {
        return shortened;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBase() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = buttonGroup; base.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(base); }
    }

    protected void addChildrenToDeveloped() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = buttonGroup; developed.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(developed); }
    }

    protected void addChildrenToImportcsv() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = buttonGroup; importcsv.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(importcsv); }
    }

    protected void addChildrenToImportebp() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = buttonGroup; importebp.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(importebp); }
    }

    protected void addChildrenToShortened() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = buttonGroup; shortened.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(shortened); }
    }

    protected void createAccountsLabel() {
        $objectMap.put("accountsLabel", accountsLabel = new JLabel());
        
        accountsLabel.setName("accountsLabel");
        accountsLabel.setText(t("lima.opening.accounts"));
    }

    protected void createBase() {
        $objectMap.put("base", base = new JRadioButton());
        
        base.setName("base");
        base.setText(t("lima.chart.accounts.base"));
    }

    protected void createButtonGroup() {
        $objectMap.put("buttonGroup", buttonGroup = new JAXXButtonGroup());
    }

    protected void createDeveloped() {
        $objectMap.put("developed", developed = new JRadioButton());
        
        developed.setName("developed");
        developed.setText(t("lima.chart.accounts.developed"));
    }

    protected void createImportcsv() {
        $objectMap.put("importcsv", importcsv = new JRadioButton());
        
        importcsv.setName("importcsv");
        importcsv.setText(t("lima.chart.accounts.import.csv"));
    }

    protected void createImportebp() {
        $objectMap.put("importebp", importebp = new JRadioButton());
        
        importebp.setName("importebp");
        importebp.setText(t("lima.chart.accounts.import.ebp"));
    }

    protected void createShortened() {
        $objectMap.put("shortened", shortened = new JRadioButton());
        
        shortened.setName("shortened");
        shortened.setText(t("lima.chart.accounts.shortened"));
        shortened.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add(accountsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(shortened, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(base, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(developed, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(importcsv, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(importebp, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToShortened();
        addChildrenToBase();
        addChildrenToDeveloped();
        addChildrenToImportcsv();
        addChildrenToImportebp();
        
        // apply 5 property setters
        { shortened.putClientProperty("$value", AccountsChartEnum.SHORTENED);  Object $buttonGroup = shortened.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { base.putClientProperty("$value", AccountsChartEnum.BASE);  Object $buttonGroup = base.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { developed.putClientProperty("$value", AccountsChartEnum.DEVELOPED);  Object $buttonGroup = developed.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { importcsv.putClientProperty("$value", AccountsChartEnum.IMPORT);  Object $buttonGroup = importcsv.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { importebp.putClientProperty("$value", AccountsChartEnum.IMPORTEBP);  Object $buttonGroup = importebp.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createButtonGroup();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createAccountsLabel();
        createShortened();
        createBase();
        createDeveloped();
        createImportcsv();
        createImportebp();
        // inline creation of $JPanel0
        setName("$JPanel0");
        
        $completeSetup();
    }

}