package org.chorem.lima.ui.identity;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Identity;
import static org.nuiton.i18n.I18n.t;

public class IdentityForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_IDENTITY = "identity";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Xz28bRRQem9qJk6akcZP0RxBpG1CqonWVaxC0dWKSyLWBRLTUhzD2Tu1p17vL7my7pSriT+BPgDsXJG6cEAfOHLgg/gWEOHBFvNldr3fsme0QJVJW6533vve+Nzvve/vdn6jke+jqYxyGhhfYjA6JcXDnwYN29zHpsR3i9zzqMsdD8V+hiIodNG+mz32Grnea3L2WuNfqztB1bGJnvLebaM5nzy3iDwhhDL0hevR8v3aYLm+HbuCNUNOkZKjf/P1X8Wvzq2+LCIUuZLcGVNZf5TVmcqaJitRkaAkiPcU1C9t9SMOjdh/yXeDP6hb2/RYeks/Rl2imicou9gCMoWv6lCOMyD90GSqbFFtOn6FNx+sbvYHjkaFh0SE2AmpQEyAoe27sJzcNxxu6buRdZmhmgG3TIh5DN3Wc92Lrsf/syIShNycBJnwzQTeOcNcitxi6KFTWfwZ1MqI1bllJHSo21KuJu8SCyvIihontQfSQWy2lxgvc+IiErEGJBVuxIjikC6LT4uj1o46dYq6KNhcyNgLMZdHuLDZNj/i+CmcxWc/DWEhstlQg50cGuZl8Qd26YxJlJsl6HsbsRlzkWxL/hR7sa55ztRv41IY0W8GwSzxVHquiWR7iuaeY5YMtpRZ5OKs9foboI9rDfD/zqnRl2jQPedEdwLnNz/FCxiYPa44MMbVUKOei1Tz/cg/bPX5qqsIhuBsw5tiiadF5wu92k6ceuiKcTeinxrifjhteoYNKXgCP4TB3plvwx7AUN9+LE82XA0ar/65Uf/vxjx8ao457GWIvS00zggGd0PUcFxoX5aFfj9ttwKhVu4fd7Q6q+MQCtYnUZE2S2GGyDMlBvPPc3eDuxh72BwBRmvn9p59XPvv1NVRsoDnLwWYDc/t9VGEDOHgDxzJD9/3bUUZnn83CdRH+iwwtm+QRDixWtxyftCHF6K0BgXpxsBM1amOnfdxqH+3ttz44breO68324e5LhkpDx8SwVWeYF5AQKrYmqViadrfyyz/Vw+9vj6pWABaXlObjypUeojK1LThtkVIlIiRVpnnXJ4HpjMVGJj8o1R83afD3outHU6UpcGrwrsIJjeQhFRfer8OAO92PiPC7T1G26+tDX32RCJrRJ2ykPJs3+C/ObPPGS1kkUTL0o10SiWT0QRZlSmP0A22qae2MQRXspLqlH3tZJJnojiyQIHz6ATbU5O7EgApiU0KqH3NFSmpL+nIIUqwf4q1X0tpS8JrW9hPvViLw0t3KDgenslsPY0DVbk0OGyduGHzqkDYMvnB6DaMe3ckbhjD46EdbE4mIY48skGyA0g93U03uroCroKmay/QzWBUJp6OZLNrEaKcf5G01zU9GkAqGkmFRP+76xGs5NSZKa6oYPPXD1nJe2SlsBe+8mfbE+pcZaqUNYHIwPhX9+3AMqtI/2bCtH7sqkoxmblmYzKyuD35NTWyXwykoTUz++vHmIzLxV4EMOPlg0AeciQCdJzIw+KT4Hz3+3XgsXceMebQbMPLeFGaBX98BzP8AWQ+biWQSAAA=";
    private static final Log log = LogFactory.getLog(IdentityForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel address2Label;
    protected JTextField address2TextField;
    protected JLabel addressLabel;
    protected JTextField addressTextField;
    protected JLabel businessNumberLabel;
    protected JTextField businessNumberTextField;
    protected JButton cancel;
    protected JTextField cityTextField;
    protected JLabel classificationCodeLabel;
    protected JTextField classificationCodeTextField;
    protected JLabel descriptionLabel;
    protected JTextField descriptionTextField;
    protected IdentityForm dialog = this;
    protected JLabel emailLabel;
    protected JTextField emailTextField;
    protected IdentityHandler handler;
    protected Identity identity;
    protected JLabel nameLabel;
    protected JTextField nameTextField;
    protected JButton ok;
    protected JLabel phoneNumberLabel;
    protected JTextField phoneNumberTextField;
    protected JLabel vatNumberLabel;
    protected JTextField vatNumberTextField;
    protected JLabel zipCodeLabel;
    protected JTextField zipCodeTextField;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public IdentityForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm() {
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Window param0) {
        super(param0);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateIdentity(); dispose();
    }

    public void doWindowClosing__on__dialog(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getAddress2Label() {
        return address2Label;
    }

    public JTextField getAddress2TextField() {
        return address2TextField;
    }

    public JLabel getAddressLabel() {
        return addressLabel;
    }

    public JTextField getAddressTextField() {
        return addressTextField;
    }

    public JLabel getBusinessNumberLabel() {
        return businessNumberLabel;
    }

    public JTextField getBusinessNumberTextField() {
        return businessNumberTextField;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JTextField getCityTextField() {
        return cityTextField;
    }

    public JLabel getClassificationCodeLabel() {
        return classificationCodeLabel;
    }

    public JTextField getClassificationCodeTextField() {
        return classificationCodeTextField;
    }

    public JLabel getDescriptionLabel() {
        return descriptionLabel;
    }

    public JTextField getDescriptionTextField() {
        return descriptionTextField;
    }

    public JLabel getEmailLabel() {
        return emailLabel;
    }

    public JTextField getEmailTextField() {
        return emailTextField;
    }

    public IdentityHandler getHandler() {
        return handler;
    }

    public Identity getIdentity() {
        return identity;
    }

    public JLabel getNameLabel() {
        return nameLabel;
    }

    public JTextField getNameTextField() {
        return nameTextField;
    }

    public JButton getOk() {
        return ok;
    }

    public JLabel getPhoneNumberLabel() {
        return phoneNumberLabel;
    }

    public JTextField getPhoneNumberTextField() {
        return phoneNumberTextField;
    }

    public JLabel getVatNumberLabel() {
        return vatNumberLabel;
    }

    public JTextField getVatNumberTextField() {
        return vatNumberTextField;
    }

    public JLabel getZipCodeLabel() {
        return zipCodeLabel;
    }

    public JTextField getZipCodeTextField() {
        return zipCodeTextField;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(IdentityHandler handler) {
        IdentityHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setIdentity(Identity identity) {
        Identity oldValue = this.identity;
        this.identity = identity;
        firePropertyChange(PROPERTY_IDENTITY, oldValue, identity);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0);
    }

    protected void createAddress2Label() {
        $objectMap.put("address2Label", address2Label = new JLabel());
        
        address2Label.setName("address2Label");
        address2Label.setText(t("lima.identity.address2"));
    }

    protected void createAddress2TextField() {
        $objectMap.put("address2TextField", address2TextField = new JTextField());
        
        address2TextField.setName("address2TextField");
        address2TextField.setColumns(15);
    }

    protected void createAddressLabel() {
        $objectMap.put("addressLabel", addressLabel = new JLabel());
        
        addressLabel.setName("addressLabel");
        addressLabel.setText(t("lima.identity.address"));
    }

    protected void createAddressTextField() {
        $objectMap.put("addressTextField", addressTextField = new JTextField());
        
        addressTextField.setName("addressTextField");
        addressTextField.setColumns(15);
    }

    protected void createBusinessNumberLabel() {
        $objectMap.put("businessNumberLabel", businessNumberLabel = new JLabel());
        
        businessNumberLabel.setName("businessNumberLabel");
        businessNumberLabel.setText(t("lima.identity.businessNumber"));
    }

    protected void createBusinessNumberTextField() {
        $objectMap.put("businessNumberTextField", businessNumberTextField = new JTextField());
        
        businessNumberTextField.setName("businessNumberTextField");
        businessNumberTextField.setColumns(15);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCityTextField() {
        $objectMap.put("cityTextField", cityTextField = new JTextField());
        
        cityTextField.setName("cityTextField");
        cityTextField.setColumns(15);
    }

    protected void createClassificationCodeLabel() {
        $objectMap.put("classificationCodeLabel", classificationCodeLabel = new JLabel());
        
        classificationCodeLabel.setName("classificationCodeLabel");
        classificationCodeLabel.setText(t("lima.identity.classificationCode"));
    }

    protected void createClassificationCodeTextField() {
        $objectMap.put("classificationCodeTextField", classificationCodeTextField = new JTextField());
        
        classificationCodeTextField.setName("classificationCodeTextField");
        classificationCodeTextField.setColumns(15);
    }

    protected void createDescriptionLabel() {
        $objectMap.put("descriptionLabel", descriptionLabel = new JLabel());
        
        descriptionLabel.setName("descriptionLabel");
        descriptionLabel.setText(t("lima.identity.description"));
    }

    protected void createDescriptionTextField() {
        $objectMap.put("descriptionTextField", descriptionTextField = new JTextField());
        
        descriptionTextField.setName("descriptionTextField");
        descriptionTextField.setColumns(15);
    }

    protected void createEmailLabel() {
        $objectMap.put("emailLabel", emailLabel = new JLabel());
        
        emailLabel.setName("emailLabel");
        emailLabel.setText(t("lima.identity.email"));
    }

    protected void createEmailTextField() {
        $objectMap.put("emailTextField", emailTextField = new JTextField());
        
        emailTextField.setName("emailTextField");
        emailTextField.setColumns(15);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new IdentityHandler(this));
    }

    protected void createIdentity() {
        $objectMap.put("identity", identity = handler.getIdentity());
    }

    protected void createNameLabel() {
        $objectMap.put("nameLabel", nameLabel = new JLabel());
        
        nameLabel.setName("nameLabel");
        nameLabel.setText(t("lima.identity.name"));
    }

    protected void createNameTextField() {
        $objectMap.put("nameTextField", nameTextField = new JTextField());
        
        nameTextField.setName("nameTextField");
        nameTextField.setColumns(15);
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createPhoneNumberLabel() {
        $objectMap.put("phoneNumberLabel", phoneNumberLabel = new JLabel());
        
        phoneNumberLabel.setName("phoneNumberLabel");
        phoneNumberLabel.setText(t("lima.identity.phoneNumber"));
    }

    protected void createPhoneNumberTextField() {
        $objectMap.put("phoneNumberTextField", phoneNumberTextField = new JTextField());
        
        phoneNumberTextField.setName("phoneNumberTextField");
        phoneNumberTextField.setColumns(15);
    }

    protected void createVatNumberLabel() {
        $objectMap.put("vatNumberLabel", vatNumberLabel = new JLabel());
        
        vatNumberLabel.setName("vatNumberLabel");
        vatNumberLabel.setText(t("lima.identity.vatNumber"));
    }

    protected void createVatNumberTextField() {
        $objectMap.put("vatNumberTextField", vatNumberTextField = new JTextField());
        
        vatNumberTextField.setName("vatNumberTextField");
        vatNumberTextField.setColumns(15);
    }

    protected void createZipCodeLabel() {
        $objectMap.put("zipCodeLabel", zipCodeLabel = new JLabel());
        
        zipCodeLabel.setName("zipCodeLabel");
        zipCodeLabel.setText(t("lima.identity.zipCode"));
    }

    protected void createZipCodeTextField() {
        $objectMap.put("zipCodeTextField", zipCodeTextField = new JTextField());
        
        zipCodeTextField.setName("zipCodeTextField");
        zipCodeTextField.setColumns(15);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToDialog();
        // inline complete setup of $Table0
        $Table0.add(nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(nameTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(descriptionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(descriptionTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addressLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addressTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(address2Label, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(address2TextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(zipCodeLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(zipCodeTextField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel0, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cityTextField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(businessNumberLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(businessNumberTextField, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vatNumberLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vatNumberTextField, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(classificationCodeLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(classificationCodeTextField, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(phoneNumberLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(phoneNumberTextField, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(emailLabel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(emailTextField, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cancel, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ok, new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 12 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        SwingUtil.setText(nameTextField, handler.getIdentity().getName());
        
        SwingUtil.setText(descriptionTextField, handler.getIdentity().getDescription());
        
        SwingUtil.setText(addressTextField, handler.getIdentity().getAddress());
        
        SwingUtil.setText(address2TextField, handler.getIdentity().getAddress2());
        
        SwingUtil.setText(zipCodeTextField, handler.getIdentity().getZipCode());
        
        SwingUtil.setText(cityTextField, handler.getIdentity().getCity());
        
        SwingUtil.setText(businessNumberTextField, handler.getIdentity().getBusinessNumber());
        
        SwingUtil.setText(vatNumberTextField, handler.getIdentity().getVatNumber());
        
        SwingUtil.setText(classificationCodeTextField, handler.getIdentity().getClassificationCode());
        
        SwingUtil.setText(phoneNumberTextField, handler.getIdentity().getPhoneNumber());
        
        SwingUtil.setText(emailTextField, handler.getIdentity().getEmail());
        // late initializer
        dialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("dialog", dialog);
        createHandler();
        createIdentity();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createNameLabel();
        createNameTextField();
        createDescriptionLabel();
        createDescriptionTextField();
        createAddressLabel();
        createAddressTextField();
        createAddress2Label();
        createAddress2TextField();
        createZipCodeLabel();
        createZipCodeTextField();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("lima.identity.city"));
        createCityTextField();
        createBusinessNumberLabel();
        createBusinessNumberTextField();
        createVatNumberLabel();
        createVatNumberTextField();
        createClassificationCodeLabel();
        createClassificationCodeTextField();
        createPhoneNumberLabel();
        createPhoneNumberTextField();
        createEmailLabel();
        createEmailTextField();
        createCancel();
        createOk();
        // inline creation of dialog
        setName("dialog");
        setModal(true);
        dialog.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__dialog"));
        
        getRootPane().setDefaultButton(ok);$completeSetup();
    }

}