package org.chorem.lima.ui.financialstatementchart;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.enums.FinancialStatementsChartEnum;
import static org.nuiton.i18n.I18n.t;

public class FinancialStatementImportForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_STATE = "addState";
    public static final String PROPERTY_RADIO_BUTTONS = "radioButtons";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DEVELOPED_BUTTON_GROUP = "developed.buttonGroup";
    public static final String BINDING_SHORTENED_BUTTON_GROUP = "shortened.buttonGroup";
    public static final String BINDING_STATEMENT_BASE_BUTTON_GROUP = "statementBase.buttonGroup";
    public static final String BINDING_STATEMENT_IMPORT_BUTTON_GROUP = "statementImport.buttonGroup";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28bRRSeuHHSxA2FhFShTSFtihQu6yJxQKSC1o7dBrlNFVeowhfGO5N4m9mdZeZtuqgq4k/gT4A7l0rcOFUcOHPggvgXEOLAFfFm1t71xusflfBhZe+8973vfTPfG//wJylrRa49oXHsqCgAz+fOp3cePz7oPuEu7HHtKi8EqUjymSuRUodUWPpeA9nutEx6tZ9erUs/lAEPhrJ3W2RZw1eC6x7nAORqPsPVutpOl3fjMFID1JRUEep3f/9V+pZ9832JkDhEdivYyta0rKyT+RYpeQzIKlY6pVVBg2OkobzgGPmumHd1QbV+QH3+JfmaLLbIQkgVggG5PnvLFsPmxyGQzSMvoIHrUdEGCtzHnH3MVdCUygdyV6pjx+1JxX1HeD51Is9JM/Qgw+1RBU5zAlIY2pILQC4oyjxZiwBkgJt1PSePforN2v1OAu4qGYVZ7nnKmAUH8oaRwzESOTUpBadBFrZ44xHtCn4TyEYBul0zkUtZQiChh2sovYGNBzxatMuFiVlNQ5c0igE84MyiDwUfZn3lU1ZSnWpU28qXz2AyfsqFDDkrWLyo82oWhFxlXHDgo/rXzb4AWc/xrPe4e1KTcR6jr9n75ueb+aUFF2G5ALKWw8lavZGGluSJ+bbTf6vIldwGoK+czFfZwZ/rkLKK8DVq2hm14iEuJSbcOGNCA2hX/7209ttPf/zYHDivgrXXC0OHBgc6IlQouwLPlL6Y2C4CT1Tv03C3g5uNwrrJVNksINbuLyM5rJccSZPu3KO6hxDlxd9f/nzpi1/PkVKTLAtJWZOa+H2yBD2FKkjB4vCT25bRhafn8fm64QakDB7gnpJta7pRjzqePQzOEXorRmE2C4RJ2XWXfvlnrf3i9kCcOST71tjwTKDy52TBC4QXcDuY+jOncBBVQs0jJrPZUjRtyJRxM3D6Tfv8oEiXeeAxnuh3xsnSN3IcGYQPba/m20ckM/m0KvM4Z5J9Nx6fBxXxtO61cXWHpkKlm40u9MyzYw5Do0HvvPcct/eUCgO782zUtNq6thFEvtO+d3D4qPGgsfe8qKFsFE1r6VzawOa4Bro4ml6N+/Zk7rU77UYh7fw4nJ36WO3T6fm/ar/X+KzROng4Tvu06OwNbNgGEuM2Ymvf5Mer8X53Mu/9+w/x0BSSPnuVTKNeyjmhfIQ3fmaFt8dvh7mMiupPvqdmd3/Flk5upaI6/QtrdsBFCyhPisDwSpsBaJ3xIxoJqAup+QFeKRQ8GQB57RajQLe6XsBw9Hw8UmDOPJdnKFD2JaN4B6/eSibyFgX8Z4jHhk8A/Q+BqameTgsAAA==";
    private static final Log log = LogFactory.getLog(FinancialStatementImportForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean addState;
    protected JButton cancel;
    protected JCheckBox deleteFinancialStatementChart;
    protected JRadioButton developed;
    protected FinancialStatementImportForm financialStatementImportForm = this;
    protected JLabel nothing;
    protected JButton ok;
    protected JAXXButtonGroup radioButtons;
    protected JRadioButton shortened;
    protected JRadioButton statementBase;
    protected JRadioButton statementImport;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        protected void performCancel() {
            getRadioButtons().setSelectedValue(null);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialStatementImportForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FinancialStatementImportForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementImportForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementImportForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementImportForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementImportForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementImportForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FinancialStatementImportForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementImportForm() {
        $initialize();
    }

    public FinancialStatementImportForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementImportForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementImportForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementImportForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementImportForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementImportForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementImportForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementImportForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementImportForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementImportForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementImportForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementImportForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FinancialStatementImportForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementImportForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FinancialStatementImportForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementImportForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementImportForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementImportForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FinancialStatementImportForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementImportForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FinancialStatementImportForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementImportForm(Window param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementImportForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doWindowClosing__on__financialStatementImportForm(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAddState() {
        return addState;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JCheckBox getDeleteFinancialStatementChart() {
        return deleteFinancialStatementChart;
    }

    public JRadioButton getDeveloped() {
        return developed;
    }

    public JLabel getNothing() {
        return nothing;
    }

    public JButton getOk() {
        return ok;
    }

    public JAXXButtonGroup getRadioButtons() {
        return radioButtons;
    }

    public JRadioButton getShortened() {
        return shortened;
    }

    public JRadioButton getStatementBase() {
        return statementBase;
    }

    public JRadioButton getStatementImport() {
        return statementImport;
    }

    public Boolean isAddState() {
        return addState !=null && addState;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAddState(Boolean addState) {
        Boolean oldValue = this.addState;
        this.addState = addState;
        firePropertyChange(PROPERTY_ADD_STATE, oldValue, addState);
    }

    public void setRadioButtons(JAXXButtonGroup radioButtons) {
        JAXXButtonGroup oldValue = this.radioButtons;
        this.radioButtons = radioButtons;
        firePropertyChange(PROPERTY_RADIO_BUTTONS, oldValue, radioButtons);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFinancialStatementImportForm() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0);
    }

    protected void createAddState() {
        $objectMap.put("addState", addState = true);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createDeleteFinancialStatementChart() {
        $objectMap.put("deleteFinancialStatementChart", deleteFinancialStatementChart = new JCheckBox());
        
        deleteFinancialStatementChart.setName("deleteFinancialStatementChart");
        deleteFinancialStatementChart.setText(t("lima.financialStatement.delete"));
        deleteFinancialStatementChart.setSelected(false);
    }

    protected void createDeveloped() {
        $objectMap.put("developed", developed = new JRadioButton());
        
        developed.setName("developed");
        developed.setText(t("lima.financialStatement.developed"));
    }

    protected void createNothing() {
        $objectMap.put("nothing", nothing = new JLabel());
        
        nothing.setName("nothing");
        nothing.setText(t("lima.financialStatement.nothing"));
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createRadioButtons() {
        $objectMap.put("radioButtons", radioButtons = new JAXXButtonGroup());
    }

    protected void createShortened() {
        $objectMap.put("shortened", shortened = new JRadioButton());
        
        shortened.setName("shortened");
        shortened.setText(t("lima.financialStatement.shortened"));
        shortened.setSelected(true);
    }

    protected void createStatementBase() {
        $objectMap.put("statementBase", statementBase = new JRadioButton());
        
        statementBase.setName("statementBase");
        statementBase.setText(t("lima.financialStatement.base"));
    }

    protected void createStatementImport() {
        $objectMap.put("statementImport", statementImport = new JRadioButton());
        
        statementImport.setName("statementImport");
        statementImport.setText(t("lima.importExport.import"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToFinancialStatementImportForm();
        // inline complete setup of $Table0
        $Table0.add(nothing, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(shortened, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(statementBase, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(developed, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(statementImport, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(deleteFinancialStatementChart, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table1, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(cancel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(ok, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        { shortened.putClientProperty("$value", FinancialStatementsChartEnum.SHORTENED);  Object $buttonGroup = shortened.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { statementBase.putClientProperty("$value", FinancialStatementsChartEnum.BASE);  Object $buttonGroup = statementBase.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { developed.putClientProperty("$value", FinancialStatementsChartEnum.DEVELOPED);  Object $buttonGroup = developed.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { statementImport.putClientProperty("$value", FinancialStatementsChartEnum.IMPORT);  Object $buttonGroup = statementImport.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        // late initializer
        financialStatementImportForm.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("financialStatementImportForm", financialStatementImportForm);
        createRadioButtons();
        createAddState();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createNothing();
        createShortened();
        createStatementBase();
        createDeveloped();
        createStatementImport();
        createDeleteFinancialStatementChart();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createCancel();
        createOk();
        // inline creation of financialStatementImportForm
        setName("financialStatementImportForm");
        setModal(true);
        setTitle(t("lima.financialStatement.import.form"));
        financialStatementImportForm.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__financialStatementImportForm"));
        
        getRootPane().setDefaultButton(ok);// registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SHORTENED_BUTTON_GROUP, true ,"radioButtons") {
        
            @Override
            public void processDataBinding() {
                { ButtonGroup $buttonGroup = getRadioButtons(); shortened.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(shortened); }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STATEMENT_BASE_BUTTON_GROUP, true ,"radioButtons") {
        
            @Override
            public void processDataBinding() {
                { ButtonGroup $buttonGroup = getRadioButtons(); statementBase.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(statementBase); }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DEVELOPED_BUTTON_GROUP, true ,"radioButtons") {
        
            @Override
            public void processDataBinding() {
                { ButtonGroup $buttonGroup = getRadioButtons(); developed.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(developed); }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STATEMENT_IMPORT_BUTTON_GROUP, true ,"radioButtons") {
        
            @Override
            public void processDataBinding() {
                { ButtonGroup $buttonGroup = getRadioButtons(); statementImport.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(statementImport); }
            }
        });
    }

}