package org.chorem.lima.ui.Filter.dateIntervalCondition;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.ListSelectionModel;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXDatePicker;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.DateCondition;
import static org.nuiton.i18n.I18n.t;

public class DateIntervalConditionView extends JInternalFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Uz28SQRR+YCmlP8RaxTatCfVHolEX9FqjNUXSNvgjYkwjFwd2ClOH2XF2KKtNjX+Cf4LevZh482Q8ePbgxfgvGOPBq/HNsi7QrqUaSRg2773ve28+vrevvkLCVTC/QTzPUi2hWZNaq9fW1m5VN2hNF6hbU0xqR0HnE4tDvAJjdhh3NZyslAw8F8BzS05TOoKKHvRCCUZd/ZhTt0Gp1nC8H1Fz3Vw5TC94sqV+s4ZDRbG++P4t/tx+9jIO4EmcLolXyQ5CdW8yVII4szUcxk6bJMeJqOMYiok6zjthYkucuO5N0qSP4CkkSzAsiUIyDSf2f2Wfw8d7UsOsTTRdEZqqTYI5R9hMM0cUFTbRsOKoulVrOIo2Lc6axGoxq8g4Vlu9uBBmFaKi9xhtS+n3HNaQbBBhc6o0lP4L+3KHrqfBqbukymlew3Sf9m4blbT8nKlMhYCDVVpnwpCXSJVy/AOM1l4AWPWDpjQdItIh4jarPTR3mY9oZXzbrelnGKfCDjua2JH+/ESQ72KPBQUKZvt6oVmtrlm7bopVIKFaGEYdKrv9fQdTHWdP73C2IfSzPzNTn95+eVPstfPRyNKebUSbSeVI1ISZ1umOl1ua8dwNIhcqkHIpx1X2V3UuYrBykMbhsN+kgVsGbi0Tt4EUieTnd+8zDz4egHgRRrlD7CIx9SuQ0g2FKjjc9uTVRX+i8fYInofwG9eQ0ExzlGjKN5uxmGuxwE6ouFR0nSpF7TJ7glUzW4K2swUcS7hoszOX8vnz2Yv5/NltD0WbixAtnLya+vBjqvx68bdwMbzIzB/Lu+Il7sMwE5wJ6r8JgiWP3Pwx6dKW7XSXOWq9Ye/9lsHOzPvn6SjJRrjxZ9FBh09u7TD9toYhTT18+2QiBMUHr2V4z/kCmKcLsGvX/m6E9FbfVgwYQDtRA/Qt3qD2MexgWHHuy/hLslWGAor6lV3MMXNm9sGXXHdUk2i/4Pq/0phwYQ+G2X0xrA5g+AWMp8vzjQcAAA==";
    private static final Log log = LogFactory.getLog(DateIntervalConditionView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel beginDateLabel;
    protected JAXXDatePicker beginDatePicker;
    protected DateIntervalConditionView dateIntervaleConditionFrame = this;
    protected JLabel endDateLabel;
    protected JAXXDatePicker endDatePicker;
    protected DateIntervalConditionHandler handler;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DateIntervalConditionView() {
        $initialize();
    }

    public DateIntervalConditionView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DateIntervalConditionView(String param0, boolean param1, boolean param2, boolean param3, boolean param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public DateIntervalConditionView(JAXXContext parentContext, String param1, boolean param2, boolean param3, boolean param4, boolean param5) {
        super(param1 ,param2 ,param3 ,param4 ,param5);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DateIntervalConditionView(String param0, boolean param1, boolean param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public DateIntervalConditionView(JAXXContext parentContext, String param1, boolean param2, boolean param3, boolean param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DateIntervalConditionView(String param0, boolean param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DateIntervalConditionView(JAXXContext parentContext, String param1, boolean param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DateIntervalConditionView(String param0) {
        super(param0);
        $initialize();
    }

    public DateIntervalConditionView(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DateIntervalConditionView(String param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DateIntervalConditionView(JAXXContext parentContext, String param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__beginDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBeginDate(beginDatePicker.getDate());
    }

    public void doActionPerformed__on__endDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setEndDate(endDatePicker.getDate());
    }

    public void doInternalFrameClosed__on__dateIntervaleConditionFrame(InternalFrameEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.delete();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getBeginDateLabel() {
        return beginDateLabel;
    }

    public JAXXDatePicker getBeginDatePicker() {
        return beginDatePicker;
    }

    public JLabel getEndDateLabel() {
        return endDateLabel;
    }

    public JAXXDatePicker getEndDatePicker() {
        return endDatePicker;
    }

    public DateIntervalConditionHandler getHandler() {
        return handler;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(DateIntervalConditionHandler handler) {
        DateIntervalConditionHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDateIntervaleConditionFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0);
    }

    protected void createBeginDateLabel() {
        $objectMap.put("beginDateLabel", beginDateLabel = new JLabel());
        
        beginDateLabel.setName("beginDateLabel");
        beginDateLabel.setText(t("lima.dates.interval.in"));
    }

    protected void createBeginDatePicker() {
        $objectMap.put("beginDatePicker", beginDatePicker = new JAXXDatePicker());
        
        beginDatePicker.setName("beginDatePicker");
        beginDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__beginDatePicker"));
    }

    protected void createEndDateLabel() {
        $objectMap.put("endDateLabel", endDateLabel = new JLabel());
        
        endDateLabel.setName("endDateLabel");
        endDateLabel.setText(t("lima.dates.interval.to"));
    }

    protected void createEndDatePicker() {
        $objectMap.put("endDatePicker", endDatePicker = new JAXXDatePicker());
        
        endDatePicker.setName("endDatePicker");
        endDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__endDatePicker"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new DateIntervalConditionHandler(this));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToDateIntervaleConditionFrame();
        // inline complete setup of $Table0
        $Table0.add(beginDateLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(beginDatePicker, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(endDateLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(endDatePicker, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 7 property setters
        beginDatePicker.setDate(handler.getBeginDate());
        beginDatePicker.setFormats(handler.getFormats());
        endDatePicker.setDate(handler.getEndDate());
        endDatePicker.setFormats(handler.getFormats());
        setPreferredSize(new Dimension(200, 100));
        beginDateLabel.setLabelFor(beginDatePicker);
        endDateLabel.setLabelFor(endDatePicker);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("dateIntervaleConditionFrame", dateIntervaleConditionFrame);
        createHandler();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createBeginDateLabel();
        createBeginDatePicker();
        createEndDateLabel();
        createEndDatePicker();
        // inline creation of dateIntervaleConditionFrame
        setName("dateIntervaleConditionFrame");
        setVisible(true);
        setClosable(true);
        setDefaultCloseOperation(2);
        setTitle(t("lima.dates.interval"));
        dateIntervaleConditionFrame.addInternalFrameListener(JAXXUtil.getEventListener(InternalFrameListener.class, "internalFrameClosed", this, "doInternalFrameClosed__on__dateIntervaleConditionFrame"));
        
        dateIntervaleConditionFrame.pack();
        $completeSetup();
    }

}