package org.chorem.lima.ui.financialtransactionsearch;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JToolBar.Separator;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneConstants;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.ui.Filter.financialTransactionCondition.FinancialTransactionConditionView;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionDefaultTable;
import static org.nuiton.i18n.I18n.t;

public class FinancialTransactionSearchView extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FIELD_SIZE = "fieldSize";
    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2Xz28bRRTHJy5J6oTS5nfSpG3aBgFC2ZRwI0CbOAlx5KZR1koLFirj3bE9Zby7zI5jh6iIP4E/Ae5ckLhxQhw4c+CC+BcQ4sAV8WbW3vWux5tYSg5WtPOd9z7zdmbed7//Cw37HN19gVstgzccQevE2N989uxJ+QWxxDbxLU494XIU/A1lUKaExu3wuS/Q/VJBTl9rT1/LuXXPdYjTNXujgMZ8ccqIXyNECHQrPsPy/TUzHN5oeQ3eiRpC6aJ++8/fmW/sr7/LINTygG4JlrJ83qxoJa8UUIbaAk1CphO8xrBTBQxOnSrwXpPPcgz7/gGuky/QV2i0gEY8zCGYQPcuvmQVQ81veQJdXdk/xA5hDwQquLxqWDWXk7rBaB0bDWpUqIMdi2ImOHZ8bAnqOj7B3KoZu52hYjRkqqFjSpqep3KMCDRaw47NCBfIvMwEe0HUKM+4TxhsEWIfuU2BJmS5DFlCY8t1GcFOpMxWKGG2Sb8kUGulw01hbEPhHB9ydKELmFrGgD4tZS3Db8LLMPaL8HgLc6nKhuIb2La3sSA517GpZBVoKjZrqyGE60j1TDhpvj0p7wjCTzALJ8vxm3HtImjDmhwSTl07TT6v5L51Ee30SmdNKyaBPYVhw8COuK1bdaSIx5iBfDuO4KdQ788HTfaOHLsf101BwGO3YdUITwsnZZuW5cLWT5PNyUq3TwMo0qRyJQW4Fog8eoOuZF2zkgmVu0xTASdBlOPETlfpUr6rSTnKSYXD/aUJcauiO1geo8KDm0Cg2dhbVwPyiojv9jd0QUJw0+IuY4cq3Fw8XDgiA70XxrubGk8eeIE+1twfu5TBezJSZ2tvklhsCfFByHJtpQvzgXz4MA67oq2gupqKuMzIY9cmTKCjy7rvoqDR3XTnHAaB9i6YXpt4m1RwgwkVSmbMde3AAvWFqS5bECqs5F3RqwBwjhZjvRC6rBF12agNDpXQMG/AY7jDSr2N+QiGgpY8n2jJMqAa/W926vef/vxxt9OHb0DuGa20y0ZAf/S460GjojL19aAJNwRla4+xt1FC2aDBKI+xpAEz28MAB/mCBiSnG3vYr0GI4dE/fv5l9rPfrqDMLhpjLrZ3sdTnUVbU5Fl1md3yHj5SRK82r0pwySYbFqhF8FaHK5j5pAXLX9IsP2QoZ3/9d8r84VGnBEOAtNBXHpVh+BM0Qh1GHaLMSNtnaM3HuOeThu1GfkLnMFDURb325jXV79OehWYEGgs2X96S3XOuos72atdWXbWhV0KrlxGL1CuSFnifabW5A7EhBQZYn1ZDJimplcv/PkWaDj0o0XIfolXabt9JtIUetI5Sx9fXDAzKeU/DWYk7hyTpYjdpQqtjTTMjg+Le0eJGziXJOh9njYT9iqq1QYNSLmkoScfvJBFnuhFDlY5Pb5sGhbupgTsJvFMSbaobra3Rgens12Vg4cCrpWK1Nf2wknZvUKzbunMcecMk2lzsFEc6HV4/mzko4oIGkSlPmqSb7KYLJP32Wa+pHRRrXls5cLZJqol4zUChg+o1xpdRJ0u56NQ6BRIdksaGD8rU8d76S6E9aEC/58JqaCE6Ec7LfAX8QD0wm2+fVYm4iIV8862XYHH9bncm0OtnvZbNMPMHHxV2nps7hZ1cMf/kAOZludvcI7Rag+Vk1td17OcZ0/PWBH5n3OUULk0cHMbFs+gjxDjeOSrmc5uF5+ZhIV98qQNI/765QPoRhk9d+FhHr70PPRsvlylsBKf6YU+yIfk7BhH/BxHZjw+3EgAA";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(FinancialTransactionSearchView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addAccountCondition;
    protected JButton addCreditCondition;
    protected JButton addDateCondition;
    protected JButton addDateIntervalCondition;
    protected JButton addDebitCondition;
    protected JButton addDescriptionCondition;
    protected JButton addEntryBookCondition;
    protected JButton addFinancialPeriodCondition;
    protected JButton addFiscalPeriodCondition;
    protected JButton addLetteringCondition;
    protected JButton addVoucherCondition;
    protected Dimension fieldSize;
    protected JScrollPane financialTransactionConditionScrollPane;
    protected FinancialTransactionConditionView financialTransactionConditionView;
    protected FinancialTransactionDefaultTable financialTransactionSearchTable;
    protected FinancialTransactionSearchTableModel financialTransactionSearchTableModel;
    protected JSplitPane financialTransactionSplitpane;
    protected FinancialTransactionSearchViewHandler handler;
    protected JButton refresh;
    protected Boolean selectedRow;
    protected JToolBar toolbar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FinancialTransactionSearchView $JPanel0 = this;
    private JScrollPane $JScrollPane0;
    private Separator $JToolBar$Separator0;
    private Separator $JToolBar$Separator1;
    private Separator $JToolBar$Separator2;
    private Separator $JToolBar$Separator3;
    private ListSelectionModel $ListSelectionModel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialTransactionSearchView(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialTransactionSearchView(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialTransactionSearchView() {
        $initialize();
    }

    public FinancialTransactionSearchView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialTransactionSearchView(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FinancialTransactionSearchView(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialTransactionSearchView(boolean param0) {
        super(param0);
        $initialize();
    }

    public FinancialTransactionSearchView(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addAccountCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addAccountCondition();
    }

    public void doActionPerformed__on__addCreditCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addCreditCondition();
    }

    public void doActionPerformed__on__addDateCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addDateCondition();
    }

    public void doActionPerformed__on__addDateIntervalCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addDateIntervalCondition();
    }

    public void doActionPerformed__on__addDebitCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addDebitCondition();
    }

    public void doActionPerformed__on__addDescriptionCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addDescriptionCondition();
    }

    public void doActionPerformed__on__addEntryBookCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addEntryBookCondition();
    }

    public void doActionPerformed__on__addFinancialPeriodCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addFinancialPeriodCondition();
    }

    public void doActionPerformed__on__addFiscalPeriodCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addFiscalPeriodCondition();
    }

    public void doActionPerformed__on__addLetteringCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addLetteringCondition();
    }

    public void doActionPerformed__on__addVoucherCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addVoucherCondition();
    }

    public void doActionPerformed__on__refresh(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().refresh();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedRow(financialTransactionSearchTable.getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddAccountCondition() {
        return addAccountCondition;
    }

    public JButton getAddCreditCondition() {
        return addCreditCondition;
    }

    public JButton getAddDateCondition() {
        return addDateCondition;
    }

    public JButton getAddDateIntervalCondition() {
        return addDateIntervalCondition;
    }

    public JButton getAddDebitCondition() {
        return addDebitCondition;
    }

    public JButton getAddDescriptionCondition() {
        return addDescriptionCondition;
    }

    public JButton getAddEntryBookCondition() {
        return addEntryBookCondition;
    }

    public JButton getAddFinancialPeriodCondition() {
        return addFinancialPeriodCondition;
    }

    public JButton getAddFiscalPeriodCondition() {
        return addFiscalPeriodCondition;
    }

    public JButton getAddLetteringCondition() {
        return addLetteringCondition;
    }

    public JButton getAddVoucherCondition() {
        return addVoucherCondition;
    }

    public Dimension getFieldSize() {
        return fieldSize;
    }

    public JScrollPane getFinancialTransactionConditionScrollPane() {
        return financialTransactionConditionScrollPane;
    }

    public FinancialTransactionConditionView getFinancialTransactionConditionView() {
        return financialTransactionConditionView;
    }

    public FinancialTransactionDefaultTable getFinancialTransactionSearchTable() {
        return financialTransactionSearchTable;
    }

    public FinancialTransactionSearchTableModel getFinancialTransactionSearchTableModel() {
        return financialTransactionSearchTableModel;
    }

    public JSplitPane getFinancialTransactionSplitpane() {
        return financialTransactionSplitpane;
    }

    public FinancialTransactionSearchViewHandler getHandler() {
        return handler;
    }

    public JButton getRefresh() {
        return refresh;
    }

    public Boolean getSelectedRow() {
        return selectedRow;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    public Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$ListSelectionModel0(ListSelectionModel $ListSelectionModel0) {
        ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = $ListSelectionModel0;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, $ListSelectionModel0);
    }

    public void setFieldSize(Dimension fieldSize) {
        Dimension oldValue = this.fieldSize;
        this.fieldSize = fieldSize;
        firePropertyChange(PROPERTY_FIELD_SIZE, oldValue, fieldSize);
    }

    public void setHandler(FinancialTransactionSearchViewHandler handler) {
        FinancialTransactionSearchViewHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setSelectedRow(Boolean selectedRow) {
        Boolean oldValue = this.selectedRow;
        this.selectedRow = selectedRow;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, selectedRow);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Separator get$JToolBar$Separator0() {
        return $JToolBar$Separator0;
    }

    protected Separator get$JToolBar$Separator1() {
        return $JToolBar$Separator1;
    }

    protected Separator get$JToolBar$Separator2() {
        return $JToolBar$Separator2;
    }

    protected Separator get$JToolBar$Separator3() {
        return $JToolBar$Separator3;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFinancialTransactionConditionScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        financialTransactionConditionScrollPane.getViewport().add(financialTransactionConditionView);
    }

    protected void addChildrenToFinancialTransactionSplitpane() {
        if (!allComponentsCreated) {
            return;
        }
        financialTransactionSplitpane.add(financialTransactionConditionScrollPane, JSplitPane.LEFT);
        financialTransactionSplitpane.add($JScrollPane0, JSplitPane.RIGHT);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(addDateCondition);
        toolbar.add(addDateIntervalCondition);
        toolbar.add(addFinancialPeriodCondition);
        toolbar.add(addFiscalPeriodCondition);
        toolbar.add($JToolBar$Separator0);
        toolbar.add(addEntryBookCondition);
        toolbar.add($JToolBar$Separator1);
        toolbar.add(addVoucherCondition);
        toolbar.add(addAccountCondition);
        toolbar.add(addDescriptionCondition);
        toolbar.add(addLetteringCondition);
        toolbar.add($JToolBar$Separator2);
        toolbar.add(addDebitCondition);
        toolbar.add(addCreditCondition);
        toolbar.add($JToolBar$Separator3);
        toolbar.add(refresh);
    }

    protected void createAddAccountCondition() {
        $objectMap.put("addAccountCondition", addAccountCondition = new JButton());
        
        addAccountCondition.setName("addAccountCondition");
        addAccountCondition.setToolTipText(t("lima.filter.account"));
        addAccountCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addAccountCondition"));
    }

    protected void createAddCreditCondition() {
        $objectMap.put("addCreditCondition", addCreditCondition = new JButton());
        
        addCreditCondition.setName("addCreditCondition");
        addCreditCondition.setToolTipText(t("lima.filter.credit"));
        addCreditCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addCreditCondition"));
    }

    protected void createAddDateCondition() {
        $objectMap.put("addDateCondition", addDateCondition = new JButton());
        
        addDateCondition.setName("addDateCondition");
        addDateCondition.setToolTipText(t("lima.filter.date.one"));
        addDateCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addDateCondition"));
    }

    protected void createAddDateIntervalCondition() {
        $objectMap.put("addDateIntervalCondition", addDateIntervalCondition = new JButton());
        
        addDateIntervalCondition.setName("addDateIntervalCondition");
        addDateIntervalCondition.setToolTipText(t("lima.filter.date.interval"));
        addDateIntervalCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addDateIntervalCondition"));
    }

    protected void createAddDebitCondition() {
        $objectMap.put("addDebitCondition", addDebitCondition = new JButton());
        
        addDebitCondition.setName("addDebitCondition");
        addDebitCondition.setToolTipText(t("lima.filter.debit"));
        addDebitCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addDebitCondition"));
    }

    protected void createAddDescriptionCondition() {
        $objectMap.put("addDescriptionCondition", addDescriptionCondition = new JButton());
        
        addDescriptionCondition.setName("addDescriptionCondition");
        addDescriptionCondition.setToolTipText(t("lima.filter.description"));
        addDescriptionCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addDescriptionCondition"));
    }

    protected void createAddEntryBookCondition() {
        $objectMap.put("addEntryBookCondition", addEntryBookCondition = new JButton());
        
        addEntryBookCondition.setName("addEntryBookCondition");
        addEntryBookCondition.setToolTipText(t("lima.filter.entryBook"));
        addEntryBookCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addEntryBookCondition"));
    }

    protected void createAddFinancialPeriodCondition() {
        $objectMap.put("addFinancialPeriodCondition", addFinancialPeriodCondition = new JButton());
        
        addFinancialPeriodCondition.setName("addFinancialPeriodCondition");
        addFinancialPeriodCondition.setToolTipText(t("lima.filter.financialPeriod"));
        addFinancialPeriodCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addFinancialPeriodCondition"));
    }

    protected void createAddFiscalPeriodCondition() {
        $objectMap.put("addFiscalPeriodCondition", addFiscalPeriodCondition = new JButton());
        
        addFiscalPeriodCondition.setName("addFiscalPeriodCondition");
        addFiscalPeriodCondition.setToolTipText(t("lima.filter.fiscalPeriod"));
        addFiscalPeriodCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addFiscalPeriodCondition"));
    }

    protected void createAddLetteringCondition() {
        $objectMap.put("addLetteringCondition", addLetteringCondition = new JButton());
        
        addLetteringCondition.setName("addLetteringCondition");
        addLetteringCondition.setToolTipText(t("lima.filter.letter"));
        addLetteringCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addLetteringCondition"));
    }

    protected void createAddVoucherCondition() {
        $objectMap.put("addVoucherCondition", addVoucherCondition = new JButton());
        
        addVoucherCondition.setName("addVoucherCondition");
        addVoucherCondition.setToolTipText(t("lima.filter.voucher"));
        addVoucherCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addVoucherCondition"));
    }

    protected void createFieldSize() {
        $objectMap.put("fieldSize", fieldSize = new java.awt.Dimension());
    }

    protected void createFinancialTransactionConditionScrollPane() {
        $objectMap.put("financialTransactionConditionScrollPane", financialTransactionConditionScrollPane = new JScrollPane());
        
        financialTransactionConditionScrollPane.setName("financialTransactionConditionScrollPane");
    }

    protected void createFinancialTransactionConditionView() {
        $objectMap.put("financialTransactionConditionView", financialTransactionConditionView = new FinancialTransactionConditionView());
        
        financialTransactionConditionView.setName("financialTransactionConditionView");
    }

    protected void createFinancialTransactionSearchTable() {
        $objectMap.put("financialTransactionSearchTable", financialTransactionSearchTable = new FinancialTransactionDefaultTable(handler));
        
        financialTransactionSearchTable.setName("financialTransactionSearchTable");
        financialTransactionSearchTable.setRowHeight(22);
    }

    protected void createFinancialTransactionSearchTableModel() {
        $objectMap.put("financialTransactionSearchTableModel", financialTransactionSearchTableModel = new FinancialTransactionSearchTableModel());
    }

    protected void createFinancialTransactionSplitpane() {
        $objectMap.put("financialTransactionSplitpane", financialTransactionSplitpane = new JSplitPane());
        
        financialTransactionSplitpane.setName("financialTransactionSplitpane");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FinancialTransactionSearchViewHandler(this));
    }

    protected void createRefresh() {
        $objectMap.put("refresh", refresh = new JButton());
        
        refresh.setName("refresh");
        refresh.setToolTipText(t("lima.refresh.shortcut"));
        refresh.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__refresh"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(toolbar, BorderLayout.PAGE_START);
        add(financialTransactionSplitpane, BorderLayout.CENTER);
        addChildrenToToolbar();
        addChildrenToFinancialTransactionSplitpane();
        addChildrenToFinancialTransactionConditionScrollPane();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(financialTransactionSearchTable);
        
        // apply 16 property setters
        addDateCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-date"));
        addDateIntervalCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-date-interval"));
        addFinancialPeriodCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-financialPeriod"));
        addFiscalPeriodCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-fiscalPeriod"));
        addEntryBookCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-entryBook"));
        addVoucherCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-voucher"));
        addAccountCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-account"));
        addDescriptionCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-description"));
        addLetteringCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-letter"));
        addDebitCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-debit"));
        addCreditCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-credit"));
        refresh.setIcon(SwingUtil.createActionIcon("refresh"));
        financialTransactionSplitpane.setOrientation(JSplitPane.VERTICAL_SPLIT);
        financialTransactionSearchTable.setModel(getFinancialTransactionSearchTableModel());
        financialTransactionSearchTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createSelectedRow();
        createFieldSize();
        createToolbar();
        createAddDateCondition();
        createAddDateIntervalCondition();
        createAddFinancialPeriodCondition();
        createAddFiscalPeriodCondition();
        // inline creation of $JToolBar$Separator0
        $objectMap.put("$JToolBar$Separator0", $JToolBar$Separator0 = new Separator());
        
        $JToolBar$Separator0.setName("$JToolBar$Separator0");
        createAddEntryBookCondition();
        // inline creation of $JToolBar$Separator1
        $objectMap.put("$JToolBar$Separator1", $JToolBar$Separator1 = new Separator());
        
        $JToolBar$Separator1.setName("$JToolBar$Separator1");
        createAddVoucherCondition();
        createAddAccountCondition();
        createAddDescriptionCondition();
        createAddLetteringCondition();
        // inline creation of $JToolBar$Separator2
        $objectMap.put("$JToolBar$Separator2", $JToolBar$Separator2 = new Separator());
        
        $JToolBar$Separator2.setName("$JToolBar$Separator2");
        createAddDebitCondition();
        createAddCreditCondition();
        // inline creation of $JToolBar$Separator3
        $objectMap.put("$JToolBar$Separator3", $JToolBar$Separator3 = new Separator());
        
        $JToolBar$Separator3.setName("$JToolBar$Separator3");
        createRefresh();
        createFinancialTransactionSplitpane();
        createFinancialTransactionConditionScrollPane();
        createFinancialTransactionConditionView();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFinancialTransactionSearchTableModel();
        createFinancialTransactionSearchTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getFinancialTransactionSearchTable().getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

}