package org.chorem.lima.ui.account;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Account;
import static org.nuiton.i18n.I18n.t;

public class UpdateAccountForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ACCOUNT = "account";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DESCRIPTION_TEXT_FIELD_TEXT = "descriptionTextField.text";
    public static final String BINDING_NUMBER_TEXT_FIELD_TEXT = "numberTextField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1WTW/TQBCdBJK0SYF+QGn5UimVAAmcShwQKgJKq6hU4UMUUEUubOxt4nbtNfaauqpA/AR+Aty5IHHjhDhw5sAF8RcQ4sAVMbt2nDhxaWgOVrL75s3My8xL3v6AnOfC6XUSBJrr28K0qLY8v7p6t75OdbFIPd01HcFdCF+ZLGRrUDLic0/AmVpVhpej8PICtxxuU7sjeq4KRU9sMeo1KRUCTiYjdM8rr8TXc4Hjuy3WuKg01te/fmZfGS/fZAECB6sbwlamdotqd7K/ClnTEDCKmZ6RMiN2A8twTbuB9R6QZwuMeN4dYtGn8AIKVcg7xEUyAdP9t6w4VHzgCDjqOwYRdF7XOcZWuGstmoTxhoAL3G1oepO71NKYaRHNNzUSwrSH3UGOoyjzAgpNYhuMugIu/oMgCn1k0s2lEN/BEIEEnOpmwI5MsdWK7giZeUDqjM4KmEjI7W2ieJq6k8jBOKBk+1adulVSpwwFl9oGEXpZHUrcaAw/FMIf0EBUTMrwOxpPhMQXybDh1lya3I5ZjyYxhzswCZpjSVxxZpHrvoUKYJeTndkFRmmty7YmAzPL94hN2Wx3f+o0KUdeJ7YulRhLIG/6QnBbYqZjaJZvyHdno1MXjicUx9XR2qvTnu1MDXKuj8f4FdV6t+0+XoV7NtG1Z5JQ3f4ZH/v64fv7Smu5Spj7SCq0wxtw6B2XOziOpkx9KNwsX5isfJs4czUY9ChDY1HGcSKlsJXoGovDfCMyXJPh2hLxmkiRK3z7+Gn8yZd9kK1AkXFiVIjE34JB0XRRBc6MwLl+Q1U0tDmAz2FZm4AcjjJDiSbUZLcWI1xHbQ13KkA1TqSoEZdUH/z8e2zl3Y2WIhmscHJHeFuV3GPImzYzbaoMJ/KSVIMpOR71Dd72jDQXgZ1txInmsayel3p0yOKcMrkZGCJgZLtrz54L2C/HGwczoVIIC3xJell1Lt9dgeRi95G8QG1pDrjQuTXCPBrnO73doCJq59x5rf3hjuI/d/55WvZun/i/9se307ygrUFRaaDwacl73Ga37JmYebKnW0WwQ5epltVHq1Gykmqj5ThFXBfkuaVzO/ahtKTRVf9pCioN3+hKgf6VRo/Hfch1xKBrxGdigXGP3kVbIZJYwMGrOP1kqm7aBhrntZ4EGfks9pEgz8gW94W89/bOkrO4QeTv2tVwzaeIwL8RdV/QPZcmj4N/lHUGGf4CJTSML70JAAA=";
    private static final Log log = LogFactory.getLog(UpdateAccountForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Account account;
    protected JButton cancel;
    protected JLabel descriptionLabel;
    protected JTextField descriptionTextField;
    protected AccountViewHandler handler;
    protected JLabel numberLabel;
    protected JTextField numberTextField;
    protected JButton ok;
    protected UpdateAccountForm updateAccountFormDialog = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Document $Document0;
    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public UpdateAccountForm() {
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Window param0) {
        super(param0);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateAccount(this);
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        account.setLabel(descriptionTextField.getText());
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        account.setLabel(descriptionTextField.getText());
    }

    public void doWindowClosing__on__updateAccountFormDialog(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Account getAccount() {
        return account;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JLabel getDescriptionLabel() {
        return descriptionLabel;
    }

    public JTextField getDescriptionTextField() {
        return descriptionTextField;
    }

    public AccountViewHandler getHandler() {
        return handler;
    }

    public JLabel getNumberLabel() {
        return numberLabel;
    }

    public JTextField getNumberTextField() {
        return numberTextField;
    }

    public JButton getOk() {
        return ok;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAccount(Account account) {
        Account oldValue = this.account;
        this.account = account;
        firePropertyChange(PROPERTY_ACCOUNT, oldValue, account);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Document get$Document0() {
        return $Document0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToUpdateAccountFormDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void createAccount() {
        $objectMap.put("account", account = null);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createDescriptionLabel() {
        $objectMap.put("descriptionLabel", descriptionLabel = new JLabel());
        
        descriptionLabel.setName("descriptionLabel");
        descriptionLabel.setText(t("lima.label"));
    }

    protected void createDescriptionTextField() {
        $objectMap.put("descriptionTextField", descriptionTextField = new JTextField());
        
        descriptionTextField.setName("descriptionTextField");
        descriptionTextField.setColumns(15);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(AccountView.class,JAXXUtil.PARENT).getHandler());
    }

    protected void createNumberLabel() {
        $objectMap.put("numberLabel", numberLabel = new JLabel());
        
        numberLabel.setName("numberLabel");
        numberLabel.setText(t("lima.account.number"));
    }

    protected void createNumberTextField() {
        $objectMap.put("numberTextField", numberTextField = new JTextField());
        
        numberTextField.setName("numberTextField");
        numberTextField.setColumns(15);
        numberTextField.setEnabled(false);
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToUpdateAccountFormDialog();
        // inline complete setup of $Table0
        $Table0.add(numberLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(numberTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(descriptionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(descriptionTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(cancel);
        $JPanel0.add(ok);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        numberLabel.setLabelFor(numberTextField);
        descriptionLabel.setLabelFor(descriptionTextField);
        cancel.setIcon(SwingUtil.createActionIcon("cancel"));
        ok.setIcon(SwingUtil.createActionIcon("ok"));
        // late initializer
        updateAccountFormDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("updateAccountFormDialog", updateAccountFormDialog);
        createHandler();
        createAccount();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createNumberLabel();
        createNumberTextField();
        createDescriptionLabel();
        createDescriptionTextField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = descriptionTextField.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancel();
        createOk();
        // inline creation of updateAccountFormDialog
        setName("updateAccountFormDialog");
        updateAccountFormDialog.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(t("lima.account.update.form"));
        updateAccountFormDialog.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__updateAccountFormDialog"));
        
        getRootPane().setDefaultButton(ok);// registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NUMBER_TEXT_FIELD_TEXT, true ,"account") {
        
            @Override
            public void processDataBinding() {
                if (getAccount() != null) {
                    SwingUtil.setText(numberTextField, getAccount().getAccountNumber());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DESCRIPTION_TEXT_FIELD_TEXT, true ,"account") {
        
            @Override
            public void processDataBinding() {
                if (getAccount() != null) {
                    SwingUtil.setText(descriptionTextField, getAccount().getLabel());
                }
            }
        });
    }

}